var current = 1;

$(document).ready(function() {
	$('#btn-enquiry').on('click', function(e) {
		e.preventDefault();
		window.scrollTo({ top: $('#enquiry-form').offset().top , behavior: 'smooth' });
	});
	$('div[class^="question-"]').on('click', function () {
		var id = $(this).data('id');
		if (current == id) {
			return;
		}
		$('.answer-' + current).slideToggle(0, function () {
			$('.qa-' + current).css({ 'height' : checkQuestionHeight(current) });
			$('.qa-' + id).css({ 'height' : checkQuestionHeight(id) + checkAnswerHeight(id) });
			$('.answer-' + id).slideToggle("slow", function () {
				current = id;
			});
		});
	});
	$('#btn-register').on('click', function (e) {
		e.preventDefault();
		if ($('INPUT[name="name"]').val().trim() == '') {
			alert ("請輸入姓名");
			return false;
		}
		if ($('INPUT[name="phone"]').val().trim() == '') {
			alert ("請輸入電話號碼");
			return false;
		}
		if ($('INPUT[name="email"]').val().trim() == '') {
			alert ("請輸入電郵地址");
			return false;
		}
		if ($('SELECT[name="age"] option:selected').val() == '') {
			alert ("請選擇年齡組別");
			return false;
		}
		if ($('SELECT[name="gender"] option:selected').val() == '') {
			alert ("請選擇性別");
			return false;
		}
		if ($('INPUT[name="enquiry_item[]"]:checked').length == 0) {
			alert ("請選擇預約項目");
			return false;
		}
		var items = [];
		$('INPUT[name="enquiry_item[]"]:checked').each(function() {
			items.push($(this).attr('id').replace('item-', ''));
		});
		getRemoteData(
			base_url + 'api/booking/submit',
			{
				'name': $('INPUT[name="name"]').val(),
				'phone': $('INPUT[name="phone"]').val(),
				'email': $('INPUT[name="email"]').val(),
				'age': $('SELECT[name="age"]').val(),
				'gender': $('SELECT[name="gender"]').val(),
				'items': items,
			},
			formSubmitted,
			getRemoteDataFail
		);
		return false;
	});

	fixQAHeight();
	// $('.question-1').toggle();
});

function formSubmitted(data)
{
	alert ("你的預約查詢已發出");
	window.location.reload();
	console.log(data);
}

function checkQuestionHeight(element_id) {
	return $('.question-' + element_id).outerHeight();
}

function checkAnswerHeight(element_id) {
	return $('.answer-' + element_id).outerHeight() - 20;
}

function fixQAHeight() {

	for (var i = 1; i <= $('div[class^="question-"]').length; i++) {
		if ($('div[class^="answer-' + i + '"]').is(':hidden')) {
			$('.qa-' + i).css({ 'height' : checkQuestionHeight(i) });
		}
		else {
			$('.qa-' + i).css({ 'height' : checkQuestionHeight(i) + checkAnswerHeight(i) });
		}
	}
}

$(window).bind('resize', function(e){
	window.resizeEvt;
	$(window).resize(function(){
		fixQAHeight();
	});
});

