var open = true;
var drawerWidth = '380px';
var switchLayout = 576;
var times;
var currIdx = 0;
var vimeoOptions = {
	id: vimeo_id,
	loop: false,
	responsive: true,
	byline: false,
};
var vdo_play;
var vimeoPlayer = new Vimeo.Player('video-block', vimeoOptions);
var currentPos = "";

function openDrawer() {
	$('#footerSlideContent').animate({ width: drawerWidth });
	$('#footerSlideButton').animate({ right: drawerWidth });
	$('.main-session > .row').animate({ 'margin-right': drawerWidth });
	open = true;
}

function closeDrawer() {
	$('#footerSlideContent').animate({ width: '0px' });
	$('#footerSlideButton').animate({ right: '0px' });
	$('.main-session > .row').animate({ 'margin-right': '0px' });
	open = false;
}

function closeDrawerNoAnimation() {
	$('#footerSlideContent').width(0);
	$('#footerSlideButton').css({ right: '0px' });
	$('.main-session > .row').css({ 'margin-right': '0' });
	open = false;
}

function clearMessage() {
	$('.chat-message-wrapper').empty();
}

function appendMessage(id) {
	if (id >= chatMessage.length) {
		return;
	}
	let value = chatMessage[id];
	let message;

	if (value['user'] == currentUser) {
		message = $('<div>').addClass('chat-row').html(
			$('<div>').addClass('chat-col-left').html(
				value['full_name'] + '<br />' + value['message']
			)
		).append(
			$('<div>').addClass('chat-col-right').html(
				(value['mode'] == 'Q') ? $('<span>').text('Q') : ''
			).append(
				$('<img>').addClass('img-checkbox').attr({src: base_url + "assets/img/front/checkbox.png"})
			).append(
				$('<img>').addClass('img-functions').attr({src: base_url + "assets/img/front/icon-chat-function.png"})
			)
		);

		$('.chat-message-wrapper').append(
			$('<div>').addClass('chat-message').html(
				message
			)
		);

		if (value['mode'] == 'Q') {
			$('.chat-message-wrapper').append(
				$('<div>').addClass('chat-message').html(
					$('<div>').addClass('chat-row').html(
						$('<div>').addClass('chat-col-left-response').html(
							speaker + '<br />' + value['response']
						)
					).append(
						$('<div>').addClass('chat-col-right-response').html(
							$('<span>').text('A')
						).append(
							$('<img>').addClass('img-checkbox').attr({src: base_url + "assets/img/front/checkbox.png"})
							// ).append(
							//     $('<img>').addClass('img-1pixel').attr( { src: "assets/img/1pixel.png" } )
						)
					)
				)
			);
		}
	}
	else {
		message = $('<div>').addClass('chat-row').html(
			$('<div>').addClass('chat-col-left').html(
				value['full_name'] + '<br />' + value['message']
			)
		).append(
			$('<div>').addClass('chat-col-right').html('')
		);

		$('.chat-message-wrapper').append(
			$('<div>').addClass('chat-message').html(
				message
			)
		);
	}
}

function setTimeUpdate(data) {
	console.log('Timeupdate on');
	$('.chat-duration, .mobile-chat-duration').text(secondsToTime(data.duration - data.seconds));
	currentPos = Math.floor(data.seconds * 1000); //get currentime
//                        vdoEndTym = getAll.duration; //get video duration
//                        percentage = (getAll.percent * 100)+"%";
	console.log('currentPos: ' + currentPos);
	if (currIdx < times.length) {
		console.log('chat: ' + times[currIdx]);
		if ((currentPos - times[currIdx]) > 0) {
			appendMessage(currIdx);
			currIdx++;
		}
	}
	else {
		console.log('Chat record ended.');
	}
}

function rebuildChatMessage(currentSecond) {
	$('.chat-message-wrapper').empty();
	for (let i = 0; i < times.length; i++) {
		if (currentSecond >= times[i]) {
			appendMessage(i);
		}
		else {
			currIdx = i;
			break;
		}
	}
	if (currIdx == times.length) {
		currIdx++;
	}
}

function videoPlay() {

	vimeoPlayer.on('timeupdate', function (data)
	{
		setTimeUpdate(data);
	});
	vimeoPlayer.on('seeking', function (data)
	{
		vimeoPlayer.off('timeupdate');
	});
	vimeoPlayer.on('seeked', function (data)
	{
		console.log('Seeked to: ' + data.seconds);
		currentPos = Math.floor(data.seconds * 1000); //get currentime
		rebuildChatMessage(currentPos);
		console.log('Seeked on');
		setTimeUpdate(data);
	});

}

function videoEnded() {
	console.log('Timeupdate off');
	vimeoPlayer.off('timeupdate');
	console.log('Seeking off');
	vimeoPlayer.off('seeking');
	console.log('Seeked off');
	vimeoPlayer.off('seeked');
}

function sendMessageSuccess(data) {
	videoEnded();
	chatMessage = [];
	times = [];
	console.log(data);
	for (let i = 0; i < data['chat_history'].length; i++) {
		let row = data['chat_history'][i];
		chatMessage.push({
			user: row['user_id'],
			full_name: row['full_name'],
			message: row['message'],
			mode: row['mode'],
			time: row['post_time'],
		});
		times.push (Math.floor(row['post_time']));
	}
	rebuildChatMessage(currentPos);
	videoPlay();
	$('INPUT[class="send-message"]').val('');
}

$(window).bind('resize', function(e){
	window.resizeEvt;
	$(window).resize(function(){
		clearTimeout(window.resizeEvt);
		window.resizeEvt = setTimeout(function(){
			if ($(window).width() > switchLayout) {
				// $('#footerSlideButton').show();
				openDrawer();
			}
			else {
				closeDrawerNoAnimation();
			}
		}, 250);
	});
});

$(document).ready(function () {
	$('#footerSlideButton').click(function() {
		// $(this).hide()
		if(open === false) {
			openDrawer();
		} else {
			closeDrawer();
		}
		// $('#footerSlideButton').show();
	});
	// $('.img-selling-ads, .img-selling-ads-chat').on('click', function () {
	// 	console.log("selling");
	// 	window.location.href = base_url + 'selling/promote/' + access_token;
	// });
	$('.send-message-icon').on('click', function () {
		let mode = $(this).attr('data-content');
		let message;
		switch(mode) {
			case "mobile":
				message = $('INPUT[name="mobile-message"]').val();
				break;
			default:
				message = $('INPUT[name="message"]').val();
				break;
		}
		if (message.trim() == '') {
			return;
		}
		getRemoteData(
			base_url + 'api/chat/post',
			{
				webinar: webinar_token,
				user_id: currentUser,
				time: currentPos,
				mode: 'M',
				message: message,
			},
			sendMessageSuccess,
			getRemoteDataFail,
		);
	});
	clearMessage();
	if ($(window).width() > switchLayout) {
		openDrawer();
	}
	times = [];
	chatMessage.map(function (value, index) {
//                var second = value['time'].split('.');
//                times.push(parseInt(second[0]) * 60 + parseInt(second[1]));
		times.push (Math.floor(value['time']));
	});
	vimeoPlayer.ready().then(function () {
		console.log('Vimeo player is ready.');
		vimeoPlayer.getDuration().then(function(duration) {
			$('.chat-duration, .mobile-chat-duration').text(secondsToTime(duration));
		});
		vimeoPlayer.on('play', function ()
		{
			videoPlay();
			// $('.video-block-wrapper').show();
			// $('.selling-block-wrapper').hide();
			// $('.selling-ads').hide();
		});
		vimeoPlayer.on('pause', function ()
		{
			console.log('Vimeo player is pause.');
			videoEnded();
		})
		vimeoPlayer.on('ended', function ()
		{
			videoEnded();
			// $('.video-block-wrapper').hide();
			// $('.selling-block-wrapper').show();
			// $('.selling-ads').show();
		});
	});
});
