var open = true;
var drawerHeight = '100px';
let currentTimeslotIdx = 0;
let now = moment();
let timeslots = buildTimeslots(now, times);
let selectedTimeslotsId = -1;

// var timeslot = [
// 	{
// 		'time': '2021年3月4日 星期四 下午04:30',
// 		'time_remain': '13分鐘後開始',
// 	},
// 	{
// 		'time': '2021年3月4日 星期四 下午08:00',
// 		'time_remain': '3小時後開始',
// 	},
// 	{
// 		'time': '2021年3月5日 星期五 上午11:00',
// 		'time_remain': '18小時後開始',
// 	},
// 	{
// 		'time': '2021年3月5日 星期五 下午03:00',
// 		'time_remain': '22小時後開始',
// 	},
// 	{
// 		'time': '2021年3月5日 星期五 下午08:00',
// 		'time_remain': '27小時後開始',
// 	},
// 	{
// 		'time': '2021年3月6日 星期五 上午11:00',
// 		'time_remain': '42小時後開始',
// 	},
// 	{
// 		'time': '2021年3月6日 星期五 下午03:00',
// 		'time_remain': '46小時後開始',
// 	},
// 	{
// 		'time': '2021年3月6日 星期五 下午08:00',
// 		'time_remain': '51小時後開始',
// 	},
// ];
//
function checkInputStatus() {
	if (($('#seminar-date').val().trim() !== "") &&
		($('#seminar-location').val().trim() !== "") &&
		($('#seminar-participant').val().trim() !== "") &&
		($('#seminar-email').val().trim() !== "")) {
		return true;
	}
	return false;
}

function webinarTimeslots() {
	$('.webinar-timeslots').empty();
	for(let i = currentTimeslotIdx; i < currentTimeslotIdx + 3; i++) {
		$('.webinar-timeslots').append(
			$('<p>').text(fullDateInChinese(moment(timeslots[i])))
		);
	}
}

function buildSeminarTimeslot() {
	let calendar = $('.calendar-wrapper');
	let _time;
	calendar.empty();
	for (let i = currentTimeslotIdx; i < currentTimeslotIdx + 7; i++) {
		_time = $('<div>').addClass('seminar-record no-select').attr({ 'data-value': i }).html (
//			$('<div>').addClass('seminar-time').text(timeslot[i]['time'])
			$('<div>').addClass('seminar-time').text(fullDateInChinese(moment(timeslots[i])))
		).append(
//			$('<div>').addClass('seminar-remain').text(timeslot[i]['time_remain'])
			$('<div>').addClass('seminar-remain').text('')
		);
		calendar.append(_time);
	}
	$('.seminar-record').on('click', function () {
		selectedTimeslotsId = $(this).attr('data-value');
		$('#seminar-date').val(timeslots[selectedTimeslotsId]);
		$(".form-wrapper").hide();
	});
}

function checkWindowSize() {
	drawerHeight = '100px';
	if ($(window).width() <= 990) {
		drawerHeight = '250px';
	}
	// else {
	//     if ($(window).width() < 768) {
	//         drawerHeight = '150px';
	//     }
	// }
}

$(window).bind('resize', function(e){
	window.resizeEvt;
	$(window).resize(function(){
		clearTimeout(window.resizeEvt);
		window.resizeEvt = setTimeout(function(){
			checkWindowSize();
			if (open) {
				$('#footerSlideContent').animate({ height: drawerHeight });
				$(this).css('backgroundPosition', 'bottom left');
			}
		}, 250);
	});
});
// $(window).resize(function () {
//     drawerHeight = '100px';
//     if ($(window).width() < 720) {
//         drawerHeight = '150px';
//     }
// });

function registerSuccess(data) {
	$('.step-1').hide();
	$('#myModal .modal-main.step-2 .registered-date').text(fullDateInChinese(moment(timeslots[selectedTimeslotsId])));
	$('#myModal .modal-footer.step-2 .seminar-link').text(base_url + 'webinar/' + data['seminar_token']);
	$('.step-2').show();
}

$(document).ready(function() {
	moment.locale('zh-hk');
	$('#register-button').on('click', function(event) {
		$("#myModal").modal({backdrop: 'static', keyboard: false});
		$('#seminar-date, #seminar-participant, #seminar-email').val('');
		$(".step-1").show();
		$(".step-2, .form-wrapper").hide();
	});
	$('.add-calendar-button').on('click', function(event) {
		$("#addCalendar").modal('hide');
	});
	$('.close-calendar-button').on('click', function(event) {
		$("#addCalendar").modal('hide');
	});
	$('#register-now-button').on('click', function(event) {
		if ($(this).hasClass('button-disabled')) {
			return;
		}
		getRemoteData(
			base_url + 'api/webinar/register',
			{
				landing: seminar_title,
				date: $('#seminar-date').val(),
				location: $('#seminar-location').val(),
				participant: $('#seminar-participant').val(),
				email: $('#seminar-email').val(),
			},
			registerSuccess,
			getRemoteDataFail,
		);
	});
	$('.registered-alert').on('click', function(event) {
		$("#myModal").modal('hide');
		$("#addCalendar").modal({backdrop: 'static', keyboard: false});
	});
	$('.calendar-more').on('click', function () {
		if ($('.calendar-wrapper').is(":visible")) {
			$(".calendar-wrapper").hide();
		}
		else {
			$(".calendar-wrapper").show();
		}
	});
	$('#footerSlideButton').click(function() {
		if(open === false) {
			$('#footerSlideContent').animate({ height: drawerHeight });
			$(this).css('backgroundPosition', 'bottom left');
			// $('#footerSlideButton > img').attr('src', 'assets/img/drawer-close.png');
			open = true;
		} else {
			$('#footerSlideContent').animate({ height: '0px' });
			$(this).css('backgroundPosition', 'top left');
			// $('#footerSlideButton > img').attr('src', 'assets/img/drawer-open.png');
			open = false;
		}
	});
	$('#seminar-date, #seminar-participant, #seminar-email').on('keyup keypress blur change', function () {
		if (checkInputStatus()) {
			$('#register-now-button').removeClass('button-disabled');
		}
		else {
			$('#register-now-button').addClass('button-disabled');
		}
	});
	checkWindowSize();
	$('#footerSlideContent').animate({ height: drawerHeight });
	$('#footerSlideButton').css('backgroundPosition', 'bottom left');
	buildSeminarTimeslot();
	webinarTimeslots();

	var countDownDate = moment(timeslots[currentTimeslotIdx]);

	var x = setInterval(function() {

		// Get today's date and time
		var now = moment();

		// Find the distance between now and the count down date
		var distance = countDownDate.diff(moment());

		// Time calculations for days, hours, minutes and seconds
		var days = Math.floor(distance / (1000 * 60 * 60 * 24));
		var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
		var seconds = Math.floor((distance % (1000 * 60)) / 1000);

		// Display the result in the element with id="demo"
		$('.webinar-countdown .time.days').text(("00" + days).slice (-2));
		$('.webinar-countdown .time.hours').text(("00" + hours).slice (-2));
		$('.webinar-countdown .time.minutes').text(("00" + minutes).slice (-2));
		$('.webinar-countdown .time.seconds').text(("00" + seconds).slice (-2));
//		document.getElementById("demo").innerHTML = days + "d " + hours + "h "	+ minutes + "m " + seconds + "s ";

		if ($('#myModal').hasClass('show')) {
			if ($('#myModal .step-1').is(":visible")) {
				for(let i = currentTimeslotIdx; i < currentTimeslotIdx + 7;i++) {
					duration = moment.duration(moment(timeslots[i]).diff(moment()));
					hourdiff = Math.floor(duration.asHours());
					if (hourdiff == 0) {
						mindiff = Math.floor(duration.asMinutes());
						time = mindiff + "分鐘";
					}
					else {
						time = hourdiff + "小時";
					}
					$('.seminar-record[data-value=' + i + '] .seminar-remain').text(time + '後開始');
				}
//				console.log('Step-1 is visible');
			}
		}
//		console.log("myModal status:" + $('#myModal').hasClass('show'));

		// If the count down is finished, write some text
		if (distance < 0) {
//			clearInterval(x);
//			currentTimeslotIdx++;
//			webinarTimeslots();
			now = moment();
			timeslots = buildTimeslots(now, times);
			countDownDate = moment(timeslots[currentTimeslotIdx]);
			buildSeminarTimeslot();
			webinarTimeslots();
		}
	}, 1000);
});
