let currentTimeslotIdx = 0;
let now = moment();
let timeslots = buildTimeslots(now, times);

function webinarTimeslots() {
	$('.webinar-timeslots').empty();
	for(let i = currentTimeslotIdx; i < currentTimeslotIdx + 3; i++) {
		$('.webinar-timeslots').append(
			$('<p>').text(fullDateInChinese(moment(timeslots[i])))
		);
	}
}

$(document).ready(function() {
	moment.locale('zh-hk');
	$('#register-button > img').on('click', function(event) {
		window.location.href = base_url + 'register/register/' . seminar_token;
	});
	webinarTimeslots();

	var countDownDate = moment(timeslots[currentTimeslotIdx]);

// Update the count down every 1 second
	var x = setInterval(function() {

		// Get today's date and time
		now = moment();

		// Find the distance between now and the count down date
		var distance = countDownDate.diff(moment());

		// Time calculations for days, hours, minutes and seconds
		var days = Math.floor(distance / (1000 * 60 * 60 * 24));
		var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
		var seconds = Math.floor((distance % (1000 * 60)) / 1000);

		// Display the result in the element with id="demo"
		$('.webinar-countdown .time.days').text(("00" + days).slice (-2));
		$('.webinar-countdown .time.hours').text(("00" + hours).slice (-2));
		$('.webinar-countdown .time.minutes').text(("00" + minutes).slice (-2));
		$('.webinar-countdown .time.seconds').text(("00" + seconds).slice (-2));
//		document.getElementById("demo").innerHTML = days + "d " + hours + "h "	+ minutes + "m " + seconds + "s ";

		// If the count down is finished, write some text
		if (distance < 0) {
//			clearInterval(x);
//			currentTimeslotIdx++;
//			now = moment();
			timeslots = buildTimeslots(now, times);
			webinarTimeslots();
			countDownDate = moment(timeslots[currentTimeslotIdx]);
		}
	}, 1000);
});
