// if (typeof seminar_token === 'undefined') {
// 	let seminar_token = 'tP0jMt25MIpodFhf';
// }
//
function fullDateInChinese(dt) {
	return dt.format("LL") + ' ' + moment.weekdays(dt.day()) + ' ' + dt.format("ahh:mm");
}

function secondsToTime(duration) {
	var date = new Date(0);
	date.setSeconds(duration); // specify value for SECONDS here
	return date.toISOString().substr(11, 8);
}

function buildTimes (startDate, timeslots, startPos) {
	let result = [];
	let sd = startDate;
	let sp = startPos;
	for(let i = 0; i < 7; i++) {
		result.push (sd + ' ' + timeslots[sp] + ':00');
		sp++;
		if (sp > timeslots.length - 1) {
			sp = 0;
			sd = moment(sd).add(1, 'day').format("YYYY-MM-DD");
		}
	}
	return result;
}

function buildTimeslots (dt, timeslots) {

	let result = [];
	let currentTime = dt.format('HH:mm');
	let startDate = dt.format('YYYY-MM-DD');
	if (currentTime > timeslots[timeslots.length - 1]) {
		startDate = dt.add(1, 'day').format("YYYY-MM-DD");
		return buildTimes(startDate, timeslots, 0);
	}
	if (currentTime < timeslots[0]) {
		return buildTimes(startDate, timeslots, 0);
	}
	for (let i = timeslots.length - 2; i >= 0; i--) {
		if (currentTime > timeslots[i]) {
			return buildTimes(startDate, timeslots, i + 1);
		}
	}
}

function timeSlotPos(dt, timeslots) {
	let currentTime = dt.format('HH:mm');
	if (currentTime < timeslots[0]) {
		return 0;
	}
	if (currentTime > timeslots[timeslots.length - 1]) {
		return timeslots.length;
	}
	if (currentTime == timeslots[timeslots.length - 1]) {
		return timeslots.length - 1;
	}
	for(let i = 0; i < timeslots.length - 1; i++) {
		if (currentTime == timeslots[i]) {
			return (i * 2) + 1;
		}
		if ((currentTime > timeslots[i]) && (currentTime < timeslots[i + 1])) {
			return (i * 2) + 2;
		}
	}
}

function getRemoteData(remote_url, data, callback, callbackFail) {
	$.ajax ({
		//async: false,
		//timeout: 30000, //最長等候回應時間
		type: "GET", //提交類型
		url: remote_url, //提交地址
		data: data, //提交內容
		dataType: 'json', //返回數據類型
		success: function(data) { //請求完成並成功
			if (data.success) {
				callback(data.data);
			} else {
				callbackFail();
			}
		},
		error: function(data) { //請求返回錯誤信息
			callbackFail();
		},
		beforeSend: function(XHR) { //请求開始前执行
		},
		complete: function(XHR, status) { //请求完成后最终执行
		}
	});
}

function postRemoteData(remote_url, data, callback, callbackFail) {
	$.ajax ({
		//async: false,
		//timeout: 30000, //最長等候回應時間
		type: "POST", //提交類型
		url: remote_url, //提交地址
		data: data, //提交內容
		dataType: 'json', //返回數據類型
		success: function(data) { //請求完成並成功
			if (data.success) {
				callback(data.data);
			} else {
				callbackFail();
			}
		},
		error: function(data) { //請求返回錯誤信息
			callbackFail();
		},
		beforeSend: function(XHR) { //请求開始前执行
		},
		complete: function(XHR, status) { //请求完成后最终执行
		}
	});
}

function getRemoteDataFail() {
	alert("發生錯誤");
}
