var table, data = [];
var ids = [];
var checkall = false;

$(document).ready(function () {
	let $tbl = $('#myTable');
	const url = $tbl.data('url');
	const pagesize = $tbl.data('pagesize');
	table = $tbl.DataTable({
		"processing": true,
		"serverSide": true,
		"ajax": url,
		"columns": [
			{"data": "id"},
			{"data": "name", "name": "影片名稱"},
			{"data": "create_time", "name": "最後修改日期時間"},
			{"data": "details", "name": "詳情", "class": "control-details"},
			{"data": "delete", "name": "刪除", "class": "control-delete"},
		],
		"order": [
			[0, "desc"],
		],
		"columnDefs": [
			{
				"targets": [0],
				"visible": false,
				"searchable": false,
			},
			// {
			// 	"targets": [1, 2, 3, 4, 6],
			// 	"visible": true,
			// 	"searchable": true,
			// 	"orderable": true,
			// },
			// {
			// 	"targets": [5, 7],
			// 	"visible": true,
			// 	"searchable": false,
			// 	"orderable": true,
			// },
			{
				"targets": [3,4],
				"visible": true,
				"searchable": false,
				"orderable": false,
			},
		],
		language: {
			"processing": "處理中...",
			"loadingRecords": "載入中...",
			"lengthMenu": "顯示數量 _MENU_ ",
			"zeroRecords": "沒有符合的結果",
			"info": "顯示 _START_-_END_（總數：_TOTAL_）",
			"infoEmpty": "0 項結果",
			"infoFiltered": "(從 _MAX_ 項結果中過濾)",
			"infoPostFix": "",
			"search": "搜尋:",
			"paginate": {
				"first": "首頁",
				"previous": "上一頁",
				"next": "下一頁",
				"last": "末頁"
			},
			"aria": {
				"sortAscending": ": 升冪排列",
				"sortDescending": ": 降冪排列"
			}
		},
		"pageLength":pagesize,
		"pagingType": "full_numbers",
		"drawCallback": function (settings) {
			var info = table.page.info();
			// console.log('pageinfo:',info);
			// console.log('Currently showing page '+(info.page+1)+' of '+info.pages+' pages.');
			$('.recorddisplay').text(info.recordsDisplay);
			$('.pagenum').val(info.page+1);
//                console.log(settings['json']['data']);
//                data = settings['json']['data'];//don't use this data, as it is filtered=>not all
			$('.nextpage').on('click',function(){
				$('#myTable_next').trigger('click');
			});
			$('.prevpage').on('click',function(){
				$('#myTable_previous').trigger('click');
			});

			//todo: to verify...
			$.each(ids, function (k, v) {
				$('.checkbox-delete').each(function (i, e) {
					if (v === $(e).attr('id')) {
						$(e).prop('checked', true);
						return false;
					}
				});
			});
			$('i[id^="details-"]').on('click', function (event) {
				event.preventDefault();
				var newForm = $('<form>', {
					'action': base_url + 'at-admin/video/edit',
					'method': 'post',
				}).append($('<input>', {
					'name': 'id',
					'value': this.id.replace('details-', ''),
					'type': 'hidden'
				}));
				$(document.body).append(newForm);
				newForm.submit();
			});
		},
	});

	$('#myTable_filter').hide();
	$('.dataTables_length').hide();
	// $('#myTable_info').hide();
	// $('#myTable_paginate').hide();
});

function doFilter(keyword) {
	let s = table.columns().search('');
	if (keyword !== '') {
		s = s.columns(1).search(keyword);
	}
	s.draw();
	$('#myTable_filter').hide();
	$('.dataTables_length').hide();
	// $('#myTable_info').hide();
	// $('#myTable_paginate').hide();
}

$(document).on('click', '#btnSubmit', function () {
	if (ids.length > 0) {
		if (confirm('確定要刪除這(些)項目?')) {
			ids = ids.join();
//                console.log('ids:', ids);
//                return false;
			var newForm = $('<form>', {
				'action': checkall ? '/video/deleteall' : '/video/delete',
				'method': 'post',
			}).append($('<input>', {
				'name': 'ids',
				'value': ids,
				'type': 'hidden'
			}));
			$(document.body).append(newForm);
			newForm.submit();
		}
	} else {
		alert('請選擇要刪除的項目。');
	}
});

$(document).on('change', '.checkbox-delete', function () {
	var id = $(this).attr('id');
	if (this.checked && ids.indexOf(id) === -1) {
		ids.push(id);
	} else {
		var idx = ids.indexOf(id);
		if (idx > -1) {
			ids.splice(idx, 1);
		}
		checkall = false;
		$('.checkbox-delete-all').prop('checked', false);
	}
	if (ids.length > 0) {
		$.each(ids, function (i, e) {
			if (e === id) {
				$(this).prop('checked', true);
			}
		});
	}
});

$(document).on('change', '.checkbox-delete-all', function () {
	if (this.checked) {
		getRemoteData(
			"/api/video/getallids",
			{},
			getAllIdsOk,
			getRemoteDataFail
		);
	} else {
		ids = [];
	}
	$('.checkbox-delete').prop('checked', this.checked);
	checkall = this.checked;
});

function getAllIdsOk(Ids) {
	ids = Ids;
}

$(document).on('click', '.btn-delete',function(){
	if(ids.length===0){
		$.fancybox.open($('#myTable').data('delitemreq'));
		return false;
	}
	if(confirm($('#myTable').data('del'))){
		$.post( "/api/video/deletebulk", { ids: ids })
			.done(function( data ) {
				window.location.reload(true);
			});
	}
});

$(document).on('click', '#btnSearch', function () {
	const keyword=$('#keyword').val();
	if(keyword!==''){
		doFilter(keyword.trim());
	}
});
$(document).on('change','#keyword',function(){
	if($(this).val()===''){
		window.location.reload(true);
	}
});
