<!DOCTYPE html>
<html>

<head>
	<?php
		$this->load->view('front/includes/html_header');
	?>
	<script src="https://js.stripe.com/v3/"></script>
</head>

<body>
<section class="container logo-section">
	<div class="row">
		<div class="col-12">
			<a href="<?=$base_url;?>"><img src="<?=$base_url;?>assets/img/front/logo.png" /></a>
		</div>
	</div>
</section>

<section class="selling-section">
	<div class="container">
		<div class="row">
			<div class="col-12 col-lg-6 selling-column">
				<div class="selling-block-wrapper">
					<div class="row">
						<div class="col-6">
							<h2 class="main-title-text font-bolder">檢視你的訂單</h2>
						</div>
						<div class="col-6 text-right">
							<p class="font-small"><span class="font-red">*</span>必填欄位</p>
						</div>
					</div>
					<div class="row selling-block">
						<div class="col-12">
							<div class="row">
								<div class="col-3">
									<img class="img-fluid featured-photo" src="<?=$base_url;?>assets/img/front/uploads/featured/nlp.png" />
								</div>
								<div class="col-9 my-auto">
									<h4><?=$course['name'];?></h4>
									<p><?=$course['introduction'];?></p>
								</div>
							</div>
							<div class="row">
								<div class="col-12">
									<hr />
								</div>
							</div>
							<div class="row">
								<div class="col-6">
									<p class="font-bolder">今日交付（港幣）</p>
								</div>
								<div class="col-6 text-right">
									<p><?='$' . number_format($webinar['discounted_price'], 2, '.', ',');?></p>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="selling-block-wrapper">
					<div class="row">
						<div class="col-4">
							<h2 class="main-title-text font-bolder text-nowrap">帳戶資料</h2>
						</div>
						<div class="col-8 text-right">
							<p class="font-small text-nowrap">建立一個帳戶查詢您所購買項目的相關資料</p>
						</div>
					</div>
					<div class="row selling-block">
						<div class="col-12">
							<form>
								<div class="form-group">
									<label for="user-email"><span class="font-red">*</span>電子郵箱</label>
									<input type="email" class="form-control" id="user-email" />
								</div>
								<div class="form-group">
									<label for="user-fullname"><span class="font-red">*</span>姓名</label>
									<input type="text" class="form-control" id="user-fullname" />
								</div>
								<div class="form-group">
									<input type="checkbox" class="form-check-input" id="user-edm" />
									<label for="user-edm">我同意收到教學及宣傳電郵</label>
								</div>
							</form>
						</div>
					</div>
				</div>
				<div class="selling-block-wrapper">
					<div class="row">
						<div class="col-12">
							<h2 class="main-title-text font-bolder">帳單地址</h2>
						</div>
					</div>
					<div class="row selling-block">
						<div class="col-12">
							<form>
								<div class="form-group">
									<label for="billing-country"><span class="font-red">*</span>國家</label>
									<select class="form-control" id="billing-country">
										<option value="cn">中國</option>
									</select>
								</div>
								<div class="form-group">
									<label for="billing-address"><span class="font-red">*</span>街道地址</label>
									<input type="text" class="form-control" id="billing-address" />
								</div>
								<div class="row">
									<div class="col-6">
										<div class="form-group">
											<label for="billing-city"><span class="font-red">*</span>城市</label>
											<select class="form-control" id="billing-city">
												<option value=""></option>
											</select>
										</div>
									</div>
									<div class="col-6">
										<div class="form-group">
											<label for="billing-postal">郵政編碼（可選）</label>
											<input type="text" class="form-control" id="billing-postal" />
										</div>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-12 btn-order-confirm">
						<p class="text-center my-auto">確認訂單</p>
					</div>
				</div>
			</div>
			<div class="col-12 col-lg-6 selling-column">
				<div class="selling-block-wrapper">
					<h2 class="main-title-text font-bolder underline">學員分享</h2>
					<div class="testimonial-block">
						<div class="row">
							<div class="col-12 d-flex">
								<img class="testimonial-photo d-block mx-auto" src="<?=$base_url;?>assets/img/front/uploads/testimonal/ouvin-or.png" />
							</div>
						</div>
						<div class="row">
							<div class="col-12">
								<h5 class="text-center">完成 Tommy Sir 課堂後，透過 NLP Coaching 釐清了自己的價值觀，轉了一個適合自己的行業，除左加薪外，最重要能有更愉快的工作生活。</h5>
								<p class="text-center">Ouvin Or, 廣告業 — 品牌經理</p>
							</div>
						</div>
					</div>
					<div class="testimonial-block">
						<div class="row">
							<div class="col-12 d-flex">
								<img class="testimonial-photo d-block mx-auto" src="<?=$base_url;?>assets/img/front/uploads/testimonal/becky-yu.png" />
							</div>
						</div>
						<div class="row">
							<div class="col-12">
								<h5 class="text-center">課程提升了我的 EQ，更有效與不同人士相處。亦提升了我面試與演講技巧，因此，我可以在面試時輕鬆地完成演講及應對不同的問題。最後，成功獲得一個更好和職級更高的職位。</h5>
								<p class="text-center">Becky Yu, 公營機構 — 市場營銷</p>
							</div>
						</div>
					</div>
					<div class="selling-block-wrapper selling-course">
						<div class="row">
							<div class="col-12">
								<h2 class="main-title-text font-bolder underline">網上企業教練證書課程</h2>
								<h5>單元１ — 基礎理論及成功心態</h5>
								<h5>單元２ — 高效商業溝通技巧</h5>
								<h5>單元３ — 洽商／調解語言模式</h5>
								<h5>單元４ — 提昇狀態至卓越表現</h5>
								<h5>單元５ — NLP執行師技巧</h5>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="contact-section">
	<div class="container">
		<div class="row">
			<div class="col-lg-4 order-lg-1 col-md-6 pt-5">
				<img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/logo-nlp.png" />
				<p class="small">九龍彌敦道221-221A同昌商業大厦14樓全層</p>
				<p class="small">電話：852-2377 0398</p>
				<p class="small">傳真：852-3422 8662</p>
				<p class="small">電郵：info@nlp.hk</p>
				<div class="row payment-section">
					<div class="col-12 col-md-3 pr-0">
						<p class="small">付款方式：</p>
					</div>
					<div class="col-12 col-md-9 mt-2 stripe-block">
						<table class="table">
							<tr>
								<td class="stripe-section"><img src="<?=$base_url;?>assets/img/front/logo-stripe.png" /></td>
								<td class="border-bottom full-width"><p>&nbsp;</p></td>
							</tr>
							<tr>
								<td colspan="2" class="left-right-border p-2">
									<div class="row h-100">
										<div class="col-3 my-auto adjust-padding adjust-padding-first"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-visa.png" /></div>
										<div class="col-3 my-auto adjust-padding"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-mastercard.png" /></div>
										<div class="col-3 my-auto adjust-padding"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-american-express.png" /></div>
										<div class="col-3 my-auto adjust-padding adjust-padding-last"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-jcb.png" /></div>
									</div>
								</td>
							</tr>
							<tr>
								<td colspan="2" class="left-right-border border-bottom p-2">
									<div class="row h-100">
										<div class="col-6 my-auto adjust-padding adjust-padding-first"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-discover.png" /></div>
										<div class="col-6 my-auto adjust-padding adjust-padding-last"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-diners-club.png" /></div>
									</div>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>
			<div class="col-lg-3 order-lg-2 col-md-6 pt-5">
				<img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/nlp-fb-page.png" />
			</div>
			<div class="col-lg-4 order-lg-3 pt-5 col-md-12">
				<p>如果你想收到我們最新消息、課程動態，請填寫電郵登記。</p>
				<div class="form-group">
					<input class="form-control" />
				</div>
				<p>現在登記更可獲贈著名 NLP 導師 Ken Ward 設計的”NLP一分鐘激勵自己”與及 Mr. Dylan Morgan 出版的 “催眠入門”電子書各一。</p>
				<div class="row pt-4">
					<div class="col-12 seperator-white">
						<div id="send-button"><img class="d-block click-button" src="<?=$base_url;?>assets/img/front/btn-send.png" /></div>
					</div>
				</div>
				<div class="row pt-3">
					<div class="col social-icon"><a href="#" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/facebook.png" /></a></div>
					<div class="col social-icon"><a href="#" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/twitter.png" /></a></div>
					<div class="col social-icon"><a href="https://www.youtube.com/channel/UC484WBIUpdjUwlymZ2aSutQ" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/youtube.png" /></a></div>
					<div class="col social-icon"><a href="#" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/instagram.png" /></a></div>
					<div class="col social-icon"><a href="#" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/linkedin.png" /></a></div>
				</div>
			</div>
		</div>
	</div>
</section>
<footer class="p-3 footer-section">
	<div class="container">
		<p class="text-center text-white m-0 small">&copy; Copyright 2004 - 2021 | All Rights Reserved</p>
	</div>
</footer>
<script>
	let base_url = '<?=$base_url;?>';
	let access_token = '<?=$access_token;?>';
</script>
<?php
	$this->load->view('front/includes/html_footer');
?>
</body>

</html><?php
