<!DOCTYPE html>
<html>

<head>
	<?php
		$this->load->view('front/includes/html_header');
	?>
</head>

<body>
<session class="main-session">
	<div class="row no-gutters align-items-stretch min-h-100vh-fixed">
		<div class="col-12 col-md-7 d-flex align-items-sm-stretch">
			<div class="w-100 introduction">
				<div class="tutor-profile">
					<img id="sarah-hui-pic" src="<?=base_url('assets/img/front/sarah-hui.png');?>" />
					<div class="container pt-2 pb-2">
						<div class="row">
							<div class="col-6 text-right">
								<h2 class="title-color">Sarah Hui</h2>
								<p>許秀香</p>
							</div>
						</div>
					</div>
				</div>
				<div class="message-bar">
					<div class="container pt-2 pb-2">
						<div class="row">
							<div class="col-6 text-right">
								<p>資深兒童心理輔導訓練導師</p>
								<p>V Brain尚智首席顧問及營運總監</p>
								<p>韓國認証神經反饋培訓導師及諮詢師</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="col-12 col-md-5 d-flex align-items-sm-stretch">
			<div class="w-100 main-content-wrapper" style="background-image:url(<?=base_url('assets/img/front/register-bg.png');?>);">
				<div class="container h-100">
					<div class="row align-items-center h-100 main-content">
						<div class="col-12 mx-auto pr-0 pl-0">
							<div class="pt-3 pb-3" style="background-color: #ffe4d4;">
								<h2 class="seminar-title">免費網上家長講座</h2>
								<p class="seminar-tutor">導師：<span style="font-size: 2rem; font-weight: 400; color: #515151;">Sarah Hui</span></p>
							</div>
							<div class="pt-3">
								<p style="text-align: center;">（免費網上簡介講座約60分鐘，導師會以廣東話演說）</p>
							</div>
							<div class="pt-5 pb-5">
								<p style="text-align: center;"><a href="#">條款及細則</a></p>
								<p style="text-align: center;"><a href="#">隱私政策</a></p>
								<p style="text-align: center;"><a href="#">DMCA</a></p>
							</div>
						</div>
						<!--							<h4 class="seminar-slogan">3個月考取國際證書，掌握高收入能力</h4>-->
					</div>
				</div>
			</div>
		</div>
	</div>
</session>
<div class="modal fade" id="myModal">
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<!-- Modal Header -->
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>

			<!-- Modal body -->
			<div class="modal-body">
				<div class="modal-title">
					<h4>免費網上家長講座</h4>
				</div>
				<div class="modal-main step-1">
					<form>
						<div class="input-group">
							<div class="input-group-addon before-inputbox d-flex">
								<img class="mx-auto d-block my-auto" src="<?=$base_url;?>assets/img/front/icon-calendar.png" />
							</div>
							<input type="text" class="form-control" placeholder="選擇日期..." id="seminar-date" readonly />
							<div class="input-group-addon after-inputbox d-flex calendar-more">
								<img class="mx-auto d-block my-auto" src="<?=$base_url;?>assets/img/front/icon-more.png" />
							</div>
							<div class="calendar-wrapper form-wrapper">
							</div>
						</div>
						<div class="input-group">
							<div class="input-group-addon before-inputbox d-flex">
								<img class="mx-auto d-block my-auto" src="<?=$base_url;?>assets/img/front/icon-clock.png" />
							</div>
							<input type="text" class="form-control" placeholder="" value="香港" id="seminar-location" readonly />
							<div class="input-group-addon after-inputbox d-flex">
								<img class="mx-auto d-block my-auto" src="<?=$base_url;?>assets/img/front/icon-more.png" />
							</div>
						</div>
						<div class="input-group">
							<div class="input-group-addon before-inputbox d-flex">
								<img class="mx-auto d-block my-auto" src="<?=$base_url;?>assets/img/front/icon-person.png" />
							</div>
							<input type="text" class="form-control border-right" placeholder="" id="seminar-participant" value="" />
							<!--                                <div class="input-group-addon after-inputbox d-flex">-->
							<!--                                    <img class="mx-auto d-block my-auto" src="<?=$base_url;?>assets/img/front/icon-more.png" />-->
							<!--                                </div>-->
						</div>
						<div class="input-group">
							<div class="input-group-addon before-inputbox d-flex">
								<img class="mx-auto d-block my-auto" src="<?=$base_url;?>assets/img/front/icon-envelope.png" />
							</div>
							<input type="email" class="form-control border-right" placeholder="" id="seminar-email" value="" />
							<!--                                <div class="input-group-addon after-inputbox d-flex">-->
							<!--                                    <img class="mx-auto d-block my-auto" src="<?=$base_url;?>assets/img/front/icon-more.png" />-->
							<!--                                </div>-->
						</div>
					</form>
				</div>
				<div class="modal-main step-2 text-center">
					<p class="registered-tutor">導師：<span class="registered-tutor-name">Sarah Hui</span></p>
					<p class="registered-date">2021年3月4日 星期四 下午04:30</p>
					<p class="registered-location">香港</p>
					<div class="registered-alert">設定提醒</div>
				</div>
			</div>

			<!-- Modal footer -->
			<div class="modal-footer step-1">
				<div class="btn button-disabled" id="register-now-button">立即註冊</div>
				<p class="small">您的詳細信息將轉發給網絡研討會組織者，<br />該組織者可能會就此事件或他們的服務與您進行溝通</p>
			</div>
			<div class="modal-footer step-2">
				按以下連結，進入網上講座：
				<div class="seminar-link">
					http://www.nlp.hk/dfasjlskdflks
				</div>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="addCalendar">
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<!-- Modal Header -->
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>

			<!-- Modal body -->
			<div class="modal-body">
				<div class="container">
					<div class="row">
						<div class="col-6 calendar-title">設定提醒</div>
						<div class="col-6 text-right">
							<div class="btn close-calendar-button">關閉</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Modal footer -->
			<div class="modal-footer">
				<div class="seminar-link">
					<table class="table">
						<tr>
							<td class="calendar-icon-block" rowspan="2"><img class="calendar-icon" src="<?=base_url('assets/img/front/icon-add-calendar.png');?>" /></td>
							<td class="calendar-title">日曆提醒</td>
							<td rowspan="2">
								<div class="add-calendar-button"><img class="float-right" src="<?=base_url('assets/img/front/btn-google-calendar.png');?>" /></div>
							</td>
						</tr>
						<tr>
							<td class="calendar-message">安排在你自己的日歷中</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<div id="footerSlideContainer">
	<div id="footerSlideButton"><img src="<?=base_url('assets/img/front/drawer-handle.png');?>" /></div>
	<div id="footerSlideContent">
		<div id="footerSlideText">
			<div class="row">
				<div class="col-12 col-lg-6 text-center webinar-timeslots">
<!--					<p>2021年3月4日 星期四 下午04:30</p>-->
<!--					<p>2021年3月4日 星期四 下午08:00</p>-->
<!--					<p>2021年3月5日 星期五 上午11:00</p>-->
				</div>
				<div class="col-12 col-lg-3 webinar-countdown">
					<table class="table">
						<tr>
							<td class="time days">00</td>
							<td class="time hours">00</td>
							<td class="time-seperator">：</td>
							<td class="time minutes">00</td>
							<td class="time-seperator">：</td>
							<td class="time seconds">00</td>
						</tr>
						<tr>
							<td class="time-label">日</td>
							<td class="time-label">時</td>
							<td></td>
							<td class="time-label">分</td>
							<td></td>
							<td class="time-label">秒</td>
						</tr>
					</table>
				</div>
				<div class="col-12 col-lg-3">
					<a id="register-button" class="btn">按此免費報名</a>
				</div>
			</div>

			<!--                <h3>Hey! I'm a Sliding Footer</h3>-->
			<!--                <p>What's a Sliding Footer? Well I'm a cool little element which can be hidden from view, and revealed when the user wants to see me.</p>-->
			<!--                <p>What can you use me for? Well look at all this stuff:</p>-->
			<!--                <ul>-->
			<!--                    <li>Sales information</li>-->
			<!--                    <li>Important updates</li>-->
			<!--                    <li>Unobtrusive about panel</li>-->
			<!--                    <li>Or just a good ol' footer</li>-->
			<!--                </ul>-->
			<!--                <p>There are obviously many other uses, but these are the few useful ones I can think of.</p>-->
		</div>
	</div>
</div>
<script>
	let base_url = '<?=base_url();?>';
	let seminar_title = '<?=$seminar_title;?>';
	let times = <?=$times;?>;
</script>
<?php
	$this->load->view('front/includes/html_footer');
?>
</body>

</html>
