<?php
$asset_path = base_url('assets/templates/landing/assets/');
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no" />
	<title>V Brain - Landing page</title>

	<!-- added ico place -->
	<link rel="apple-touch-icon" sizes="180x180" href="<?=base_url('assets/favicon/apple-touch-icon.png');?>">
	<link rel="icon" type="image/png" sizes="32x32" href="<?=base_url('assets/favicon/favicon-32x32.png');?>">
	<link rel="icon" type="image/png" sizes="16x16" href="<?=base_url('assets/favicon/favicon-16x16.png');?>">
	<link rel="manifest" href="<?=base_url('assets/favicon/site.webmanifest');?>">
	<meta name="msapplication-TileColor" content="#da532c">
	<meta name="theme-color" content="#ffffff">

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+HK:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

	<link rel="stylesheet" href="<?=base_url('vendor/bootstrap/css/bootstrap.min.css');?>" />
	<link rel="stylesheet" href="<?=$asset_path . 'css/' . $this->config->item('site_settings')['default_app'] . '.css?' . $hash;?>" />
	<link rel="stylesheet" href="<?=$asset_path . 'css/landing.css?' . $hash;?>" />
	<style>
		#sarah-hui {
			position: absolute;
			float: right;
			top: 0;
			right: 130px;
			width: 400px;
		}
		.table {
			margin-bottom: 0;
		}
		.no-border-no-padding {
			border-top: none!important;
			padding: 0!important;
		}
		.message-bar {
			background: rgb(255,255,255);
			background: linear-gradient(90deg, rgba(255,255,255,1) 0%, rgba(116,209,207,1) 100%);
		}
		.no-padding {
			padding: 0!important;
		}
		.small-font {
			font-size: .75rem;
			line-height: normal;
		}
		.section-3 {
			padding-bottom: 2rem;
		}
		.first-column {
			width: 60%;
			text-align: right;
		}
		.second-column {
			width: 40%;
		}
		.section-2 {
			background-image: url(<?=$asset_path;?>img/section-2-bg.png);
			background-size: cover;
			background-repeat: no-repeat;
		}
		.seminar-section {
			background-image: url(<?=$asset_path;?>img/seminar-section-bg.png);
			background-size: cover;
			background-repeat: no-repeat;
		}
		.seminar-section hr {
			border-top: 2px solid #fff;
			margin-top: 0;
			margin-bottom: 0;
		}
		.sarah-hui-profile {
			width: 250px;
		}
		.days, .hours, .minutes, .seconds {
			color: #74d1cf;
		}
		@media screen and (max-width: 990px) {
			#sarah-hui {
				float: none;
				width: 300px;
				top: -450px;
				right: auto;
				left: 50%;
				transform: translateX(-50%);
			}
			#sarah-hui-brand {
				margin-top: 400px;
			}
			.section-3 {
				padding-bottom: 1.5rem;
			}
			.first-column {
				width: 100%;
				text-align: center;
			}
			.second-column {
				width: 0%;
			}
		}
	</style>
	<script>
		if (typeof base_url === 'undefined') {
			let base_url = "<?=base_url();?>";
		}
		if (typeof seminar_title === 'undefined') {
			let seminar_title = "<?=$landing['title'];?>";
		}
		let times = <?=$times;?>;
	</script>
</head>
<body>
<main class="template1">
	<section class="container logo-section">
		<div class="row">
			<div class="col-12 pt-2 pb-2">
				<a href="<?=base_url();?>"><img src="<?=$asset_path . 'img/logo.png';?>" /></a>
			</div>
		</div>
	</section>
	<section class="header-section text-center">
		<img src="<?=$asset_path . 'img/header-banner.png';?>" class="img-fluid d-none d-md-block" />
		<img src="<?=$asset_path . 'img/header-banner.png';?>" class="img-fluid d-block d-md-none" />
	</section>
	<section class="section-1 section-content">
		<div class="container message-box">
			<img src="<?=$asset_path . 'img/box-wide-top.png';?>" style="" class="w-100 pt-3" />
			<div class="w-100 pl-4 pr-4" style="background-image: url(<?=$asset_path;?>img/box-wide-middle.png); background-repeat: repeat-y; background-size: 100%;">
				<h5 style="color: #74d1cf; font-weight: 600;">我地最近有個個案：</h5>
				<p style="color: #ffb852; font-weight: 600;">SEN小朋友7歲(Sam)，有學習及社交障礙，Sam情緒及成績持續低落，在學校沒有與同學溝通，自我形象相當差......</p>
				<p style="color: #ffb852; font-weight: 600;">經常上堂不專心坐不定，老師不太懂處理，常向父母投訴！父母試過做一些每小時千多元的治療，但效果不顯著，父母相當頭痛......</p>
			</div>
			<img src="<?=$asset_path . 'img/box-wide-bottom.png';?>" class="w-100 pb-3" />
		</div>
	</section>
	<section class="section-2 section-content" style="">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 order-lg-1">
					<div class="pt-5 pb-5"><img class="img-fluid mx-auto d-block" src="<?=$asset_path . 'img/vbrain-video.png';?>" /></div>
				</div>
				<div class="col-lg-6 order-lg-2">
					<div class="pt-5 pb-5">
						<h3 style="font-weight: 700; color: #fff;">在教學影片中，你會了解更多...</h3>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="section-3 section-content">
		<div class="container message-box">
			<div class="row">
				<div class="col-xl-8 col-lg-7">
					<img src="<?=$asset_path . 'img/box-thin-top.png';?>" style="" class="w-100 pt-3" />
					<div class="w-100 pl-4 pr-4" style="background-image: url(<?=$asset_path;?>img/box-thin-middle.png); background-repeat: repeat-y; background-size: 100%;">
						<p style="color: #ffb852; font-weight: 600;">大家好，我是V Brain創辦人Sarah Hui，亦是一位兒童教育家。從事小朋友教育工作20年。</p>
						<p style="color: #ffb852; font-weight: 600;">針對SEN學童不能融入班房，會產生情緒和溝通問題，影響社交和成績等......</p>
						<p style="color: #ffb852; font-weight: 600;">我們引入了一套美國FDA認證的科學方法幫助他/她們。</p>
						<p style="color: #ffb852; font-weight: 600;">通過我們的科學方法，3個月後，Sam數學名次大幅提升了，其他學科亦因此進步了不少！</p>
						<p style="color: #ffb852; font-weight: 600;">現在每次見到Sam，他都有笑容，並經常快樂地與我分享他的逸事。</p>
						<p style="color: #ffb852; font-weight: 600;">如你想知道我們如何做到？</p>
						<p style="color: #ffb852; font-weight: 600;">我已為你預備了一個「免費網上家長講座」，</p>
						<p style="color: #ffb852; font-weight: 600;">讓你心愛的孩子：重過開心愉快的童年生活！</p>
					</div>
					<img src="<?=$asset_path . 'img/box-thin-bottom.png';?>" class="w-100 pb-3" />
					<table id="sarah-hui-brand" class="table">
						<tbody>
							<tr>
								<td class="no-border-no-padding first-column"><h4 style="font-weight: 700; color: #ffb852;">Sarah Hui</h4></td>
								<td class="no-border-no-padding second-column"></td>
							</tr>
							<tr>
								<td class="no-border-no-padding first-column"><h5 style="font-weight: 700; color: #515151;">許秀香</h5></td>
								<td class="no-border-no-padding second-column"></td>
							</tr>
						</tbody>
					</table>

				</div>
				<div class="col-xl-4 col-lg-5">
					<img src="<?=$asset_path . 'img/sarah-hui.png';?>" id="sarah-hui" />
				</div>
			</div>
		</div>
		<div class="message-bar">
			<div class="container">
				<div class="row">
					<div class="col-xl-8 col-lg-7">
						<table class="table">
							<tbody>
							<tr>
								<td class="no-border-no-padding first-column">
									<p class="no-padding small-font">資深兒童心理輔導訓練導師</p>
									<p class="no-padding small-font">V Brain尚智首席顧問及營運總監</p>
									<p class="no-padding small-font">韓國認証神經反饋培訓導師及諮詢師</p>
								</td>
								<td class="no-border-no-padding second-column"></td>
							</tr>
							</tbody>
						</table>
					</div>
					<div class="col-xl-4 col-lg-5">
					</div>
				</div>
			</div>
		</div>
	</section>
</main>
<section class="seminar-section">
	<h1 class="font-bolder" style="color: #fff; padding-top: 30px;">免費網上家長講座</h1>
	<hr style="" />
	<div class="container h-100">
		<div class="row align-items-center h-100">
			<div class="col-12">
			</div>
		</div>
	</div>
	<div class="container">
		<div class="row">
			<div class="col-lg-4 order-lg-1">
				<div class="pt-5 pb-5"><img class="img-fluid mx-auto d-block sarah-hui-profile" src="<?=$asset_path . 'img/sarah-hui-profile.png';?>" /></div>
			</div>
			<div class="col-lg-8 order-lg-2">
				<div class="pt-5 pb-5">
					<p>導師：<span class="font-bold">Sarah Hui</span></p>
					<p>資深兒童心理輔導訓練導師</p>
					<p>V Brain尚智首席顧問及營運總監</p>
					<p>韓國認証神經反饋培訓導師及諮詢師</p>
					<p class="small">（免費網上簡介講座約60分鐘，導師會以廣東話演說）</p>
					<div class="row">
						<div class="col-12 col-md-6 pt-2 webinar-timeslots">
						</div>
						<div class="col-12 col-md-6 pt-2 webinar-countdown">
							<table class="table">
								<tr>
									<td class="time days">00</td>
									<td class="time hours">00</td>
									<td class="time-seperator">：</td>
									<td class="time minutes">00</td>
									<td class="time seconds">00</td>
								</tr>
								<tr>
									<td class="time-label">日</td>
									<td class="time-label">時</td>
									<td></td>
									<td class="time-label">分</td>
									<td class="time-label">秒</td>
								</tr>
							</table>
						</div>
					</div>
					<div class="row pt-4">
						<div class="col-12">
							<div id="register-button" class="click-button">立即按下連結報名，觀看免費講座</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="footer-section">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-lg-4 footer-column justify-content-center">
				<img class="d-block mx-auto epay" src="<?=$asset_path . 'img/epay.png';?>" alt="e-pay">
			</div>
			<div class="col-lg-4 footer-column justify-content-center">
				<h6 class="text-center title-color">客戶服務</h6>
				<nav class="navbar navbar-expand-lg">
					<ul class="nav navbar-nav mx-auto">
						<li class="nav-item">
							<a class="nav-link" href="#">常見問題</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" href="#">使用條款</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" href="#">隱私政策</a>
						</li>
					</ul>
				</nav>
				<p class="text-center"><a href="#">聯絡我們</a></p>
				<nav class="navbar navbar-expand-lg">
					<ul class="nav navbar-nav mx-auto">
						<li class="nav-item">
							<a class="nav-link" href="#"><img src="<?=$asset_path . 'img/icon_fb.png';?>" /></a>
						</li>
						<li class="nav-item">
							<a class="nav-link" href="#"><img src="<?=$asset_path . 'img/icon_ws.png';?>" /></a>
						</li>
						<li class="nav-item">
							<a class="nav-link" href="#"><img src="<?=$asset_path . 'img/icon_email.png';?>" /></a>
						</li>
					</ul>
				</nav>
			</div>
			<div class="col-lg-4 justify-content-center">
				<h6 class="title-color mb-0 pt-5">腦效能評估及訓練中心</h6>
				<p class="small-font mb-2">地址：九龍尖沙咀彌敦道132號美麗華廣場A座17樓1701室</p>
				<h6 class="title-color mb-0">腦效能訓練中心</h6>
				<p class="small-font mb-0">地址：荃灣南豐中心23樓2301D4室</p>
				<p class="small-font mb-2">　　　將軍澳唐賢街33號Capri Place商場地庫B03</p>
				<p class="small-font mb-0">電話　　：6995 9247</p>
				<p class="small-font mb-0">網址　　：<a class="title-color" href="<?=base_url('');?>">www.vbrain.hk</a></p>
				<p class="small-font mb-0">營業時間：星期一至五　　　　　　　10:30am - 7:30pm</p>
				<p class="small-font mb-0 pb-5">　　　　　星期六、日及公眾假期　　9:30am - 6:30pm</p>
			</div>
		</div>
	</div>
</section>
<section class="copyright-area">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<p class="text-center text-white">COPYRIGHT © 2021 <?=$this->config->item('site_settings')['company_name'];?>. All Rights Reserved.</p>
			</div>
		</div>
	</div>
</section>
<script src="<?=$asset_path . 'js/jquery.min.js';?>"></script>
<script src="<?=base_url('vendor/bootstrap/js/bootstrap.min.js');?>"></script>
<script src="<?=base_url('vendor/moment/moment-with-locales.min.js');?>"></script>
<script src="<?=$asset_path . 'js/common.js?' . $hash;?>"></script>
<script src="<?=$asset_path . 'js/landing.js?'. $hash;?>"></script>
</body>
</html>
