<section class="section-1">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<h1 class="title-color text-center">膽石，膽石手術，膽囊瘜肉，膽囊癌</h1>
			</div>
		</div>
	</div>
</section>
<section class="section-2">
	<div class="container h-100 pb-4">
		<div class="row">
			<div class="col-12 bgcolor pt-4 pb-4">
				<h2 class="text-center pb-3 title-color">膽石<span class="special-text">分類</span></h2>
				<p class="text-center mx-auto pb-3" style="max-width: 768px;">膽石共分三類，包括膽固醇結石、色素結石及混合型結石，混合型結石為前兩類結石的混合體。<img class="" src="http://localhost:4814/assets/templates/landing/assets/img/precision-surgery-icon.png" /></p>
				<img class="d-block mx-auto" src="http://localhost:4814/assets/templates/landing/assets/img/eUlGKfSspumg0SIC/section-2.png" />
			</div>
		</div>
	</div>
</section>
<section class="section-3">
	<div class="container">
		<div class="row">
			<div class="col-md-6">
				<h5 class="title-color"><span class="special-text">膽石</span>的高風險因素：</h5>
				<p class="pb-4">|  肥胖  |  女性  |  中年人士  |  白人  |  溶血性疾病  |  膽管受感染  |</p>
				<h5 class="title-color"><span class="special-text">膽石</span>徵狀</h5>
				<p class="pb-4">部分膽石患者並沒有明顯病徵，而大約有百分之十的患者會在五年內出現徵狀，例如右上腹輕微疼痛或脹痛、消化不良及胃氣脹的感覺。若患者的右上腹持續出現劇烈疼痛，這可能是膽絞痛的徵狀，切勿掉以輕心。<img class="" src="http://localhost:4814/assets/templates/landing/assets/img/precision-surgery-icon.png" /></p>
				<h5 class="title-color">如何診斷<span class="special-text">膽石</span>？</h5>
				<p>醫生會透過臨床及超聲波檢查，診斷求診者是否患有膽石，並找出膽石的位置。<img class="" src="http://localhost:4814/assets/templates/landing/assets/img/precision-surgery-icon.png" /></p>
			</div>
			<div class="col-md-6">
				<h5 class="title-color"><span class="special-text">膽石</span>的併發症：</h5>
				<p>一般來說，大部分膽石都藏於膽囊內，並有機會引起以下各種併發症，不可看輕。</p>
				<ul>
					<li>急性膽囊炎：它會引致整個膽囊內部蓄膿、壞死、穿孔，以及出現腹膜炎。</li>
					<li>慢性膽囊炎：右上腹長期出現痛楚，膽絞痛重腹出現。</li>
					<li>膽腸瘻管：慢性膽囊炎侵入附近腸道，造成瘻管；膽石會從瘻管進入腸進，引致腸道阻塞。</li>
					<li>陶瓷樣膽囊：膽囊廣泛性鈣化是患上膽囊癌的高風險成因。</li>
				</ul>
				<p>雖然膽石一般位於膽囊，惟膽石有機會跌入膽管內，引致膽道結石。此情況下，患者會出現其他併發症如膽管炎，這正因膽管受嚴重感染所致。另方面，若膽石跌至總膽管與胰管會合後十二指腸開口的位置（又稱：瓦特壺腹），亦可能會損害胰腺的外分泌系統，引致胰臟炎。事實上，無論是膽管炎還是胰臟炎，均有機會致命，故此患者應盡速求診治理。<img class="" src="http://localhost:4814/assets/templates/landing/assets/img/precision-surgery-icon.png" /></p>
			</div>
		</div>
	</div>
</section>
<section class="section-4">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<img src="http://localhost:4814/assets/templates/landing/assets/img/eUlGKfSspumg0SIC/section-4.png" class="img-fluid d-none d-md-block" />
				<img src="http://localhost:4814/assets/templates/landing/assets/img/eUlGKfSspumg0SIC/section-4_sm.png" class="img-fluid d-block d-md-none" />
				<a id="btn-enquiry"><img src="http://localhost:4814/assets/templates/landing/assets/img/eUlGKfSspumg0SIC/btn-enquiry.png" class="mt-4 img-fluid d-block mx-auto" /></a>
			</div>
		</div>
	</div>
</section>
<section class="section-5 mb-0 pb-5">
	<div class="container">
		<div class="row pb-4">
			<div class="col-12">
				<h3 class="title-color text-center pt-3">「什麼人容易患上<span class="special-text">膽結石</span>？」</h3>
				<hr style="border-top: 1px solid #8572a8;" />
				<div class="mx-auto pb-3" style="max-width: 768px;">
					<p class="title-color">外科專科夏威醫生</p>
					<p>什麼人容易患上膽結石？夏威醫生指出具有「4F」特色的人士較為容易患上膽結石，當中包括Fat肥胖、Forty四十歲、Fertile未停經、Female女性。此外膽固醇與結石都是息息相關，想了解更多？快啲一齊睇片啦！<img class="" src="http://localhost:4814/assets/templates/landing/assets/img/precision-surgery-icon.png" /></p>
				</div>
				<a href="">
					<img src="http://localhost:4814/assets/templates/landing/assets/img/video-thumb.png" class="img-fluid d-none d-md-block mx-auto" />
					<img src="http://localhost:4814/assets/templates/landing/assets/img/video-thumb_sm.png" class="img-fluid d-block d-md-none mx-auto" />
				</a>
			</div>
		</div>
		<div class="row">
			<div class="col-md-6 order-0 order-md-0">
				<h5 class="title-color"><span class="special-text">膽囊</span>瘜肉</h5>
				<p class="pb-4">膽囊除了可能會有膽石外，更有機會在膽囊壁位置長出瘜肉。一般來說，大部分瘜肉屬於良性，並不用移除。不過，若患者逾五十歲，瘜肉超過一厘米大，便可能要進行腹腔鏡膽囊摘除術。尤其是患者膽囊內有多粒瘜肉，或已呈似惡性特徵，更要盡快移除膽囊。</p>
			</div>
			<div class="col-md-6 order-2 order-md-1">
				<h5 class="title-color"><span class="special-text">膽石</span>治療</h5>
				<p>微創手術： 腹腔鏡膽囊摘除術 是有效治療膽石的方法。</p>
				<p>其實治療膽石的方法，包括藥物溶解膽石及體外超聲波碎膽石，惟此兩種治療方法成效較差，並會有機會復發。</p>
				<p class="pb-4">本網站上的資訊僅提供教育用途。你應該諮詢醫生有關的治療方法，而不應依賴網站上的資訊。</p>
			</div>
			<div class="col-md-6 order-1 order-md-2">
				<h5 class="title-color"><span class="special-text">膽囊</span>癌</h5>
				<p class="pb-4">膽囊癌是一種不常見的癌症，大部分患者為女性長者，如確診患上膽囊癌，應盡早作出治理。醫生會為患者移除膽囊、部分肝臟及有關的淋巴結。</p>
			</div>
		</div>
	</div>
	<div class="mx-auto pb-3" id="enquiry-form" style="max-width: 968px; background-color: #fff; box-shadow: 0px 0px 50px 2px rgba(0,0,0,0.55);">
		<h2 class="text-center title-color pt-3">診症<span class="special-text">預約</span></h2>
		<hr style="border-top: 1px solid #8572a8; margin-bottom: 0;" />
		<div style="padding: 30px;">
			<h5 class="special-text pb-3">請填寫個人資料</h5>
			<form>
				<fieldset>
					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<input name="name" placeholder="姓名*" class="form-control" />
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group">
								<input name="phone" placeholder="聯絡電話*" class="form-control" />
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group">
								<input name="email" type="email" placeholder="電郵地址*" class="form-control" />
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<select name="age" class="form-control">
									<option value="" selected="selected">年齡組別</option>
									<option value="18-">18歲以下</option>
									<option value="18-25">18-25歲</option>
									<option value="26-35">26-35歲</option>
									<option value="36-45">36-45歲</option>
									<option value="46-55">46-55歲</option>
									<option value="56-65">56-65歲</option>
									<option value="65+">65歲以上</option>
								</select>
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<select name="gender" class="form-control">
									<option value="" selected="selected">性別</option>
									<option value="M">男</option>
									<option value="F">女</option>
								</select>
							</div>
						</div>
						<div class="col-12">
							<p style="font-size: 0.75rem;">*必需填寫</p>
						</div>
					</div>
					<div class="row pt-3">
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">大腸/ 胃部/ 疝 (小腸氣)</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-1" value="1" />
								<label class="form-check-label" for="item-1">大腸鏡檢查/ 常見腸病 (大便出血)</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-2" value="2" />
								<label class="form-check-label" for="item-2">大腸癌</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-3" value="3" />
								<label class="form-check-label" for="item-3">腹腔鏡大腸切除術</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-4" value="4" />
								<label class="form-check-label" for="item-4">胃鏡檢查</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-5" value="5" />
								<label class="form-check-label" for="item-5">胃癌/胃切除手術</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-6" value="6" />
								<label class="form-check-label" for="item-6">疝 (小腸氣)</label>
							</div>
						</div>
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">乳房</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-7" value="7" />
								<label class="form-check-label" for="item-7">乳癌</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-8" value="8" />
								<label class="form-check-label" for="item-8">乳房腫塊切除手術</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-9" value="9" />
								<label class="form-check-label" for="item-9">部份乳房切除手術</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-10" value="10" />
								<label class="form-check-label" for="item-10">乳房切除手術</label>
							</div>
						</div>
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">皮膚</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-11" value="11" />
								<label class="form-check-label" for="item-11">皮膚腫瘤 (粉瘤/脂肪瘤/纖維瘤/疣)</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-12" value="12" />
								<label class="form-check-label" for="item-12">miraDry® 腋下多汗症療程</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-13" value="13" />
								<label class="form-check-label" for="item-13">瘢瘤性疤痕和增生性疤痕</label>
							</div>
						</div>
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">甲狀線</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-14" value="14" />
								<label class="form-check-label" for="item-14">甲狀線切除術</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-15" value="15" />
								<label class="form-check-label" for="item-15">副甲狀線切除術</label>
							</div>
						</div>
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">痔瘡/ 肛門</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-16" value="16" />
								<label class="form-check-label" for="item-16">痔瘡</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-17" value="17" />
								<label class="form-check-label" for="item-17">肛裂</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-18" value="18" />
								<label class="form-check-label" for="item-18">肛門膿瘍與肛門廔管</label>
							</div>
						</div>
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">膽囊</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-19" value="19" />
								<label class="form-check-label" for="item-19">膽石/膽囊瘜肉/膽囊癌</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-20" value="20" />
								<label class="form-check-label" for="item-20">腹腔鏡膽囊切除術</label>
							</div>
						</div>
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">靜脈曲張治療</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-21" value="21" />
								<label class="form-check-label" for="item-21">靜脈曲張治療</label>
							</div>
						</div>
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">倒甲</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-22" value="22" />
								<label class="form-check-label" for="item-22">趾甲內翻(倒甲)治療</label>
							</div>
						</div>
						<div class="col-6 col-md-4 pb-4">
							<h5 class="special-text">割包皮</h5>
							<hr style="border-top: 1px solid #8572a8; margin-top: 5px; margin-bottom: 5px;" />
							<div class="form-check">
								<input type="checkbox" class="form-check-input" name="enquiry_item[]" id="item-23" value="23" />
								<label class="form-check-label" for="item-23">包皮槍手術和激光包皮環切術</label>
							</div>
						</div>
						<div class="col-12" style="padding-top: 30px;">
							<button id="btn-register" class="d-block mx-auto" style="background-color: #8572a8; letter-spacing: 0.2rem; color: #fff; padding: 10px 30px; border-radius: 10px; border: none; font-size: 1.25rem;">立即預約</button>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</section>
