<!DOCTYPE html>
<html>

<head>
	<?php
		$this->load->view('front/includes/html_header');
	?>
</head>

<body>
	<main class="template3">
		<section class="header-section">
			<div class="bg">
				<img src="<?=$base_url;?>assets/img/front/header-banner-noword.png" class="img-fluid d-none d-lg-block" />
				<img src="<?=$base_url;?>assets/img/front/header-banner-sm.png" class="img-fluid d-block d-lg-none" />
			</div>
			<div class="container title-section">
				<div class="row">
					<div class="col-12 col-xl-6">
						<div class="card">
							<div class="card-body">
								<div class="card-title">
									沒有最好，<br />只有更好！
								</div>
								<div class="card-text">
									讓我們一起學習，一起成長！
								</div>
							</div>
						</div>
					</div>
					<div class="col-12 col-xl-6 logo-section">
						<img class="img-fluid" src="<?=$base_url;?>assets/img/front/logo.png" />
					</div>
				</div>
				<div class="row">
					<div class="col-12 main-title">
						<table class="table">
							<tr>
								<td class=""><h1 class="main-title-text font-bolder">NPL執行師及NLP教練雙證書課程</h1></td>
								<td rowspan="2" class="align-middle"><img class="img-fluid" src="<?=$base_url;?>assets/img/front/logo-CEF.png" /></td>
							</tr>
							<tr>
								<td class=""><h2 class="sub-title-text font-bolder">（持續進修基金（CEF）可獲發還款項課程）</h2></td>
							</tr>
						</table>
					</div>
				</div>
			</div>
		</section>
		<section class="section-1 section-content">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 order-lg-1">
						<div class="pt-5 pb-5">
							<p>NLP 全名是 Neuro-Linguistic Programming「身心語言程式學」。NLP 是一門研究人類快速行為轉變的科學，運用身體動作、語言層次和無框思想方法來改變自己和影響別人。根據NLP始創人Dr. Richard Bandler 比較喜歡用的解釋是[我們大腦的操作手冊]。</p>
							<p>NLP 在商業應用上，可應用於銷售、團隊建立、創造工作文化、氣氛及商業洽談等。個人應用上可以增強自信心、提昇思考速度、掌控情緒、消除負面觀念等。家庭上可加強溝通能力，提昇家庭親和感等等。</p>
						</div>
					</div>
					<div class="col-lg-6 order-lg-2">
						<div class="video-container">
							<iframe width="560" height="315" src="https://www.youtube.com/embed/421z0hzNR7A" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
						</div>
					</div>
				</div>
			</div>
		</section>
	</main>
	<div class="container">
		<div class="row">
			<div class="col-12 seperator">
			</div>
		</div>
	</div>
	<section class="section-2 section-content">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 order-lg-2">
					<div class="pt-5 pb-5"><img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/coaching.png"></div>
				</div>
				<div class="col-lg-6 order-lg-1">
					<div class="pt-5 pb-5">
						<h5 class="font-bold">教練學(Coaching)</h5>
						<p>專業教練是透過有效的教練問題，能使客戶自我檢討和醒覺，發揮個人的潛能， 有效地激發、發揮團隊或自我整體的力量。教練運用一系列有方向性、有策略性的聆聽和發問技巧，幫助客戶了解自己的身心智模式，通過釐請目標、激發潛能和發揮可能性的過程，令客戶有效達到目標。</p>
						<p>時裝界殿堂級設計師(Donna Karan)、國際著名演員(Hugh Jackman)、網球明星阿 加斯(Andre Agassi)、CNN著名節目主持人拉里金 (Larry King)，甚至美國前總統克林頓(Bill Clinton)等各類不同範疇的知名人士都接受過教練服務從中獲得提升。 那麼NLP與教練技術結合能帶來什麽呢？</p>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="details-section">
		<div class="container">
			<div class="row">
				<div class="col">
					<h4 class="font-bold">NLP與教練技術都是最先進的工具，</h4>
					<h4 class="font-bold">當把它們接合起來，融匯運用，</h4>
					<h4 class="font-bold">充分發揮各自的優勢，</h4>
					<h4 class="font-bold">使到NLP教練掌握到最全面的能力轉變技巧。</h4>
				</div>
			</div>
		</div>
	</section>
	<section class="section-3 section-content">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 order-lg-1">
					<div class="pt-5 pb-5"><img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/nlp-features.png" /></div>
				</div>
				<div class="col-lg-6 order-lg-2">
					<div class="pt-5 pb-5">
						<h5 class="font-bold">課程特色</h5>
						<ul class="no-bullet">
							<li class="arrow">課程獲加入持續進修基金(CEF)可獲發還款項課程名單內(院校編號742)，學員能以最低的學費，學習到最高質素和最熱門的個人提昇技術。</li>
							<li class="arrow">課程由國際高級 NLP/教練導師 Tommy Doo 親自教授，使學員可學習到統一及整全的學問。</li>
							<li class="arrow">全新NLP執行師及NLP教練綜合國際證書課程。</li>
							<li class="arrow">畢業學員可同時擁有國際認可的 NLP執行師 及 NLP教練雙資格。</li>
							<li class="arrow">內容及時數遵照國際標準教授，讓學員能學習到最原裝版本的課程。</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<div class="container">
		<div class="row">
			<div class="col-12 seperator-1">
				<div id="enquiry-button"><img class="d-block click-button" src="<?=$base_url;?>assets/img/front/btn-enquiry.png" /></div>
			</div>
		</div>
	</div>
	<section class="section-4 section-content">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 order-lg-1">
					<div class="pt-5 pb-5">
						<h5 class="font-bold">你將會學到</h5>
						<ul class="no-bullet">
							<li class="arrow">打造全方位最先進大腦裝備，在人生旅程中運籌帷幄，擁抱卓越！</li>
							<li class="arrow">解讀眼睛移動線索，讓你馬上看穿對方的心思。</li>
							<li class="arrow">運用語言歸類法，讓你成為說話的高手。</li>
							<li class="arrow">潛意識同步帶領法，瞬間和別人建立親和默契感，助您建立廣闊人脈。</li>
							<li class="arrow">改變大腦次感元，讓你成為EQ達人，隨時可面對艱辛的挑戰！</li>
							<li class="arrow">尋找人生各方面的核心價值，加強個人動力，成為自己的人生教練。</li>
							<li class="arrow">預設理想心錨狀態，隨時隨地提取達致卓越表現。</li>
							<li class="arrow">迪士尼策略運用眼睛丶姿勢開啟你全方位立體創意思維！</li>
							<li class="arrow">吸引力法則的最後秘訣，讓你達標正常，超標可期望！</li>
							<li class="arrow">還有更多…更多…</li>
						</ul>
					</div>
				</div>
				<div class="col-lg-6 order-lg-2">
					<div class="pt-5 pb-5"><img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/schooling-training-learning.png" /></div>
				</div>
			</div>
		</div>
	</section>
	<section class="course-section">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<h1 class="main-title-text font-bolder">課程內容</h1>
					<h3 class="font-bold">NLP執行師及NLP教練雙證書課程共分5單元</h3>
					<table class="table">
						<tr>
							<!--                            <td class="align-middle"><img class="img-fluid left-arrow" src="assets/img/blue20-left.png" /></td>-->
							<td class="">
								<div class="row">
									<div class="col-lg-3 col-12 course-title">單元 1–4：</div>
									<div class="col-lg-9 col-12 course-content">
										<div class="row">
											<div class="col-10">
												NLP商業教練技巧證書課程<br />政府持續進修基金(CEF)認可(21C06951-5)
											</div>
											<div class="col-2">
												<img class="img-fluid logo-CEF" src="<?=$base_url;?>assets/img/front/logo-CEF.png" />
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-3 col-12 course-title">單元 5：</div>
									<div class="col-lg-9 col-12 course-content">NLP執行師技巧證書課程</div>
								</div>
							</td>
							<!--                            <td class="align-middle"><img class="img-fluid right-arrow" src="assets/img/blue20-right.png" /></td>-->
						</tr>
					</table>
				</div>
			</div>
		</div>
	</section>
	<section class="section-5 section-content">
		<div class="container">
			<div class="row">
				<div class="col-lg-6 order-lg-1">
					<div class="pt-3 pb-3"><img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/nlp-book.png" /></div>
				</div>
				<div class="col-lg-6 order-lg-2">
					<div class="pt-3 pb-3">
						<div class="row">
							<h5 class="font-bold pl-3">單元 1 – 基礎理論及成功心態</h5>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">甚麼是NLP教練技術</li>
									<li class="arrow">NLP教練技術的歷史</li>
									<li class="arrow">NLP教練技術的定義</li>
									<li class="arrow">NLP教練技術的商業應用</li>
									<li class="arrow">COACH 成功的五項祕訣</li>
									<li class="arrow">教練的卓越信念</li>
									<li class="arrow">甚麼是信念</li>
									<li class="arrow">假設前題</li>
									<li class="arrow">教練的價值觀</li>
								</ul>
							</div>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">甚麼是價值</li>
									<li class="arrow">價值的進化</li>
									<li class="arrow">尋究價值</li>
									<li class="arrow">尋究核心價值</li>
									<li class="arrow">共同信念和價值</li>
									<li class="arrow">生命籃圖</li>
									<li class="arrow">整體及生態平衡</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-6 order-lg-1">
					<div class="pt-3 pb-3">
						<div class="row">
							<h5 class="font-bold pl-3">單元 2 – 高效商業溝通技巧</h5>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">人類內在溝通模式</li>
									<li class="arrow">解讀思考模式</li>
									<li class="arrow">敏銳的觀察力</li>
									<li class="arrow">表象系統及眼睛解讀線索</li>
									<li class="arrow">尋究主表象系統</li>
									<li class="arrow">次感元</li>
									<li class="arrow">身體語言與聲調</li>
									<li class="arrow">瞬間建立親和感</li>
									<li class="arrow">鏡子映現法</li>
								</ul>
							</div>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">交互映現法</li>
									<li class="arrow">同步帶領法</li>
									<li class="arrow">教練的聆聽模式</li>
									<li class="arrow">聆聽的定義</li>
									<li class="arrow">聆聽的三個層次</li>
									<li class="arrow">教練的發問模式</li>
									<li class="arrow">發問的藝術</li>
									<li class="arrow">50條強效問題</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6 order-lg-2">
					<div class="pt-3 pb-3">
						<div class="row">
							<h5 class="font-bold pl-3">單元 3 – 洽商 / 調解語言模式</h5>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">表面與深層結構的關係</li>
									<li class="arrow">扭曲</li>
									<li class="arrow">一般化</li>
									<li class="arrow">刪減</li>
									<li class="arrow">語言歸類法</li>
									<li class="arrow">向上歸類</li>
									<li class="arrow">向下歸類</li>
									<li class="arrow">橫向歸類</li>
									<li class="arrow">後設模式</li>
								</ul>
							</div>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">扭曲類</li>
									<li class="arrow">一般化類</li>
									<li class="arrow">刪減類</li>
									<li class="arrow">米爾頓模式</li>
									<li class="arrow">米爾頓模式的應用</li>
									<li class="arrow">CEO說話模式</li>
									<li class="arrow">語言換框法</li>
									<li class="arrow">環境換框</li>
									<li class="arrow">內容換框</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-6 order-lg-1">
					<div class="pt-3 pb-3">
						<div class="row">
							<h5 class="font-bold pl-3">單元 4 – 提昇狀態達至卓越表現</h5>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">壓力管理</li>
									<li class="arrow">甚麼是壓力</li>
									<li class="arrow">教練減壓方法</li>
									<li class="arrow">漸進式放鬆法</li>
									<li class="arrow">卓越表現 – 定、點、位</li>
									<li class="arrow">自我激勵策略</li>
								</ul>
							</div>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">心錨</li>
									<li class="arrow">卓越圈</li>
									<li class="arrow">紅海 vs 藍海策略</li>
									<li class="arrow">感知位置法</li>
									<li class="arrow">迪士尼策略</li>
									<li class="arrow">S.M.A.R.T 目標法</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6 order-lg-2">
					<div class="pt-3 pb-3">
						<div class="row">
							<h5 class="font-bold pl-3">單元 5 – NLP執行師技巧</h5>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">全方位的成果</li>
									<li class="arrow">策略的效用</li>
									<li class="arrow">策略的運用</li>
									<li class="arrow">購買策略</li>
									<li class="arrow">Swish 模式</li>
								</ul>
							</div>
							<div class="col-12 col-xl-6">
								<ul class="no-bullet">
									<li class="arrow">快速消除恐懼法</li>
									<li class="arrow">時間線的概念</li>
									<li class="arrow">內時間與外時間</li>
									<li class="arrow">T.O.T.E.循環進步模式</li>
									<li class="arrow">邏輯層次</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="certificate-section">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<h1 class="font-bolder">報讀資格及可獲專業證書</h1>
					<div class="row">
						<div class="col-lg-6 order-lg-1">
							<div class="pt-5 pb-5">
								<img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/certificates.png" />
							</div>
						</div>
						<div class="col-lg-6 order-lg-2">
							<div class="pt-5 pb-5">
								<h5 class="font-bold">報讀資格及結業要求</h5>
								<ul class="no-bullet">
									<li class="arrow">中五或以上程度</li>
									<li class="arrow">出席率達 85% 以上</li>
									<li class="arrow">考試合格</li>
									<li class="arrow">完成指定功課</li>
								</ul>
								<h5 class="fifty mt-2 font-bold">可獲頒發</h5>
								<ul class="no-bullet">
									<li class="arrow">NLP商業教練技巧證書 – 香港學術及職業資歷評審局及持續進修基金認可</li>
									<li class="arrow">NLP執行師證書 – International NLP Federation / International NLP Association 認可</li>
									<li class="arrow">NLP教練證書 – International NLP Coach Association 認可</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="testimonial-section">
		<div class="container h-100">
			<div class="row align-items-center h-100">
				<div class="col-1">
					<img class="img-fluid d-none d-sm-block" src="<?=$base_url;?>assets/img/front/blue80-left.png" />
				</div>
				<div class="col-10">
					<div class="row">
						<div class="col-12">
							<img class="img-fluid mx-auto d-block profile-pic" src="<?=$base_url;?>assets/img/front/ouvin-or.png" />
						</div>
					</div>
					<div class="row testimonial-description">
						<div class="col-12">
							<h3 class="font-bold">完成Tommy Sir 課堂後，透過NLP Coaching 釐清了自己的價值觀，轉了一個適合自己的行業，除左加薪外，最重要能有更愉快的工作生活。</h3>
							<h5>Ouvin Or, 廣告業 - 品牌經理</h5>
						</div>
					</div>
				</div>
				<div class="col-1">
					<img class="img-fluid d-none d-sm-block" src="<?=$base_url;?>assets/img/front/blue80-right.png" />
				</div>
			</div>
		</div>
	</section>
	<section class="more-testimonial-section">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<h5>我們所有的回饋都是來自已經<strong>畢業最少三個月</strong>，甚至是超過10年的學員！</h5>
					<h5>讓我們一起分享他們完成NLP/教練課程後在事業、家庭、人際、愛情、甚至整個人生等等各方面的改變！</h5>
				</div>
			</div>
			<div class="row pt-5">
				<div class="col-12 seperator-1">
					<div id="testimonial-button">
						<img class="testimonial-visible mx-auto click-button" src="<?=$base_url;?>assets/img/front/btn-testimonial.png" />
						<img class="testimonial-sm-visible mx-auto click-button" src="<?=$base_url;?>assets/img/front/btn-testimonial-sm.png" />
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="seminar-section">
		<div class="container h-100">
			<div class="row align-items-center h-100">
				<div class="d-none col-sm-1 d-sm-block">
					<img class="img-fluid" src="<?=$base_url;?>assets/img/front/blue20-left.png" />
				</div>
				<div class="col-12 col-sm-10">
					<h1 class="font-bolder">免費網上簡介講座</h1>
					<h1 class="font-bolder">「網上企業教練證書課程」</h1>
				</div>
				<div class="d-none col-sm-1 d-sm-block">
					<img class="img-fluid" src="<?=$base_url;?>assets/img/front/blue20-right.png" />
				</div>
			</div>
		</div>
		<div class="container">
			<div class="row">
				<div class="col-lg-4 order-lg-1">
					<div class="pt-5 pb-5">
						<img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/tommy-doo.png" />
					</div>
				</div>
				<div class="col-lg-8 order-lg-2">
					<div class="pt-5 pb-5">
						<p>導師：<span class="font-bold">Tommy Doo</span></p>
						<p>高級NLP導師、高級NLP教練導師、美國IICS高級教練導師、WealthyMind™課程導師、CoreTransformation™課程導師、美國NGH催眠治療導師、美國DEHI催眠導師、解夢分析師、屋樹人分析師、高級NLP執行師、NLP教練、催眠治療師</p>
						<p class="small">（免費網上簡介講座約60分鐘，導師會以廣東話演說）</p>
						<div class="row">
							<div class="col-12 col-md-6 pt-2 webinar-timeslots">
	<!--							<p>2021年3月4日 星期四 下午04:30</p>-->
	<!--							<p>2021年3月4日 星期四 下午08:00</p>-->
	<!--							<p>2021年3月5日 星期五 上午11:00</p>-->
							</div>
							<div class="col-12 col-md-6 pt-2 webinar-countdown">
								<table class="table">
									<tr>
										<td class="time days">00</td>
										<td class="time hours">00</td>
										<td class="time-seperator">：</td>
										<td class="time minutes">00</td>
										<td class="time seconds">00</td>
									</tr>
									<tr>
										<td class="time-label">日</td>
										<td class="time-label">時</td>
										<td></td>
										<td class="time-label">分</td>
										<td class="time-label">秒</td>
									</tr>
								</table>
							</div>
						</div>
						<div class="row pt-4">
							<div class="col-12 seperator-1">
								<div id="register-button"><img class="d-block click-button" src="<?=$base_url;?>assets/img/front/btn-register.png" /></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="contact-section">
		<div class="container">
			<div class="row">
				<div class="col-lg-4 order-lg-1 col-md-6 pt-5">
					<img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/logo-nlp.png" />
					<p class="small">九龍彌敦道221-221A同昌商業大厦14樓全層</p>
					<p class="small">電話：852-2377 0398</p>
					<p class="small">傳真：852-3422 8662</p>
					<p class="small">電郵：info@nlp.hk</p>
					<div class="row payment-section">
						<div class="col-12 col-md-3 pr-0">
							<p class="small">付款方式：</p>
						</div>
						<div class="col-12 col-md-9 mt-2 stripe-block">
							<table class="table">
								<tr>
									<td class="stripe-section"><img src="<?=$base_url;?>assets/img/front/logo-stripe.png" /></td>
									<td class="border-bottom full-width"><p>&nbsp;</p></td>
								</tr>
								<tr>
									<td colspan="2" class="left-right-border p-2">
										<div class="row h-100">
											<div class="col-3 my-auto adjust-padding adjust-padding-first"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-visa.png" /></div>
											<div class="col-3 my-auto adjust-padding"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-mastercard.png" /></div>
											<div class="col-3 my-auto adjust-padding"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-american-express.png" /></div>
											<div class="col-3 my-auto adjust-padding adjust-padding-last"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-jcb.png" /></div>
										</div>
									</td>
								</tr>
								<tr>
									<td colspan="2" class="left-right-border border-bottom p-2">
										<div class="row h-100">
											<div class="col-6 my-auto adjust-padding adjust-padding-first"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-discover.png" /></div>
											<div class="col-6 my-auto adjust-padding adjust-padding-last"><img class="d-block mx-auto img-fluid" src="<?=$base_url;?>assets/img/front/logo-diners-club.png" /></div>
										</div>
									</td>
								</tr>
							</table>
						</div>
					</div>
				</div>
				<div class="col-lg-3 order-lg-2 col-md-6 pt-5">
					<img class="img-fluid mx-auto d-block" src="<?=$base_url;?>assets/img/front/nlp-fb-page.png" />
				</div>
				<div class="col-lg-4 order-lg-3 pt-5 col-md-12">
					<p>如果你想收到我們最新消息、課程動態，請填寫電郵登記。</p>
					<div class="form-group">
						<input class="form-control" />
					</div>
					<p>現在登記更可獲贈著名 NLP 導師 Ken Ward 設計的”NLP一分鐘激勵自己”與及 Mr. Dylan Morgan 出版的 “催眠入門”電子書各一。</p>
					<div class="row pt-4">
						<div class="col-12 seperator-white">
							<div id="send-button"><img class="d-block click-button" src="<?=$base_url;?>assets/img/front/btn-send.png" /></div>
						</div>
					</div>
					<div class="row pt-3">
						<div class="col social-icon"><a href="#" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/facebook.png" /></a></div>
						<div class="col social-icon"><a href="#" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/twitter.png" /></a></div>
						<div class="col social-icon"><a href="https://www.youtube.com/channel/UC484WBIUpdjUwlymZ2aSutQ" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/youtube.png" /></a></div>
						<div class="col social-icon"><a href="#" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/instagram.png" /></a></div>
						<div class="col social-icon"><a href="#" target="_blank"><img class="img-fluid d-block mx-auto" src="<?=$base_url;?>assets/img/front/linkedin.png" /></a></div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<footer class="p-3 footer-section">
		<div class="container">
			<p class="text-center text-white m-0 small">&copy; Copyright 2004 - 2021 | All Rights Reserved</p>
		</div>
	</footer>
	<script>
		let base_url = '<?=$base_url;?>';
	</script>
	<?php
		$this->load->view('front/includes/html_footer');
	?>
</body>

</html><?php
