<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
		<title><?=$page_title;?></title>

		<!-- added ico place -->
		<link rel="apple-touch-icon" sizes="180x180" href="<?=base_url('assets/favicon/apple-touch-icon.png');?>">
		<link rel="icon" type="image/png" sizes="32x32" href="<?=base_url('assets/favicon/favicon-32x32.png');?>">
		<link rel="icon" type="image/png" sizes="16x16" href="<?=base_url('assets/favicon/favicon-16x16.png');?>">
		<link rel="manifest" href="<?=base_url('assets/favicon/site.webmanifest');?>">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">

		<link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
		<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+HK:wght@100;300;400;500;700;900&amp;display=swap" rel="stylesheet">

		<link rel="stylesheet" href="<?=base_url('vendor/bootstrap/css/bootstrap.min.css');?>">
		<link rel="stylesheet" href="<?=base_url('vendor/bootstrap-datepicker/css/bootstrap-datepicker.min.css');?>">
		<link rel="stylesheet" href="<?=base_url('assets/templates/landing/assets/css/' . $this->config->item('site_settings')['default_app'] . '.css?' . $hash);?>">
		<link rel="stylesheet" href="<?=base_url('assets/templates/landing/assets/css/landing.css?' . $hash);?>">
		<style>
			section[class^="section-"] {
				font-weight: 400;
				margin-top: 20px;
				margin-bottom: 20px;
			}
			.title-color {
				color: #8572a8;
			}
			.bgcolor {
				background-color: #edeaf2;
			}
			.special-text {
				color: #0384b3;
			}
			#btn-enquiry:hover {
				cursor: pointer;
			}
			.section-5 {
				background-image: url(<?=base_url();?>assets/templates/landing/assets/img/<?=$landing['token'];?>/booking-bgimage.png);
				background-repeat: no-repeat;
				background-size: cover;
			}
			.contact-section {
				background-color: #cde6f0;
				color: #333;
			}
			.contact-section .left-column {
				border-right: 2px solid #8572a8;
			}
			.copyright-area {
				background-color: #8572a8;
			}
			.table {
				margin-bottom: 0;
			}
			.no-border-no-padding {
				border-top: none!important;
				padding: 0!important;
			}
			.message-bar {
				background: rgb(255,255,255);
				background: linear-gradient(90deg, rgba(255,255,255,1) 0%, rgba(116,209,207,1) 100%);
			}
			.no-padding {
				padding: 0!important;
			}
			.small-font {
				font-size: .75rem;
				line-height: normal;
			}
			@media screen and (max-width: 768px) {
				.contact-section .left-column {
					border-right: none;
				}
			}
			@media screen and (max-width: 990px) {
			}
		</style>
		<script>
			if (typeof base_url === 'undefined') {
				var base_url = "<?=base_url();?>";
			}
		</script>
		<!-- ManyChat -->
		
		<script src="//widget.manychat.com/101023122396285.js" defer="defer"></script>
		<script src="https://mccdn.me/assets/js/widget.js" defer="defer"></script>
	<?php
	$img_path = 'assets/templates/landing/assets/img/';
	?>
	</head>
	<body>
		<main class="template1">
			<section class="logo-section">
				<div class="row pt-2 pb-2">
					<div class="col-6">
						<img src="<?=base_url($img_path . 'logo.png');?>" class="img-fluid d-block mx-auto">
					</div>
					<div class="col-6">
						<ul class="nav position-absolute" style="bottom: 0; left: 50%; transform: translateX(-50%);">
							<li class="nav-item active">
								<a class="nav-link" href="#"><img class="imgFacebook"
																  src="<?=base_url();?>assets/templates/landing/assets/img/nav-facebook.png"/></a>
							</li>
							<li class="nav-item">
								<a class="nav-link" href="#"><img class="imgWhatsapp"
																  src="<?=base_url();?>assets/templates/landing/assets/img/nav-whatsapp.png"/></a>
							</li>
							<li class="nav-item">
								<a class="nav-link" href="#"><img class="imgEmail"
																  src="<?=base_url();?>assets/templates/landing/assets/img/nav-email.png"/></a>
							</li>
							<li class="nav-item">
								<a class="nav-link" href="#"><img class="imgSearch"
																  src="<?=base_url();?>assets/templates/landing/assets/img/nav-search.png"/></a>
							</li>
						</ul>
					</div>
				</div>
			</section>
			<section class="header-section text-center">
				<img src="<?=base_url();?>assets/templates/landing/assets/img/<?=$landing['token'];?>/header-banner.png" class="img-fluid d-none d-md-block">
				<img src="<?=base_url();?>assets/templates/landing/assets/img/<?=$landing['token'];?>/header-banner_sm.png" class="img-fluid d-block d-md-none">
			</section>
			<?php
				$product_path = base_url('assets/' . $this->config->item('site_settings')['default_app'] . '/products/' . $landing['token'] . '/');
				$uploads_path = $product_path . 'uploads/';
				if (file_exists(VIEWPATH . 'front/landing/pages/' . $landing['token'] . '.php')) {
					$this->load->view('front/landing/pages/' . $landing['token'], [
						'product_path' => $product_path,
						'img_path' => $product_path . 'img/',
						'vdo_path' => $product_path . 'video/',
						'upload_path' => $product_path . 'uploads/',
					]);
				}
			?>
			<section class="contact-section">
				<div class="container" style="max-width: 968px;">
					<div class="row">
						<div class="col-md-6 left-column">
							<p class="text-left" style="font-weight: 700;">聯絡我們</p>
							<p class="pt-3">中心地址：九龍尖沙咀廣東道5號海港城海洋中心15樓1526-29室</p>
							<p class="pt-3">診症時間：星期一至五：09:30am–06:30pm</p>
							<p class="">(必須預約)星　期　六：09:30am–03:00pm</p>
							<p class="">　　　　 (星期日及公眾假期休息)</p>
						</div>
						<div class="col-md-6">
							<p class="text-left" style="font-weight: 700;">聯絡方法</p>
							<p class="pt-3">診所：(852) 2992 0230</p>
							<p class="">查詢：(852) 6609 0933</p>
							<p class="">日本語查詢電話：(852) 6311 2777</p>
							<p class="">傳真：(852) 3586 3895</p>
							<p class="">電郵：enquiry@psclinic.com.hk</p>
						</div>
					</div>
				</div>
			</section>
			<section class="copyright-area">
				<div class="container">
					<div class="row">
						<div class="col-12">
							<p class="text-center text-white">COPYRIGHT © 2021 <?=$company_name;?>. All Rights Reserved.</p>
						</div>
					</div>
				</div>
			</section>
		</main>
		<script src="<?=base_url();?>assets/templates/landing/assets/js/jquery.min.js"></script>
		<script src="<?=base_url();?>vendor/bootstrap/js/bootstrap.min.js"></script>
		<script src="<?=base_url();?>vendor/moment/moment-with-locales.min.js"></script>
		<script src="<?=base_url();?>vendor/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
		<script src="<?=base_url();?>assets/templates/landing/assets/js/common.js?<?=$hash;?>"></script>
		<script src="<?=base_url();?>assets/templates/landing/assets/js/landing.js?<?=$hash;?>"></script>
	</body>
</html>
