<!-- header starts -->
<?php include dirname(__FILE__) . '/../include/header.php'; ?>
<!-- header ends -->
<!-- main content starts -->
<div class="main-container container-fluid main-admincontent"
	 data-dir="<?= dirname(__FILE__) . '/../include/header.php' ?>">
	<!-- Page Container -->
	<div class="page-container">
		<!-- Page Sidebar -->
		<?php include dirname(__FILE__) . '/../include/sidebar.php'; ?>
		<!-- /Page Sidebar -->

		<!-- Page Content -->
		<div class="page-content">
			<!-- Page Breadcrumb -->
			<div class="page-breadcrumbs">
				<ul class="breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="#"><?= lang('home') ?></a>
					</li>
					<li><a href="/admin/dashboard"><?= lang('dashboard') ?></a></li>
					<li><a href="/admin/notemanagement"><?= lang('notemanagement') ?></a></li>
					<li><?= lang('editnote') ?></li>
				</ul>
			</div>

			<!-- /Page Breadcrumb -->
			<!-- Page Header -->
			<div class="page-header position-relative">
				<div class="header-title">
					<h1>
						<?= lang('editnote') ?>
					</h1>
				</div>
				<!--Header Buttons-->
				<div class="header-buttons">
					<a class="sidebar-toggler" href="#">
						<i class="fa fa-arrows-h"></i>
					</a>
					<a class="refresh" id="refresh-toggler" href="#">
						<i class="glyphicon glyphicon-refresh"></i>
					</a>
					<a class="fullscreen" id="fullscreen-toggler" href="#">
						<i class="glyphicon glyphicon-fullscreen"></i>
					</a>
				</div>
				<!--Header Buttons End-->
			</div>
			<!-- /Page Header -->
			<!-- Page Body -->
			<div class="page-body">
				<div class="form-container">
					<form id="phpform" class="form-horizontal" action="/admin/notemanagement/save" method="post"
						  enctype="multipart/form-data">
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label
										for="course"><span><?= lang('coursename') ?></span></label></div>
							<div class="col-sm-9 mas-box"><select id="course" name="course_id"
																  data-coursename="<?=lang('coursename')?>" data-courseid="<?=$course_id?>">
									<option value="">-- <?= lang('coursename') ?> --</option>
								</select></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label
										for="unit"><span><?= lang('unitname') ?></span></label></div>
							<div class="col-sm-9 mas-box"><select id="unit" name="unit_id" data-unitname="<?=lang('unitname')?>" data-unitid="<?=$item['unit_id']?>">
									<option value="">-- <?= lang('unitname') ?> --</option>
								</select></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label
										for="name"><?= lang('notename') ?></label></div>
							<div class="col-sm-9 mas-box"><input id="name" type="text" class="form-control mas-input"
																 name="title"
																 placeholder="--- 輸入<?= lang('notename') ?> ---" value="<?=$item['title']?>"/></div>
						</div>

						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="file"><span>筆記檔案</span></label>
							</div>
							<div class="col-sm-9 mas-box">
								<a href="<?=base_url('assets/uploads/note/').$item['filename']?>" target="_blank"><?=$item['title']?></a>
							</div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="file"><span>上載筆記檔案</span></label>
							</div>
							<div class="col-sm-9 mas-box"><input type="file" name="file" id="file"/></div>
						</div>
						<div class="form-footer">
							<div class="col-sm-3">&nbsp;</div>
							<div class="col-sm-9 mas-box">
								<a id="btnSubmit" class="btn btn-footer" href="javascript:void(0);">提交</a>
								<a class="btn btn-footer reset" href="javascript:window.location.reload(true)">重設</a>
							</div>
							<input type="hidden" name="id" value="<?=$item['id']?>">
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function () {
		getRemoteData('/api/unit/getcourse', {}, getcourseOk, getRemoteDataFail);
	});

	$(document).on('click', '#btnSubmit', function () {
		if (validform()) {
			$('#phpform').submit();
		}
	});

	function getcourseOk(data) {
		// console.log('data:',data.data);
		let $course = $('#course');
		$course.empty();
		$course.append('<option value="">-- ' + $course.data('coursename') + ' --</option>');
		$.each(data.data, function (i, e) {
			var o = new Option(e.name, e.id);
			$(o).html(e.name);
			$('#course').append(o);
		});
		$course.val($course.data('courseid'));
		$course.trigger('change');
	}

	$(document).on('change', '#course', function () {
		getRemoteData('/api/unit/getunitbycourse', {course_id: $(this).val()}, getunitOk, getRemoteDataFail);
	});

	function getunitOk(data) {
		// console.log('data:',data.data);
		let $unit = $('#unit');
		$unit.empty();
		$unit.append('<option value="">-- ' + $unit.data('unitname') + ' --</option>');
		$.each(data.data, function (i, e) {
			var o= parseInt(e.id)===parseInt($unit.data('unitid'))?new Option(e.title,e.id,true,true):new Option(e.title,e.id);
			$(o).html(e.title);
			$('#unit').append(o);
		});
	}

	function validform() {
		var msg = '';
		if ($('#course').val() === '') {
			msg += "請輸入課程名稱<br>";
		}
		if ($('#unit').val() === '') {
			msg += "請輸入章節名稱<br>";
		}
		if ($('#name').val() === '') {
			msg += "請輸入筆記名稱<br>";		}
		
		if (document.getElementById('file').files.length === 0) {
			msg += "請上載筆記<br>";
		}
		if (msg !== '') {
			$.fancybox.open(msg);
		}
		return msg === '';
	}

	function getRemoteData(remote_url, data, callback, callbackFail) {
		$.ajax({
//async: false,
//timeout: 30000, //最長等候回應時間
			type: "GET", //提交類型
			url: remote_url, //提交地址
			data: data, //提交內容
			dataType: 'json', //返回數據類型
			success: function (data) { //請求完成並成功
				if (data.success) {
					callback(data);
				} else {
					callbackFail();
				}
			},
			error: function (data) { //請求返回錯誤信息
				callbackFail();
			},
			beforeSend: function (XHR) { //请求開始前执行
			},
			complete: function (XHR, status) { //请求完成后最终执行
			}
		});
	}

	function getRemoteDataFail() {
		alert("發生錯誤");
	}
</script>
<?php include dirname(__FILE__) . '/../include/footer.php'; ?>

