<!-- header starts -->
<?php include dirname(__FILE__) . '/../include/header.php'; ?>
<!-- header ends -->
<!-- main content starts -->
<div class="main-container container-fluid main-admincontent"
	 data-dir="<?= dirname(__FILE__) . '/../include/header.php' ?>">
	<!-- Page Container -->
	<div class="page-container">
		<!-- Page Sidebar -->
		<?php include dirname(__FILE__) . '/../include/sidebar.php'; ?>
		<!-- /Page Sidebar -->

		<!-- Page Content -->
		<div class="page-content">
			<!-- Page Breadcrumb -->
			<div class="page-breadcrumbs">
				<ul class="breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="#"><?= lang('home') ?></a>
					</li>
					<li><a href="/admin/dashboard"><?= lang('dashboard') ?></a></li>
					<li><a href="/admin/videomanagement"><?= lang('videomanagement') ?></a></li>
					<li><?= lang('editvideo') ?></li>
				</ul>
			</div>

			<!-- /Page Breadcrumb -->
			<!-- Page Header -->
			<div class="page-header position-relative">
				<div class="header-title">
					<h1>
						<?= lang('editvideo') ?>
					</h1>
				</div>
				<!--Header Buttons-->
				<div class="header-buttons">
					<a class="sidebar-toggler" href="#">
						<i class="fa fa-arrows-h"></i>
					</a>
					<a class="refresh" id="refresh-toggler" href="#">
						<i class="glyphicon glyphicon-refresh"></i>
					</a>
					<a class="fullscreen" id="fullscreen-toggler" href="#">
						<i class="glyphicon glyphicon-fullscreen"></i>
					</a>
				</div>
				<!--Header Buttons End-->
			</div>
			<!-- /Page Header -->
			<!-- Page Body -->
			<div class="page-body">
				<div class="form-container">
					<form id="phpform" class="form-horizontal" action="/admin/videomanagement/save" method="post"
						  enctype="multipart/form-data">
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="course"><span><?=lang('coursename')?></span></label></div>
							<div class="col-sm-9 mas-box"><select id="course" name="course_id" data-coursename="<?=lang('coursename')?>" data-courseid="<?=$course_id?>"><option value="">-- <?=lang('coursename')?> --</option></select></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="unit"><span><?=lang('unitname')?></span></label></div>
							<div class="col-sm-9 mas-box"><select id="unit" name="unit_id" data-unitname="<?=lang('unitname')?>" data-unitid="<?=$item['unit_id']?>"><option value="">-- <?=lang('unitname')?> --</option></select></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="name"><?=lang('videoname')?></label></div>
							<div class="col-sm-9 mas-box"><input id="name" type="text" class="form-control mas-input" name="name" placeholder="--- 輸入<?=lang('videoname')?> ---" value="<?=$item['name']?>"/></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="duration">影片長度</label></div>
							<div class="col-sm-9 mas-box"><input id="duration" type="number"
																 class="form-control mas-input" name="duration"
																 placeholder="--- 輸入影片長度 ---" value="<?=$item['duration']?>"/></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="file"><span>影片</span></label>
							</div>
							<div class="col-sm-9 mas-box">
								<video id="myVideo" width="320" height="176">
									<source src="<?= base_url('assets/uploads/video/') . $item['filename'] ?>"
											type="video/mp4">
									Your browser does not support HTML5 video.
								</video>

								<div class="row" style="padding-left:1em;padding-top:1em;">
									<button id="btnPlay" type="button"><?= lang('playvideo') ?></button>
									<button id="btnPause" type="button"><?= lang('pausevideo') ?></button>
								</div>

							</div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="file"><span>上載影片</span></label>
							</div>
							<div class="col-sm-9 mas-box"><input type="file" name="file" id="file"/></div>
						</div>
						<div class="form-footer">
							<div class="col-sm-3">&nbsp;</div>
							<div class="col-sm-9 mas-box">
								<a id="btnSubmit" class="btn btn-footer" href="javascript:void(0);">提交</a>
								<a class="btn btn-footer reset" href="javascript:window.location.reload(true)">重設</a>
								<input type="hidden" name="id" value="<?=$item['id']?>">
							</div>

						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function () {
		getRemoteData('/api/unit/getcourse', {}, getcourseOk, getRemoteDataFail);
	});
	var vid = document.getElementById('myVideo');
	$(document).on('click', '#btnPlay', function () {
		playVid();
	});
	$(document).on('click', '#btnPause',function(){
		pauseVid();
	});

	function playVid() {
		vid.play();
	}

	function pauseVid() {
		vid.pause();
	}

	$(document).on('click', '#btnSubmit', function () {
		if (validform()) {
			$('#phpform').submit();
		}
	});

	function getcourseOk(data){
		// console.log('data:',data.data);
		let $course=$('#course');
		$course.empty();
		$course.append('<option value="">-- '+$course.data('coursename')+' --</option>');
		$.each(data.data, function(i,e){
			var o=new Option(e.name,e.id);
			$(o).html(e.name);
			$('#course').append(o);
		});
		// console.log('courseid:'+$course.data('courseid'));
		$course.val($course.data('courseid'));
		$course.trigger('change');
	}

	$(document).on('change','#course',function(){
		getRemoteData('/api/unit/getunitbycourse',{course_id:$(this).val()},getunitOk,getRemoteDataFail);
	});

	function getunitOk(data){
		// console.log('data:',data.data);
		let $unit = $('#unit');
		$unit.empty();
		$unit.append('<option value="">-- '+$unit.data('unitname')+' --</option>');
		$.each(data.data, function(i,e){
			var o= parseInt(e.id)===parseInt($unit.data('unitid'))?new Option(e.title,e.id,true,true):new Option(e.title,e.id);
			$(o).html(e.title);
			$('#unit').append(o);
		});
	}

	function validform() {
		var msg = '';
		if ($('#course').val() === '') {
			msg += "請輸入課程名稱<br>";
		}
		if ($('#unit').val() === '') {
			msg += "請輸入章節名稱<br>";
		}
		if ($('#name').val() === '') {
			msg += "請輸入影片名稱<br>";
		}
		if ($('#duration').val() === '') {
			msg += "請輸入影片時間<br>";
		}

		if (msg !== '') {
			$.fancybox.open(msg);
		}
		return msg === '';
	}

	function getRemoteData(remote_url, data, callback, callbackFail) {
		$.ajax({
//async: false,
//timeout: 30000, //最長等候回應時間
			type: "GET", //提交類型
			url: remote_url, //提交地址
			data: data, //提交內容
			dataType: 'json', //返回數據類型
			success: function (data) { //請求完成並成功
				if (data.success) {
					callback(data);
				} else {
					callbackFail();
				}
			},
			error: function (data) { //請求返回錯誤信息
				callbackFail();
			},
			beforeSend: function (XHR) { //请求開始前执行
			},
			complete: function (XHR, status) { //请求完成后最终执行
			}
		});
	}

	function getRemoteDataFail() {
		alert("發生錯誤");
	}
</script>
<?php include dirname(__FILE__) . '/../include/footer.php'; ?>

