<!-- header starts -->
<?php include dirname(__FILE__) . '/../../include/header.php'; ?>
<!-- header ends -->
<!-- main content starts -->
<div class="main-container container-fluid main-admincontent"
	 data-dir="<?= dirname(__FILE__) . '/../../include/header.php' ?>">
	<!-- Page Container -->
	<div class="page-container">
		<!-- Page Sidebar -->
		<?php include dirname(__FILE__) . '/../../include/sidebar.php'; ?>
		<!-- /Page Sidebar -->

		<!-- Page Content -->
		<div class="page-content">
			<!-- Page Breadcrumb -->
			<div class="page-breadcrumbs">
				<ul class="breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="#"><?= lang('home') ?></a>
					</li>
					<li><?= lang('emarketingmanagement') ?></li>
					<li class="active"><?= lang('rules') ?></li>
				</ul>
			</div>
			<!-- /Page Breadcrumb -->
			<!-- Page Header -->
			<div class="page-header position-relative">
				<div class="header-title">
					<h1>
						<?= lang('rules') ?>
					</h1>
				</div>
				<!--Header Buttons-->
				<div class="header-buttons">
					<a class="sidebar-toggler" href="#">
						<i class="fa fa-arrows-h"></i>
					</a>
					<a class="refresh" id="refresh-toggler" href="#">
						<i class="glyphicon glyphicon-refresh"></i>
					</a>
					<a class="fullscreen" id="fullscreen-toggler" href="#">
						<i class="glyphicon glyphicon-fullscreen"></i>
					</a>
				</div>
				<!--Header Buttons End-->
			</div>
			<!-- /Page Header -->
			<!-- Page Body -->
			<div class="page-body">
				<ul class="table-toolbar">
					<li>
						<a href="/admin/emarketingmanagement/addrule"
						   class="toolbar-element btn btn-default btn-create"><i
									class="fa fa-plus-circle"
									style="margin-right: 8px;"></i><?= lang('add') . lang('rules') ?></a>
					</li>
					<li>
						<a class="toolbar-element btn btn-default btn-delete"><i class="fa fa-trash"
																				 style="margin-right: 8px;"
																				 aria-hidden="true"></i><?= lang('remove') . lang('rules') ?>
						</a>
					</li>
				</ul>

				<table id="myTable" class="display table dataTable datatables" cellspacing="0" width="100%"
					   data-url="<?= base_url('api/emarketing/rules') ?>"
					   data-pagesize="<?= findsettingByKey($settings, 'pagesize') ?>"
					   data-del="<?= lang('confirmdelete') ?>" data-delitemreq="<?= lang('delitemrequired') ?>">
					<thead>
					<tr>
						<th>編號</th>
						<th><?= lang('type') ?></th>
						<th><?= lang('name') ?></th>
						<th><?= lang('trigger') ?></th>
						<th><?= lang('action') ?></th>
						<th><?= lang('details') ?></th>
						<th><?= lang('remove') ?></th>
					</tr>
					</thead>
				</table>
			</div>
		</div>
	</div>
</div>

<script>
	var ids = [];
	var table, data = [];
	var checkall = false;

	function getRemoteData(remote_url, data, callback, callbackFail) {
		$.ajax({
//async: false,
//timeout: 30000, //最長等候回應時間
			type: "GET", //提交類型
			url: remote_url, //提交地址
			data: data, //提交內容
			dataType: 'json', //返回數據類型
			success: function (data) { //請求完成並成功
				if (data.success) {
					callback(data);
				} else {
					callbackFail();
				}
			},
			error: function (data) { //請求返回錯誤信息
				callbackFail();
			},
			beforeSend: function (XHR) { //请求開始前执行
			},
			complete: function (XHR, status) { //请求完成后最终执行
			}
		});
	}

	function getRemoteDataFail() {
		alert("發生錯誤");
	}

	$(document).ready(function () {
		let $tbl = $('#myTable');
		const url = $tbl.data('url');
		const pagesize = $tbl.data('pagesize');
		table = $tbl.DataTable({
			"processing": true,
			"serverSide": true,
			"ajax": url,
			"columns": [
				{"data": "id"},
				{"data": "type", "name": ""},
				{"data": "name", "name": ""},
				{"data": "trigger", "name": ""},
				{"data": "action", "name": ""},
				{"data": "details", "name": "", "class": "control-details"},
				{"data": "delete", "name": "", "class": "control-delete"},
			],
			"order": [
				[0, "desc"],
			],
			"columnDefs": [
				{
					"targets": [0],
					"visible": false,
					"searchable": false,
				},
				// {
				// 	"targets": [2],
				// 	"visible": true,
				// 	"searchable": true,
				// 	"orderable": false,
				// },
				// {
				// 	"targets": [5, 7],
				// 	"visible": true,
				// 	"searchable": false,
				// 	"orderable": true,
				// },
				{
					"targets": [1,2,5,6],
					"visible": true,
					"searchable": false,
					"orderable": false,
				},
			],
			language: {
				"processing": "處理中...",
				"loadingRecords": "載入中...",
				"lengthMenu": "顯示數量 _MENU_ ",
				"zeroRecords": "沒有符合的結果",
				"info": "顯示 _START_-_END_（總數：_TOTAL_）",
				"infoEmpty": "0 項結果",
				"infoFiltered": "(從 _MAX_ 項結果中過濾)",
				"infoPostFix": "",
				"search": "搜尋:",
				"paginate": {
					"first": "首頁",
					"previous": "上一頁",
					"next": "下一頁",
					"last": "末頁"
				},
				"aria": {
					"sortAscending": ": 升冪排列",
					"sortDescending": ": 降冪排列"
				}
			},
			"pageLength": pagesize,
			"pagingType": "full_numbers",
			"drawCallback": function (settings) {
				var info = table.page.info();
				// console.log('pageinfo:',info);
				// console.log('Currently showing page '+(info.page+1)+' of '+info.pages+' pages.');
				$('.recorddisplay').text(info.recordsDisplay);
				$('.pagenum').val(info.page + 1);
//                console.log(settings['json']['data']);
//                data = settings['json']['data'];//don't use this data, as it is filtered=>not all
				$('.nextpage').on('click', function () {
					$('#myTable_next').trigger('click');
				});
				$('.prevpage').on('click', function () {
					$('#myTable_previous').trigger('click');
				});

				$.each(ids, function (k, v) {
					$('.checkbox-delete').each(function (i, e) {
						if (v === $(e).attr('id')) {
							$(e).prop('checked', true);
							return false;
						}
					});
				});
				$('i[id^="details-"]').on('click', function (event) {
					event.preventDefault();
					var newForm = $('<form>', {
						'action': '/admin/emarketingmanagement/editrule',
						'method': 'post',
					}).append($('<input>', {
						'name': 'id',
						'value': this.id.replace('details-', ''),
						'type': 'hidden'
					}));
					$(document.body).append(newForm);
					newForm.submit();
				});
			},
		});
		//
		$('#myTable_filter').hide();
		$('.dataTables_length').hide();
		// $('#myTable_info').hide();
		// $('#myTable_paginate').hide();
	});

	function doFilter(keyword) {
		let s = table.columns().search('');
		if (keyword !== '') {
			s = s.columns(2).search(keyword);
			s.draw();
		} else {
			window.location.reload(true);
		}

		$('#myTable_filter').hide();
		$('.dataTables_length').hide();
		// $('#myTable_info').hide();
		// $('#myTable_paginate').hide();
	}

	$(document).on('click', '#btnSearch', function () {
		const keyword = $('#keyword').val();
		if (keyword !== '') {
			doFilter(keyword.trim());
		}
	});
	$(document).on('change', '#keyword', function () {
		if ($(this).val() === '') {
			window.location.reload(true);
		}
	});

	$(document).on('change', '.checkbox-delete', function () {
		var id = $(this).attr('id');
		if (this.checked && ids.indexOf(id) === -1) {
			ids.push(id);
		} else {
			var idx = ids.indexOf(id);
			if (idx > -1) {
				ids.splice(idx, 1);
			}
			checkall = false;
			$('.checkbox-delete-all').prop('checked', false);
		}
		if (ids.length > 0) {
			$.each(ids, function (i, e) {
				if (e === id) {
					$(this).prop('checked', true);
				}
			});
		}
	});

	$(document).on('change', '.checkbox-delete-all', function () {
		if (this.checked) {
			getRemoteData(
					"/api/emarketing/getallids",
					{},
					getAllIdsOk,
					getRemoteDataFail
			);
		} else {
			ids = [];
		}
		$('.checkbox-delete').prop('checked', this.checked);
		checkall = this.checked;
	});

	function getAllIdsOk(Ids) {
		ids = Ids;
	}

	$(document).on('click', '.btn-delete', function () {
		if (ids.length === 0) {
			$.fancybox.open($('#myTable').data('delitemreq'));
			return false;
		}
		if (confirm($('#myTable').data('del'))) {
			$.post("/api/emarketing/deletebulk_rules", {ids: ids})
					.done(function (data) {
						window.location.reload(true);
					});
		}

	});
</script>

<?php include dirname(__FILE__) . '/../../include/footer.php'; ?>

