<!-- header starts -->
<?php include dirname(__FILE__) . '/../../include/header.php'; ?>
<!-- header ends -->
<!-- main content starts -->
<div class="main-container container-fluid main-admincontent"
	 data-dir="<?= dirname(__FILE__) . '/../../include/header.php' ?>">
	<!-- Page Container -->
	<div class="page-container">
		<!-- Page Sidebar -->
		<?php include dirname(__FILE__) . '/../../include/sidebar.php'; ?>
		<!-- /Page Sidebar -->

		<!-- Page Content -->
		<div class="page-content">
			<!-- Page Breadcrumb -->
			<div class="page-breadcrumbs">
				<ul class="breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="#"><?= lang('home') ?></a>
					</li>
					<li><a href="/admin/dashboard"><?= lang('dashboard') ?></a></li>
					<li><a href="/admin/emarketingmanagement/rules"><?= lang('emarketingmanagement') ?></a></li>
					<li><?= lang('edit') . lang('rules') ?></li>
				</ul>
			</div>
			<!-- /Page Breadcrumb -->
			<!-- Page Header -->
			<div class="page-header position-relative">
				<div class="header-title">
					<h1>
						<?= lang('edit') . lang('rules') ?>
					</h1>
				</div>
				<!--Header Buttons-->
				<div class="header-buttons">
					<a class="sidebar-toggler" href="#">
						<i class="fa fa-arrows-h"></i>
					</a>
					<a class="refresh" id="refresh-toggler" href="#">
						<i class="glyphicon glyphicon-refresh"></i>
					</a>
					<a class="fullscreen" id="fullscreen-toggler" href="#">
						<i class="glyphicon glyphicon-fullscreen"></i>
					</a>
				</div>
				<!--Header Buttons End-->
			</div>
			<!-- /Page Header -->
			<!-- Page Body -->
			<div class="page-body">
				<div class="form-container">
					<form id="phpform" class="form-horizontal" role="form" method="post"
						  action="/admin/emarketingmanagement/saverule">
						<div id="triggerblock" class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label
										for="triggers"><?= lang('trigger') ?></label></div>
							<div class="col-sm-9 mas-box">
								<select class="form-control" id="triggers" name="trigger"
										data-triggerid="<?= isset($item) ? $item['trigger'] : '' ?>">
									<option value="">-- <?= lang('select') . lang('trigger') ?> --</option>
									<?php foreach ($triggers as $k => $trigger): ?>
										<option value="<?= $trigger ?>"><?= $k ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>
						<div id="listblock" class="form-group mas-col" style="display:none;">
							<div class="col-sm-3 text-center mas-title"><label
										for="lists"><?= lang('subscription') . lang('list') ?></label></div>
							<div class="col-sm-9 mas-box">
								<select class="form-control" id="lists" name="list"
										data-listid="<?= isset($item) ? $item['list'] : '' ?>">
									<option value="">-- <?= lang('select') . lang('subscriptionlist') ?> --</option>
									<?php foreach ($subscriptionlists as $v): ?>
										<option value="<?= $v['id'] ?>"><?= $v['name'] ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>

						<div id="actionblock" class="form-group mas-col" style="display:none;">
							<div class="col-sm-3 text-center mas-title"><label
										for="actions"><?= lang('action') ?></label></div>
							<div class="col-sm-9 mas-box">
								<select class="form-control" id="actions" name="action"
										data-actionid="<?= isset($item) ? $item['action'] : '' ?>">
									<option value="">-- <?= lang('select') . lang('action') ?> --</option>
									<?php foreach ($actions as $k => $action): ?>
										<option value="<?= $action ?>"><?= $k ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>

						<div id="unlistblock" class="form-group mas-col" style="display:none;">
							<div class="col-sm-3 text-center mas-title"><label
										for="unlists"><?= lang('un_subscribe') . lang('list') ?></label></div>
							<div class="col-sm-9 mas-box">
								<select class="form-control" id="unlists" name="unsubscribe_list_id"
										data-unlistid="<?= isset($item) ? $item['unsubscribe_list_id'] : '' ?>">
									<option value="">-- <?= lang('select') . lang('subscriptionlist') ?> --</option>
									<?php foreach ($subscriptionlists as $v): ?>
										<option value="<?= $v['id'] ?>"><?= $v['name'] ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>

						<div id="webhookblock" class="form-group mas-col" style="display:none;">
							<div class="col-sm-3 text-center mas-title"><label
										for="endpoint"><?= lang('webhook') ?></label></div>
							<div class="col-sm-9 mas-box">
								<input type="text" id="endpoint" name="endpoint" value="<?=isset($item)?$item['endpoint']:''?>">
							</div>
						</div>

						<div id="emailblock" class="form-group mas-col" style="display:none;">
							<div class="col-sm-3 text-center mas-title"><label
										for="email"><?= lang('notification') . lang('email') ?></label></div>
							<div class="col-sm-9 mas-box">
								<input type="email" id="email" name="notification_email" value="<?=isset($item)?$item['notification_email']:''?>">
							</div>
						</div>

						<div class="form-footer">
							<div class="col-sm-3">&nbsp;</div>
							<div class="col-sm-9 mas-box">
								<a id="btnSubmit" class="btn btn-footer" href="javascript:void(0);">提交</a>
								<a class="btn btn-footer reset" href="javascript:window.location.reload(true)">重設</a>
							</div>
						</div>
						<input type="hidden" name="id" value="<?=$item['id']?>">
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	let actionlist = [];
	let webhook = false;
	let email = false;

	$(document).ready(function () {
		const $action = $('#actions');
		$.each($action.prop('options'), function (i, opt) {
			actionlist.push({"name": opt.value, "value": opt.textContent});
		});
		const $trigger = $('#triggers');
		$trigger.val($trigger.data('triggerid'));
		$trigger.trigger('change');
		$action.val($action.data('actionid'));
		$action.trigger('change');
		const $list = $('#lists');
		$list.val($list.data('listid'));
		$list.trigger('change');
		const $unlist = $('#unlists');
		$unlist.val($unlist.data('unlistid'));
		$unlist.trigger('change');
	});

	function reloadactions() {
		$('#actions').empty();
		$.each(actionlist, function (i, e) {
			// console.log('name:' + e.name + ';value:' + e.value);
			$('<option>').val(e.name).text(e.value).appendTo($('#actions'));
		});
	}

	$(document).on('change', '#triggers', function () {
		const trigger = $(this).val();
		const $list = $('#listblock');
		const $action = $('#actionblock');
		let $drpaction = $action.find('#actions');
		if (trigger !== '') {
			switch (trigger) {
				case 'subscribe':
					$list.show();
					reloadactions();
					break;
				case 'unsubscribe':
					$list.show();
					$drpaction.find('option[value="unsub_from_list"]').remove();
					break;
				case 'campaign_sent':
					$action.show();
					$drpaction.find('option[value="unsub_from_list"]').remove();
					break;
				case 'campaign_sending':
				default:
					$action.show();
					$drpaction.find('option[value="unsub_from_list"]').remove();
					$list.hide();
					break;
			}
		}
	});

	$(document).on('change', '#lists', function () {
		if ($(this).val() !== '') {
			$('#actionblock').show();
		}
	});
	$(document).on('change', '#actions', function () {
		const action = $(this).val();
		const $unlist = $('#unlistblock');
		const $web = $('#webhookblock');
		const $email = $('#emailblock');
		if (action !== '') {
			webhook = false;
			email = false;
			switch (action) {
				case 'webhook':
					$unlist.hide();
					$email.hide();
					$web.show();
					webhook = true;
					break;
				case 'notify':
					$email.show();
					email = true;
					$web.hide();
					$unlist.hide();
					break;
				case 'unsub_from_list':
					$email.hide();
					$web.hide();
					$unlist.show();
					break;
			}
		}
	});

	$(document).on('click', '#btnSubmit', function () {
		if (validform()) {
			$('#phpform').submit();
		}
	});

	function validform() {
		var msg = '';
		if (webhook === true && $('#endpoint').val() === '') {
			msg += "請輸入網絡釣子<br>";
		}
		if (email === true) {
			const $email = $('#email')
			if ($email.val() === '') {
				msg += "請輸入通知電郵地址<br>";
			} else if (!validateEmail($email.val())) {
				msg += "請輸入正確的電郵地址<br>";
			}
		}

		if (msg !== '') {
			$.fancybox.open(msg);
		}
		return msg === '';
	}

	function getRemoteData(remote_url, data, callback, callbackFail) {
		$.ajax({
//async: false,
//timeout: 30000, //最長等候回應時間
			type: "GET", //提交類型
			url: remote_url, //提交地址
			data: data, //提交內容
			dataType: 'json', //返回數據類型
			success: function (data) { //請求完成並成功
				if (data.success) {
					callback(data);
				} else {
					callbackFail();
				}
			},
			error: function (data) { //請求返回錯誤信息
				callbackFail();
			},
			beforeSend: function (XHR) { //请求開始前执行
			},
			complete: function (XHR, status) { //请求完成后最终执行
			}
		});
	}

	function getRemoteDataFail() {
		alert("發生錯誤");
	}

	function validateEmail(email) {
		const re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
		return re.test(String(email).toLowerCase());
	}
</script>
<?php include dirname(__FILE__) . '/../../include/footer.php'; ?>

