<!-- header starts -->
<?php include dirname(__FILE__) . '/../../include/header.php'; ?>
<!-- header ends -->
<!-- main content starts -->
<div class="main-container container-fluid main-admincontent" data-dir="<?=dirname(__FILE__). '/../../include/header.php'?>">
	<!-- Page Container -->
	<div class="page-container">
		<!-- Page Sidebar -->
		<?php include dirname(__FILE__) . '/../../include/sidebar.php'; ?>
		<!-- /Page Sidebar -->

		<!-- Page Content -->
		<div class="page-content">
			<!-- Page Breadcrumb -->
			<div class="page-breadcrumbs">
				<ul class="breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="#"><?= lang('home') ?></a>
					</li>
					<li><a href="/admin/dashboard"><?= lang('dashboard') ?></a></li>
					<li><a href="/admin/emarketingmanagement/campaigns"><?=lang('emarketingmanagement')?></a></li>
					<li><?=lang('edit').lang('campaigns')?></li>
				</ul>
			</div>
			<!-- /Page Breadcrumb -->
			<!-- Page Header -->
			<div class="page-header position-relative">
				<div class="header-title">
					<h1>
						<?=lang('edit').lang('campaigns')?>
					</h1>
				</div>
				<!--Header Buttons-->
				<div class="header-buttons">
					<a class="sidebar-toggler" href="#">
						<i class="fa fa-arrows-h"></i>
					</a>
					<a class="refresh" id="refresh-toggler" href="#">
						<i class="glyphicon glyphicon-refresh"></i>
					</a>
					<a class="fullscreen" id="fullscreen-toggler" href="#">
						<i class="glyphicon glyphicon-fullscreen"></i>
					</a>
				</div>
				<!--Header Buttons End-->
			</div>
			<!-- /Page Header -->
			<!-- Page Body -->
			<div class="page-body">
				<div class="form-container">
					<form id="phpform" class="form-horizontal" role="form" method="post" action="/admin/emarketingmanagement/savecampaign">
						<div id="templateblock" class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="template"><?=lang('template')?></label></div>
							<div class="col-sm-9 mas-box">
								<select class="form-control" id="templates">
									<option value="">-- <?=lang('select').lang('template')?> --</option>
									<?php foreach($templates as $template):?>
										<option value="<?=$template['id']?>"><?=$template['template_name']?></option>
									<?php endforeach;?>
								</select>
							</div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="title"><?=lang('emark_subject')?></label></div>
							<div class="col-sm-9 mas-box"><input id="title" type="text" class="form-control mas-input" name="title" placeholder="--- 輸入<?=lang('emark_subject')?> ---" value="<?=$item['title']?>" /></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="from_name"><?=lang('from_name')?></label></div>
							<div class="col-sm-9 mas-box"><input id="from_name" type="text" class="form-control mas-input" name="from_name" placeholder="--- 輸入<?=lang('from_name')?> ---"  value="<?=$item['from_name']?>"/></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="from_email"><?=lang('from_email')?></label></div>
							<div class="col-sm-9 mas-box"><input id="from_email" type="text" class="form-control mas-input" name="from_email" placeholder="--- 輸入<?=lang('from_email')?> ---"  value="<?=$item['from_email']?>"/></div>
						</div>

						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="reply_to"><?=lang('reply_email')?></label></div>
							<div class="col-sm-9 mas-box"><input id="reply_to" type="text" class="form-control mas-input" name="reply_to" placeholder="--- 輸入<?=lang('reply_email')?> ---"  value="<?=$item['reply_to']?>"/></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="plain_text"><?=lang('plaintext')?></label></div>
							<div class="col-sm-9 mas-box"><textarea id="plain_text"  class="form-control mas-textarea" rows="15" name="plain_text" placeholder="--- 輸入<?=lang('plaintext')?> ---"><?=$item['plain_text']?></textarea></div>
						</div>
						<div class="form-group mas-col">
							<div class="col-sm-3 text-center mas-title"><label for="html_text"><?=lang('htmltext')?></label></div>
							<div class="col-sm-9 mas-box"><textarea id="editor1"  class="form-control mas-textarea" rows="15" name="html_text" placeholder="--- 輸入<?=lang('htmltext')?> ---"><?=$item['html_text']?></textarea></div>
						</div>
						<div class="form-footer">
							<div class="col-sm-3">&nbsp;</div>
							<div class="col-sm-9 mas-box">
							<a id="btnSubmit" class="btn btn-footer" href="javascript:void(0);">提交</a>
							<a class="btn btn-footer reset" href="javascript:window.location.reload(true)">重設</a>
								<input type="hidden" name="id" value="<?=$item['id']?>">
							</div>
						</div>

						<input type="hidden" id="fromname" value="<?=$apps['from_name']?>">
						<input type="hidden" id="fromemail" value="<?=$apps['from_email']?>">
						<input type="hidden" id="replyto" value="<?=$apps['reply_to']?>">

					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<script src="/assets/js/ckeditor/ckeditor.js"></script>
<script>
	$(document).ready(function () {
		CKEDITOR.replace('editor1');
	});

	$(document).on('change','#templates',function(){
		if($(this).val()!==''){
			getRemoteData('/api/emarketing/gettemplate',{'id':$(this).val()},gettemplateOk,getRemoteDataFail);
		}
	});

	function gettemplateOk(data){
		// console.log('data:',data.data.html_text);
		if(data.data.html_text!==null){
			CKEDITOR.instances['editor1'].setData(data.data.html_text);
		}else{
			$('#plain_text').text(data.data.plain_text);
		}
		$('#title').val(data.data.template_name);
		$('#from_name').val($('#fromname').val());
		$('#from_email').val($('#fromemail').val());
		$('#reply_to').val($('#replyto').val());
	}

	$(document).on('click','#btnSubmit',function (){
		if(validform()){
			$('#phpform').submit();
		}
	});

	function validform(){
		var msg='';
		if($('#name').val()===''){
			msg+="請輸入課程名稱<br>";
		}
		if($('#duration').val()===''){
			msg+="請輸入課程總時間<br>";
		}
		// if($('#price').val()===''){
		// 	msg+="請輸入課程收費<br>";
		// }
		if(msg!==''){
			$.fancybox.open(msg);
		}
		return msg==='';
	}

	function getRemoteData(remote_url, data, callback, callbackFail) {
		$.ajax({
//async: false,
//timeout: 30000, //最長等候回應時間
			type: "GET", //提交類型
			url: remote_url, //提交地址
			data: data, //提交內容
			dataType: 'json', //返回數據類型
			success: function (data) { //請求完成並成功
				if (data.success) {
					callback(data);
				} else {
					callbackFail();
				}
			},
			error: function (data) { //請求返回錯誤信息
				callbackFail();
			},
			beforeSend: function (XHR) { //请求開始前执行
			},
			complete: function (XHR, status) { //请求完成后最终执行
			}
		});
	}
	function getRemoteDataFail() {
		alert("發生錯誤");
	}
</script>
<?php include dirname(__FILE__) . '/../../include/footer.php'; ?>

