<!-- header starts -->
<?php include dirname(__FILE__) . '/../include/header.php'; ?>
<!-- header ends -->
<!-- main content starts -->
<div class="main-container container-fluid main-admincontent"
	 data-dir="<?= dirname(__FILE__) . '/../include/header.php' ?>">
	<!-- Page Container -->
	<div class="page-container">
		<!-- Page Sidebar -->
		<?php include dirname(__FILE__) . '/../include/sidebar.php'; ?>
		<!-- /Page Sidebar -->

		<!-- Page Content -->
		<div class="page-content">
			<!-- Page Breadcrumb -->
			<div class="page-breadcrumbs">
				<ul class="breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="#"><?= lang('home') ?></a>
					</li>
					<li><a href="/admin/dashboard"><?= lang('dashboard') ?></a></li>
					<li><a href="/admin/courseuser"><?= lang('coursepurchased') ?></a></li>
					<li><?= lang('detail') ?></li>
				</ul>
			</div>
			<!-- /Page Breadcrumb -->
			<!-- Page Header -->
			<div class="page-header position-relative">
				<div class="header-title">
					<h1>
						<?= lang('detail') ?>
					</h1>
				</div>
				<!--Header Buttons-->
				<div class="header-buttons">
					<a class="sidebar-toggler" href="#">
						<i class="fa fa-arrows-h"></i>
					</a>
					<a class="refresh" id="refresh-toggler" href="#">
						<i class="glyphicon glyphicon-refresh"></i>
					</a>
					<a class="fullscreen" id="fullscreen-toggler" href="#">
						<i class="glyphicon glyphicon-fullscreen"></i>
					</a>
				</div>
				<!--Header Buttons End-->
			</div>
			<!-- /Page Header -->
			<!-- Page Body -->
			<div class="page-body">
				<div class="courserow">
					<div class="coursecolumn">
						<div class="titlebar">
							<?= lang('order') . lang('detail') ?>
						</div>
						<div class="coursecontent">
							<div class="form-group row">
								<label for="" class="col-sm-2 col-form-label"><?= lang('orderdatetime') ?></label>
								<div class="col-sm-10"><span><?= isset($item) ? $item->create_time : formatdatetime(time()) ?></span></div>
							</div>
							<div class="form-group row">
								<label for="" class="col-sm-2 col-form-label"><?= lang('orderno') ?></label>
								<div class="col-sm-10"><span><?= isset($item) ? $item->order_no : '12345678' ?></span></div>
							</div>
							<div class="form-group row">
								<label for="" class="col-sm-2 col-form-label"><?= lang('paymenttype') ?></label>
								<div class="col-sm-10"><span><?= isset($item) ? $item->paymenttype : 'PayPal' ?></span></div>
							</div>
							<div class="form-group row">
								<label for="" class="col-sm-2 col-form-label"><?= lang('finish') . lang('status') ?></label>
								<div class="col-sm-10"><span><?= isset($item) ? $item->progress : '' ?></span></div>
							</div>
						</div>

					</div>
					<div class="coursecolumn">
						<div class="titlebar">
							<?= lang('student') . lang('profile') ?>
						</div>
						<div class="coursecontent">
							<div class="form-group row">
								<label for="" class="col-sm-3 col-form-label"><?= lang('studentfirstname') ?></label>
								<div class="col-sm-9"><span><?= isset($item) ? $item->chi_firstname : '' ?></span></div>
							</div>
							<div class="form-group row">
								<label for="" class="col-sm-3 col-form-label"><?= lang('studentlastname') ?></label>
								<div class="col-sm-9"><span><?= isset($item) ? $item->chi_lastname : '12345678' ?></span></div>
							</div>
							<div class="form-group row">
								<label for="" class="col-sm-3 col-form-label"><?= lang('telno') ?></label>
								<div class="col-sm-9"><span><?= isset($item) ? $item->mobile : 'PayPal' ?></span></div>
							</div>
							<div class="form-group row">
								<label for="" class="col-sm-3 col-form-label"><?= lang('email') ?></label>
								<div class="col-sm-9"><span><a
												href="mailto:<?= isset($item) ? $item->email : '' ?>"><?= isset($item) ? $item->email : '' ?></a></span>
								</div>
							</div>
						</div>

					</div>
				</div>
						<div class="titlebar">
							<?= lang('order') . lang('summary') ?>
						</div>

				<div class="form-container">
					<table id="coursetbl">
						<thead>
						<tr>
							<th><?= lang('coursename') ?></th>
							<th><?= lang('unitprice') ?>(HKD)</th>
							<th><?= lang('finish') . lang('status') ?>%</th>
						</tr>
						</thead>
						<tbody>
						<?php $total=0; foreach ($courses as $course): ?>
							<tr>
								<td><?= $course['name'] ?></td>
								<td><?= money($course['price']) ?></td>
								<td><?= ($course['progress'])*100 ?></td>
							</tr>
						<?php $total+=$course['price']; endforeach; ?>
						</tbody>
						<tfoot>
							<tr><td><?=lang('totalamount')?></td><td><?=money($total)?></td></tr>
						</tfoot>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function () {

	});
</script>
<?php include dirname(__FILE__) . '/../include/footer.php'; ?>

