<!-- header starts -->
<?php include dirname(__FILE__) . '/../include/header.php'; ?>
<!-- header ends -->
<!-- main content starts -->
<div class="main-container container-fluid main-admincontent"
	 data-dir="<?= dirname(__FILE__) . '/../include/header.php' ?>">
	<!-- Page Container -->
	<div class="page-container">
		<!-- Page Sidebar -->
		<?php include dirname(__FILE__) . '/../include/sidebar.php'; ?>
		<!-- /Page Sidebar -->

		<!-- Page Content -->
		<div class="page-content">
			<!-- Page Breadcrumb -->
			<div class="page-breadcrumbs">
				<ul class="breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="#"><?= lang('home') ?></a>
					</li>
					<li><a href="/admin/dashboard"><?= lang('dashboard') ?></a></li>
					<li><a href="/admin/coursemanagement"><?= lang('coursemanagement') ?></a></li>
					<li><?= lang('editcourse') ?></li>
				</ul>
			</div>
			<!-- /Page Breadcrumb -->
			<!-- Page Header -->
			<div class="page-header position-relative">
				<div class="header-title">
					<h1>
						<?= lang('editcourse') ?>
					</h1>
				</div>
				<!--Header Buttons-->
				<div class="header-buttons">
					<a class="sidebar-toggler" href="#">
						<i class="fa fa-arrows-h"></i>
					</a>
					<a class="refresh" id="refresh-toggler" href="#">
						<i class="glyphicon glyphicon-refresh"></i>
					</a>
					<a class="fullscreen" id="fullscreen-toggler" href="#">
						<i class="glyphicon glyphicon-fullscreen"></i>
					</a>
				</div>
				<!--Header Buttons End-->
			</div>
			<!-- /Page Header -->
			<!-- Page Body -->
			<div class="page-body">
				<?php if (isset($item)): ?>
					<div class="titlebar"><span><?= $item['name'] ?></span>
						<ul class="controls">
							<li><i class="fa fa-plus"></i><span id="btnAddUnit"><?= lang('addunit') ?></span></li>
							<li><i class="fa fa-trash"></i><span id="btnDelUnit"><?= lang('deleteunit') ?></span></li>
						</ul>

					</div>

					<div class="form-container">
						<form id="phpform" class="form-inline" role="form" method="post"
							  action="/admin/coursemanagement/save">
							<div class="row">
								<label for="name">課程名稱</label>
								<input id=name type="text" class="form-control mas-input" name="name"
									   placeholder="--- 輸入課程名稱 ---" value="<?= $item['name'] ?>"/>
								<label for="duration">課程總時間</label><input id=duration type="text"
																		  class="form-control mas-input"
																		  name="duration" placeholder="--- 輸入課程總時間 ---"
																		  value="<?= $item['duration'] ?>"/>

<!--								<label for="price">課程收費</label>-->
<!---->
<!--								<input id=price type="number" class="form-control mas-input"-->
<!--									   name="price" placeholder="--- 輸入課程收費 ---"-->
<!--									   value="--><?//= $item['price'] ?><!--"/>-->
							</div>
							<div class="row">
								<label for="introduction">課程簡述</label>
								<textarea id="introduction" class="form-control mas-textarea" cols="69" rows="3"
										  name="introduction"
										  placeholder="--- 輸入課程簡述 ---"><?= $item['introduction'] ?></textarea>
								<label for="description">課程詳細</label>
								<textarea id="description" class="form-control mas-textarea" cols="68" rows="3"
										  name="description"
										  placeholder="--- 輸入課程詳細 ---"><?= $item['description'] ?></textarea>

								<a id="btnSubmit" class="btn btn-footer"
								   href="javascript:void(0);"><?= lang('btnconfirm') ?></a>
								<input type="hidden" id="course_id" name="course_id" value="<?= $item['id'] ?>">
							</div>
						</form>
					</div>
				<?php endif; ?>
				<div class="row">
					<table id="myTable" class="display table dataTable datatables" cellspacing="0" width="100%"
						   data-url="<?= base_url('api/unit/getunitvideo?course_id=') ?>"
						   data-pagesize="<?= isset($settings)? findsettingByKey($settings, 'pagesize'):5 ?>"
						   data-del="<?= lang('confirmdelete') ?>" data-delitemreq="<?= lang('delitemrequired') ?>"
						   data-vpath="<?= base_url('assets/uploads/video/') ?>" data-play="<?= lang('playvideo') ?>"
						   data-pause="<?= lang('pausevideo') ?>">
						<thead>
						<tr>
							<th>編號</th>
							<th style="padding-left:.5em;">章</th>
							<th style="padding-left:1em;">名稱</th>
							<th>關聯影片檔案</th>
							<th>長度(分鐘)</th>
							<th class="control-delete sorting-disabled text-left" style="padding-left:0;">刪除</th>
						</tr>
						</thead>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	var ids = [];
	var table, data = [];
	var checkall = false;

	function getRemoteData(remote_url, data, callback, callbackFail) {
		$.ajax({
//async: false,
//timeout: 30000, //最長等候回應時間
			type: "GET", //提交類型
			url: remote_url, //提交地址
			data: data, //提交內容
			dataType: 'json', //返回數據類型
			success: function (data) { //請求完成並成功
				if (data.success) {
					callback(data);
				} else {
					callbackFail();
				}
			},
			error: function (data) { //請求返回錯誤信息
				callbackFail();
			},
			beforeSend: function (XHR) { //请求開始前执行
			},
			complete: function (XHR, status) { //请求完成后最终执行
			}
		});
	}

	function getRemoteDataFail() {
		alert("發生錯誤");
	}

	$(document).ready(function () {
		let $tbl = $('#myTable');
		const url = $tbl.data('url') + $('#course_id').val();
		// console.log('url:'+url);
		const pagesize = $tbl.data('pagesize');
		table = $tbl.DataTable({
			"processing": true,
			"serverSide": true,
			"ajax": url,
			"columns": [
				{"data": "id"},
				{"data": "unit_num", "name": "章"},
				{"data": "title", "name": "名稱"},
				{"data": "video", "name": "關聯影片檔案"},
				{"data": "duration", "name": "長度(分鐘)", "class": "control-details"},
				{"data": "delete", "name": "刪除", "class": "control-delete"},
			],
			"order": [
				[1, "asc"],
			],
			"columnDefs": [
				{
					"targets": [0],
					"visible": false,
					"searchable": false,
				},
				// {
				// 	"targets": [1, 2, 3, 4, 6],
				// 	"visible": true,
				// 	"searchable": true,
				// 	"orderable": true,
				// },
				// {
				// 	"targets": [5, 7],
				// 	"visible": true,
				// 	"searchable": false,
				// 	"orderable": true,
				// },
				{
					"targets": [3,4, 5],
					"visible": true,
					"searchable": false,
					"orderable": false,
				},
			],
			language: {
				"processing": "處理中...",
				"loadingRecords": "載入中...",
				"lengthMenu": "顯示數量 _MENU_ ",
				"zeroRecords": "沒有符合的結果",
				"info": "顯示 _START_-_END_（總數：_TOTAL_）",
				"infoEmpty": "0 項結果",
				"infoFiltered": "(從 _MAX_ 項結果中過濾)",
				"infoPostFix": "",
				"search": "搜尋:",
				"paginate": {
					"first": "首頁",
					"previous": "上一頁",
					"next": "下一頁",
					"last": "末頁"
				},
				"aria": {
					"sortAscending": ": 升冪排列",
					"sortDescending": ": 降冪排列"
				}
			},
			"pageLength": pagesize,
			"pagingType": "full_numbers",
			"drawCallback": function (settings) {
				$('#myTable_length').hide();
				$('#myTable_filter').hide();
				// $('#myTable_info').hide();
				// $('#myTable_paginate').hide();

				$.each(ids, function (k, v) {
					$('.checkbox-delete').each(function (i, e) {
						if (v === $(e).attr('id')) {
							$(e).prop('checked', true);
							return false;
						}
					});
				});
				$('i[id^="details-"]').on('click', function (event) {
					event.preventDefault();
					var newForm = $('<form>', {
						'action': '/admin/coursemanagement/edit',
						'method': 'post',
					}).append($('<input>', {
						'name': 'id',
						'value': this.id.replace('details-', ''),
						'type': 'hidden'
					}));
					$(document.body).append(newForm);
					newForm.submit();
				});
			},
		});
	});
	$(document).on('click', '#btnAddUnit', function () {
		window.location.href = '/admin/unitmanagement/add?course_id='+$('#course_id').val()+'&fromcourse=1';
	});
	$(document).on('click', '#btnDelUnit', function () {
		if(ids.length===0){
			$.fancybox.open($('#myTable').data('delitemreq'));
			return false;
		}
		if(confirm($('#myTable').data('del'))){
			// console.log('ids:',ids);
			// return;
			$.post( "/api/unit/deletebulk", { ids: ids })
					.done(function( data ) {
						window.location.reload(true);
					});
		}
	});
	$(document).on('click', '#btnSubmit', function () {
		if (validform()) {
			$('#phpform').submit();
		}
	});

	$(document).on('click', '.vlink', function () {
		const $tbl = $('#myTable');
		console.log('video:' + $tbl.data('vpath') + $(this).data('video'));
		let video = $tbl.data('vpath') + $(this).data('video');
		let html = '<div id="videoblock" class="page-body"><div class="form-container"><form id="phpform" class="form-horizontal" action="" method="post"><div class="form-group mas-col"><div class="col-sm-3 text-center mas-title"><label for="file"><span>' + $(this).text() + '</span></label></div><div class="col-sm-9 mas-box"><video id="myVideo" width="320" height="176"><source src="' + video + '"	type="video/mp4">Your browser does not support HTML5 video.</video></div></div></form></div></div>';
		$.fancybox.open(html);
	});

	$(document).on('change', '.checkbox-delete', function () {
		var id = $(this).attr('id');
		// console.log('id:'+id);
		if (this.checked && ids.indexOf(id) === -1) {
			ids.push(id);
		} else {
			var idx = ids.indexOf(id);
			if (idx > -1) {
				ids.splice(idx, 1);
			}
			checkall = false;
			$('.checkbox-delete-all').prop('checked', false);
		}
		if (ids.length > 0) {
			$.each(ids, function (i, e) {
				if (e === id) {
					$(this).prop('checked', true);
				}
			});
		}
		// console.log('ids#:',ids);
	});

	$(document).on('change', '.checkbox-delete-all', function () {
		if (this.checked) {
			getRemoteData(
					"/api/unit/getallids",
					{},
					getAllIdsOk,
					getRemoteDataFail
			);
		} else {
			ids = [];
		}
		$('.checkbox-delete').prop('checked', this.checked);
		checkall = this.checked;
	});

	function getAllIdsOk(Ids) {
		ids = Ids;
	}

	function validform() {
		var msg = '';
		if ($('#name').val() === '') {
			msg += "請輸入課程名稱<br>";
		}
		if ($('#duration').val() === '') {
			msg += "請輸入課程總時間<br>";
		}
		// if ($('#price').val() === '') {
		// 	msg += "請輸入課程收費<br>";
		// }
		if (msg !== '') {
			$.fancybox.open(msg);
		}
		return msg === '';
	}
</script>
<?php include dirname(__FILE__) . '/../include/footer.php'; ?>

