<?php

use app\libraries\CommonHelper;
use app\libraries\DateHelper;
use app\libraries\Tenants;

defined('BASEPATH') or exit('No direct script access allowed');

class Webinar_model extends MY_Model
{
	public $short = "w";
	public $table;
	public $tbl;
	//    public $database;
	public $filteredcount = 0;


	public function __construct()
	{
		parent::__construct();
		$this->tbl = 'webinar';
		$this->table = $this->tbl . ' ' . $this->short;
	}

	public function allforlist()
	{
		$fields = [$this->short . '.id', $this->short . '.name',$this->short.'.create_time'];
		return $this->getAll($this->database, $this->table, $fields, ['status'=>1]);
	}

	public function all($fields = [])
	{
		$_fields = empty($fields) ? [$this->short . '.id', $this->short . '.title'] : $fields;
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function allforfilter()
	{
		$_fields = [$this->short . '.id', $this->short . '.name'];
		$where = [$this->short . '.status' => 1];
		if ($this->database === 'main') {
			return $this->getAll($this->database, $this->table, $_fields, $where);
		} else {
			$data = array_merge($this->getAll($this->database, $this->table, $_fields, $where), $this->getAll('main', $this->table, $_fields, $where));
			return $data;
		}
	}

	public function listing_selection()
	{

		return $this->db->from('video')->get()->result_array();
	}

	public function get_html_by_token($token)
	{
		 $record = $this->db->from($this->tbl)
			->select('landing_page')
			->where('token', $token)
			->get()
			->row_array();
		 if (! $record) {
		 	return '';
		 }
		 return $record['landing_page'];
	}

	public function toggle_status($id)
	{
		$this->db->set('available', 'NOT `available`', false)
			->where('id', $id)
			->update($this->tbl, []);
		$record = $this->db->from($this->tbl)
			->select('available')
			->where('id', $id)
			->get()
			->row_array();
		if (! $record) {
			return null;
		}
		return $record['available'];
	}

	public function detail($id, $fields = [])
	{
		
		$result = $this->getOne($this->database, $this->tbl, ['*'], $id);
		$result['publish_date'] = date("Y-m-d", $result['publish_date']);
		$result['expiry_date'] = ($result['expiry_date'] == 0) ? '' : date("Y-m-d", $result['expiry_date']);
		for ($count = 1; $count <= 3; $count++) {
			$fld = 'time' . $count;
			$result[$fld] = date("H:i", strtotime($result[$fld]));
		}
		return $result;
	}

	public function webinar_detail($id)
	{
		$result = $this->detail($id);
		$result['num_of_applicants'] = $this->db->from('applicant')
			->where('webinar_id', $id)
			->count_all_results();
		return $result;
	}

	public function token_search($token)
	{
		return $this->db->from('webinar')
			->where('webinar_token', $token)
			->get()->row_array();
	}

	public function register($params)
	{
		$this->load->model('User_model', 'user');
		$user = $this->user->searchUser($params['email']);
		if (! $user) {
			$user_id = 0;
		}
		else {
			$user_id = $user['id'];
		}
		$this->load->model('Landing_model', 'landing');
		$landing = $this->landing->getLandingPage($params['landing']);
		$this->load->model('Applicant_model', 'applicant');
		$access_token = random_string(16);
		$data = [
			'user_id' => $user_id,
			'date' => $params['date'],
			'webinar_id' => $landing['webinar_id'],
			'access_token' => $access_token,
			'full_name' => $params['participant'],
			'email' => $params['email'],
			'location' => $params['location'],
		];
		$this->load->model('Webinar_model', 'webinar');
		$webinar = $this->webinar->detail($landing['webinar_id']);
		$applicant = $this->applicant->create($data);
		$this->load->model('Sendgrid_model', 'sendgrid');
		$message = '你已成功登記「' . $webinar['title'] . '」講座，時間為：' . $params['date'] . '，連結為：' . base_url() . 'webinar/start/' . $access_token;
			$this->sendgrid->sendmail(
			[
				'subject' => $this->config->item('site_settings')['company_name'] . ' 登記參加講座',
				'email' => $params['email'],
				'text_content' => $message,
				'html_content' => '<p>' . $message . '</p>',
			]
		);
		return $access_token;
	}

	public function create($params)
	{
	}

	public function update($params, $id)
	{
	}

	public function totalCount()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from($this->table_prefix . $this->table);
		return $db->count_all_results();
	}

	public function filteredCount($param)
	{
		$fields = [
			$this->short . '.id',
			$this->short . '.webinar_token',
			$this->short . '.speaker_id',
			$this->short . '.vimeo_id',
			$this->short . '.title',
			$this->short . '.sub_domain',
			$this->short . '.time1',
			$this->short . '.time2',
			$this->short . '.time3',
			$this->short . '.related_course_name',
			$this->short . '.course_id',
			$this->short . '.featured_image',
			$this->short . '.selling_price',
			$this->short . '.discounted_price',
			$this->short . '.available',
			$this->short . '.publish_date',
			$this->short . '.expiry_date',
			$this->short . '.create_time'
		];
		$start = $param['start'];
		$length = $param['length'];
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $this->table);
//		foreach ($joins as $joinTbl => $condition) {
//			$db->join($joinTbl, $condition);
//		}
		$search = [];
//		foreach ($param['columns'] as $column) {
//			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
//				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
//				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
//				$search[$searchfield] = $column['search']['value'];
//			}
//		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing($param)
	{
		$fields = [
			$this->short . '.id',
			$this->short . '.webinar_token',
			$this->short . '.speaker_id',
			$this->short . '.vimeo_id',
			$this->short . '.title',
			$this->short . '.sub_domain',
			$this->short . '.time1',
			$this->short . '.time2',
			$this->short . '.time3',
			$this->short . '.related_course_name',
			$this->short . '.course_id',
			$this->short . '.featured_image',
			$this->short . '.selling_price',
			$this->short . '.discounted_price',
			$this->short . '.available',
			$this->short . '.publish_date',
			$this->short . '.expiry_date',
			$this->short . '.create_time'
		];
		$orders = [];
//		foreach ($param['order'] as $order) {
//			$colIdx = $order['column'];
//			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
//			$dir = strtoupper($order['dir']);
//			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
//			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
//		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [
			'rbac_users ru' => 'ru.id = ' . $this->short . '.speaker_id',
		];
		$search = [];
		//        if (trim($searchVal) !== "") {
//		foreach ($param['columns'] as $column) {
//			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
//				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
//				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
//				$search[$searchfield] = $column['search']['value'];
//			}
//		}
//		$result = $this->getFromDBFilter($this->database, $this->table, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		$result = $this->getFromDBFilter($this->database, $this->table, $fields, $start, $length, $orders, $search, $joins);
		//        log_message('debug','count result:'.count($result));
		$data = [];
		foreach ($result as $row) {
			$data[] = [
				'id' => $row['id'],
				'title' => $row['title'],
				'sub_domain' => base_url() . 'webinar/' . $row['title'],
				'publish_date' => date("Y-m-d", $row['publish_date']),
				'expiry_date' => ($row['expiry_date'] == 0) ? '--' : date("Y-m-d", $row['expiry_date']),
				'available' => ($row['available'] == 1) ? '<i id="status-'.$row['id'].'" class="fas fa-pencil-alt"></i>' : '<i id="status-'.$row['id'].'" class="fas fa-pencil-alt denied-icon"></i>',
				'edit' => '<i id="edit-'.$row['id'].'" class="fa fa-edit"></i>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function insert($params)
	{
		$required_fields = ['webinar_name', 'sub_domain', 'publish_date', 'webinar_time1', 'webinar_time2', 'webinar_time3'];
		foreach ($required_fields as $field) {
			if (! array_key_exists($field, $params)) {
				return false;
			}
		}
		$data = [
			'webinar_token' => $this->random_string(16),
			'speaker_id' => $this->session->userdata('user_id'),
			'title' => $params['webinar_name'],
			'sub_domain' => $params['sub_domain'],
			'publish_date' => strtotime($params['publish_date']),
			'expiry_date' => (! array_key_exists('expiry_date', $params) || (trim($params['expiry_date']) === "")) ? 0 : strtotime($params['expiry_date']),
			'time1' => $params['webinar_time1'],
			'time2' => $params['webinar_time2'],
			'time3' => $params['webinar_time3'],
		];
		$this->insertDB($this->database, $this->tbl, $data);
		return true;
	}

	public function update_course($params)
	{
		$required_fields = ['id', 'course_name', 'course_price', 'discounted_price', 'related_course', 'upload'];
		foreach ($required_fields as $field) {
			if (! array_key_exists($field, $params)) {
				return false;
			}
		}
		$webinar = $this->detail($params['id']);
		if (! $webinar) {
			return false;
		}
		if (count($params['upload']) == 0) {
			$filename = '';
		}
		else {
			$tmp = explode('.', $params['upload']['name']);
			$filename = $webinar['webinar_token'] . '.' . end($tmp);
			move_uploaded_file($params['upload']['tmp_name'], FCPATH . 'assets/uploads/featured_photo/' . $filename);
		}
		$data = [
			'related_course_name' => $params['course_name'],
			'selling_price' => $params['course_price'],
			'discounted_price' => $params['discounted_price'],
			'course_id' => $params['related_course'],
			'featured_image' => $filename,
		];
		$this->saveDB($this->database, $this->tbl, $data, $params['id']);
		return true;
	}

	public function update_webinar($params)
	{
		$required_fields = ['id', 'webinar_name', 'webinar_video', 'sub_domain', 'publish_date', 'webinar_time1', 'webinar_time2', 'webinar_time3'];
		foreach ($required_fields as $field) {
			if (! array_key_exists($field, $params)) {
				return false;
			}
		}
		$data = [
			'title' => $params['webinar_name'],
			'vimeo_id' => $params['webinar_video'],
			'sub_domain' => $params['sub_domain'],
			'publish_date' => strtotime($params['publish_date']),
			'expiry_date' => (! array_key_exists('expiry_date', $params) || (trim($params['expiry_date']) === "")) ? 0 : strtotime($params['expiry_date']),
			'time1' => $params['webinar_time1'],
			'time2' => $params['webinar_time2'],
			'time3' => $params['webinar_time3'],
		];
		$this->saveDB($this->database, $this->tbl, $data, $params['id']);
		return true;
	}

	public function one($video_id)
	{
		$this->load->model("Unit_model");
		$fields = [

			$this->short . '.id',
			$this->short . '.name',
			$this->short . '.introduction',
			$this->short . '.description',
			$this->short . '.duration',
			$this->short . '.status',
		];
		return $this->getOne($this->database, $this->table, $fields, $video_id);
	}

	public function save($param, $id)
	{
		//        log_message('debug','code:'.$param['code'].';id:'.$id);
		$this->saveDB($this->database, $this->tbl, $param, $id);
	}

	public function delete($id){
		$this->saveDB($this->database,$this->tbl,['status'=>0],$id);
	}

	public function deleteMultiple($ids)
	{
		$this->deleteDB($this->database, $this->tbl, $ids, true);
	}

	public function deleteAll()
	{
		$this->deleteAllDB($this->database, $this->tbl);
	}

	public function getAllIds()
	{
		$ids = [];
		$all = $this->all();
		foreach ($all as $k => $v) {
			$ids[] = $v['id'];
		}
		return $ids;
	}

	public function teacher_calendar()
	{
		$this->load->model('Tenant_model');
		$this->load->model('Event_enrollment_item_model');

		$tenantNo = $this->getTenantNo();
		$tenantName = $this->Tenant_model->detail_no($tenantNo)['name'];

		$baseQuery = $this->Event_enrollment_item_model->activeQuery($tenantNo);

		if (!$baseQuery['has_record']) {
			return [];
		}

		$this->db = $this->load->database($tenantNo, true);
		$videos = $this->db
			->from($this->table_prefix . $this->tbl)
			->where('video.status', 1)
			->join('event_video', 'video.id = event_video.video_id')
			->join('event', 'event_video.event_id = event.id')
			->join('event_timeslot', 'event_video.event_id = event_timeslot.event_id')
			// show all timeslots
			->join('(' . $baseQuery['compiled_select'] . ') item', 'event_timeslot.id = item.event_timeslot_id', 'left')
			->join('room', 'event.room_id = room.id')
			->group_start()
			->group_start()
			->where('event_timeslot.holiday_skip IS NULL', null, false)
			->where('video.mode != "period"', null, false)
			->group_end()
			->or_where('video.mode = "period"', null, false)
			->group_end()
			->where_in('YEAR(FROM_UNIXTIME(event_timeslot.startdate))', $this->threeYearsInterval(), false)
			->select('
                room.name as room_name,
                video.code as video_code, 
                video.name, 
                video.id as video_id, 
                event_timeslot.event_id as event_id,
                event_timeslot.starttime,
                event_timeslot.endtime,
                item.*,
                item.id as item_id,
                event_timeslot.startdate as date,
                event_timeslot.id as event_timeslot_id
            ', false)
			->group_by('event_timeslot.id')
			->order_by('event_timeslot.id', 'asc')
			->get()
			->result_array();

//        log_message('debug', $this->db->last_query());

		$res = [];

		foreach ($videos as $item) {
			$timeslotId = $item['event_timeslot_id'];

			// $txnStatus = $item['txn_status'];
			// $date = Carbon::createFromTimestamp($item['date'])->timezone('Asia/Hong_Kong')->add(13, 'hour')->format('Y-m-d H:i:s');
			// 'Y-m-d\TH:i:s\Z'
			$date = date('Y-m-d H:i:s', $item['date']);
			$checkinDatetime = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : '';

			$date = explode(' ', $date)[0];
			// use date to generate app calendar compatible key
			$key = date('Y-m-d H:i:s', (new DateTime($date, new DateTimeZone('Asia/Hong_Kong')))->getTimestamp());
			// ZuluString
			$keys = explode(' ', $key);

			$calendarDatetime = sprintf('%sT%sZ', $keys[0], $keys[1]);
			$key = sprintf('%sT%sZ', $keys[0], '00:00:00');

			// EnrollmentItemId
			$itemId = $item['item_id'];
			$values = [
				'item_id' => $itemId,
				'room_name' => sprintf('%s %s', $tenantName, $item['room_name'] ?? ''),
				'video_id' => $item['video_id'],
				'video_code' => $item['video_code'] ?? '',
				'title' => $item['name'] ?? '',
				'student_id' => $item['student_id'],
				'timeslot_id' => $timeslotId,
				'date' => $date,
				'type' => '上課記錄',
				'time' => sprintf('%s - %s', $item['starttime'], $item['endtime']),
				'checkin' => $checkinDatetime,
				'teacher_comment' => '',
				'taken_leave_datetime' => $item['taken_leave_datetime'] ?? "",
				'absent' => $item['absent'] ? 1 : 0,
				'makeup' => $item['txn_status'] == 'M' ? 1 : 0,
				'calendar_datetime' => $calendarDatetime,
				'enrolled' => $item['txn_status'] != null ? 1 : 0,
				'quota' => 0
			];

			$this->array_put($res, $key, $values);
		}

		return $res;
	}

	public function listing_students($timeslotId)
	{
		$tenantNo = $this->getTenantNo();
		$this->load->model('Event_enrollment_item_model');

		$baseQuery = $this->Event_enrollment_item_model->activeQuery($tenantNo, true);

		if (!$baseQuery['has_record']) {
			return [];
		}

		$this->db = $this->load->database($tenantNo, true);
		$videos = $this->db
			->from('video')
			->where('video.status', 1)
			->join('event_video', 'video.id = event_video.video_id')
			->join('event_timeslot', 'event_video.event_id = event_timeslot.event_id')
			// show all timeslots
			->join('(' . $baseQuery['compiled_select'] . ') item', 'event_timeslot.id = item.event_timeslot_id')
			->join('student', 'item.student_id = student.id')
			->group_start()
			->group_start()
			->where('event_timeslot.holiday_skip IS NULL', null, false)
			->where('video.mode != "period"', null, false)
			->group_end()
			->or_where('video.mode = "period"', null, false)
			->group_end()
			->where('item.event_timeslot_id', $timeslotId)
			->where('item.id IN (' . $this->Event_enrollment_item_model->getLatestQueryOnTimeslot($timeslotId) . ')', null, false)
			->where_in('YEAR(FROM_UNIXTIME(event_timeslot.startdate))', $this->threeYearsInterval(), false)
			->select('
                video.name, 
                video.id as video_id, 
                event_timeslot.event_id as event_id,
                event_timeslot.starttime,
                event_timeslot.endtime,
                item.*,
                item.id as item_id,
                student.chi_name as student_name,
                event_timeslot.startdate as date,
                event_timeslot.id as event_timeslot_id
            ', false)
			->order_by('event_timeslot.id', 'asc')
			->get()
			->result_array();

//        log_message('debug', $this->db->last_query());

		$res = [];

		foreach ($videos as $item) {
			$timeslotId = $item['event_timeslot_id'];

			// $txnStatus = $item['txn_status'];
			// $date = Carbon::createFromTimestamp($item['date'])->timezone('Asia/Hong_Kong')->add(13, 'hour')->format('Y-m-d H:i:s');
			// 'Y-m-d\TH:i:s\Z'
			$date = date('Y-m-d H:i:s', $item['date']);
			$checkinDatetime = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : '';

			$date = explode(' ', $date)[0];
			// use date to generate app calendar compatible key
			$key = date('Y-m-d H:i:s', (new DateTime($date, new DateTimeZone('Asia/Hong_Kong')))->getTimestamp());
			// ZuluString
			$keys = explode(' ', $key);

			$calendarDatetime = sprintf('%sT%sZ', $keys[0], $keys[1]);
			$key = sprintf('%sT%sZ', $keys[0], '00:00:00');

			// EnrollmentItemId
			$itemId = $item['item_id'];
			$values = [
				'item_id' => $itemId,
				'video_id' => $item['video_id'],
				'student_id' => $item['student_id'],
				'student_name' => $item['student_name'],
				'timeslot_id' => $timeslotId,
				'date' => $date,
				'type' => '上課記錄',
				'time' => sprintf('%s - %s', $item['starttime'], $item['endtime']),
				'title' => $item['name'] ?? '',
				'checkin' => $checkinDatetime,
				'teacher_comment' => '',
				'taken_leave_datetime' => $item['taken_leave_datetime'] ?? "",
				'absent' => $item['absent'] ? 1 : 0,
				'makeup' => $item['txn_status'] == 'M' ? 1 : 0,
				'calendar_datetime' => $calendarDatetime,
				'enrolled' => $item['txn_status'] != null ? 1 : 0,
				'quota' => 0
			];

			if ($values['absent'] == 0 && $values['makeup'] == 0 && $values['taken_leave_datetime'] == '') {
				$values['in_datetime'] = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : "";
				$values['out_datetime'] = !empty($item['out_datetime']) ? date('H:i', $item['out_datetime']) : "";
			} else {
				$values['in_datetime'] = "";
				$values['out_datetime'] = "";
			}
			if ($values['makeup'] == 1) {
				$this->Event_enrollment_item_model->setTenantNo($tenantNo);
				$nextItem = $this->Event_enrollment_item_model->detail_in_nextTimeslot($item['next_txn_id']);
				$values['makeup_date'] = date('Y-m-d', $nextItem['startdate']);
			} else {
				$values['makeup_date'] = "";
			}

			if ($values['absent'] == 0 && $values['makeup'] == 0 && $values['taken_leave_datetime'] == '' && $values['in_datetime'] == '' && $values['out_datetime'] == '') {
				$values['not_processed'] = 1;
			} else {
				$values['not_processed'] = 0;
			}
			$this->array_put($res, $key, $values);
		}

		return $res;
	}

	private function threeYearsInterval()
	{
		$currentYear = date('Y');
		$_currentYear = (int)$currentYear;
		$previousYear = $_currentYear - 1;
		$nextYear = $_currentYear + 1;

		return compact('currentYear', 'previousYear', 'nextYear');
	}

}
