<?php

use app\libraries\CommonHelper;
use app\libraries\DateHelper;
use app\libraries\Tenants;
use Mpdf\Tag\Q;

defined('BASEPATH') or exit('No direct script access allowed');

class User_model extends MY_Model
{
	public $short = "u";
	public $tbl;
	//    public $database;
	public $filteredcount = 0;

	public function __construct()
	{
		parent::__construct();
		$this->tbl = 'rbac_users';
		$this->table = $this->tbl . ' ' . $this->short;
	}

	public function allforlist()
	{
		$fields = [$this->short . '.id', $this->short . '.name', $this->short . '.introduction', $this->short . '.update_time'];
		return $this->getAll($this->database, $this->table, $fields, ['status' => 1]);
	}

	public function all($fields = [])
	{
		$_fields = empty($fields) ? [$this->short . '.id', $this->short . '.name'] : $fields;
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function allforfilter()
	{
		$_fields = [$this->short . '.id', $this->short . '.name'];
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function listing_selection()
	{
		return $this->db->from('mas_rbac_users')->get()->result_array();
	}

	public function detail($id, $fields = [])
	{

		return $this->getOne($this->database, $this->tbl, $fields, $id);
	}

	public function create($params)
	{
		$password = $this->random_string(8);
//		$password = '123456';
		$data = [
			'password' => md5($password),
			'display_name' => $params['full_name'],
			'email' => $params['email'],
			'created_by' => 0,
		];
		$this->db->set('create_time', 'UNIX_TIMESTAMP()', false);
		$this->db->insert($this->tbl, $data);
		$user_id = $this->db->insert_id();
		$data = [
			'user_id' => $user_id,
			'role_id' => 5,
			'created_by' => 0,
		];
		$this->db->set('create_time', 'UNIX_TIMESTAMP()', false);
		$this->db->insert('rbac_users_roles', $data);
		$this->load->model('Sendgrid_model', 'sendgrid');
		$this->sendgrid->sendmail(
			[
				'subject' => $this->config->item('site_settings')['company_name'] . ' 建立新用戶',
				'email' => $params['email'],
				'text_content' => '感謝你使用本系統，你的暫時密碼為：' . $password,
				'html_content' => '<p>感謝你使用本系統，你的暫時密碼為：' . $password . '</p>',
			]
		);
		return $user_id;
	}

	public function forget_password($email)
	{
		$user = $this->searchUser($email);
		if (! $user) {
			return false;
		}
		$password = $this->random_string(8);
		$this->db->update($this->tbl, ['password' => md5($password)], ['id' => $user['id']]);
		$this->load->model('Sendgrid_model', 'sendgrid');
		$this->sendgrid->sendmail(
			[
				'subject' => $this->config->item('site_settings')['company_name'] . ' 忘記密碼',
				'email' => $email,
				'text_content' => '感謝你使用本系統，你的暫時密碼為：' . $password,
				'html_content' => '<p>感謝你使用本系統，你的暫時密碼為：' . $password . '</p>',
			]
		);
		return true;
	}

	public function update($params, $id)
	{
	}

	public function totalCount()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from($this->table_prefix . $this->table);
		$db->where(['status' => 1]);
		return $db->count_all_results();
	}

	public function filteredCount($param)
	{
		$this->load->model('Rbac_user_role_model');
		$this->load->model('Rbac_role_model');
		$ur = $this->Rbac_user_role_model->short;
		$r = $this->Rbac_role_model->short;
		$fields = [$this->short . '.id', $this->short . '.username', $this->short . '.display_name', $r . '.name as role', '(select max(s.entered) from session_admin s where s.user_id=' . $this->short . '.id) as lastlogin'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$joins = [];
		$joins[$this->Rbac_user_role_model->table] = $this->short . '.id=' . $ur . '.user_id';
		$joins[$this->Rbac_role_model->table] = $ur . '.role_id=' . $r . '.id';
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $this->table);
		$db->where([$this->short . '.status' => 1]);
		foreach ($joins as $joinTbl => $condition) {
			$db->join($joinTbl, $condition);
		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing($param)
	{
		$this->load->model('Rbac_user_role_model');
		$this->load->model('Rbac_role_model');
		$ur = $this->Rbac_user_role_model->short;
		$r = $this->Rbac_role_model->short;
		$fields = [$this->short . '.id', $this->short . '.email', $this->short . '.chi_firstname', $this->short . '.chi_lastname', $r . '.name as role', '(select max(s.entered) from session_admin s where s.user_id=' . $this->short . '.id) as lastlogin'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$joins[$this->Rbac_user_role_model->table] = $this->short . '.id=' . $ur . '.user_id';
		$joins[$this->Rbac_role_model->table] = $ur . '.role_id=' . $r . '.id';
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter($this->database, $this->table, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		// SELECT main.id,main.username,main.display_name,r.name as role,(select max(s.entered) from session_admin s where s.user_id=main.id) as lastlogin
		$data = [];
		foreach ($result as $row) {
			$data[] = [
				'id' => $row['id'],
				'email' => '<a href="mailto:'. $row['email'].'">'.$row['email'].'</a>',
				'displayname' => $row['chi_lastname'] . $row['chi_firstname'],
				'role' => $row['role'],
				'lastlogin' => empty($row['lastlogin']) ? '---' : $row['lastlogin'],
				'details' => '<i id="details-' . $row['id'] . '" class="fa fa-edit"></i>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function listing_student($param)
	{
		$this->load->model('Rbac_user_role_model');
		$this->load->model('Rbac_role_model');
		$ur = $this->Rbac_user_role_model->short;
		$r = $this->Rbac_role_model->short;
		$fields = [$this->short . '.id', $this->short . '.email', $this->short . '.chi_firstname', $this->short . '.chi_lastname', $r . '.name as role', '(select max(s.entered) from session_admin s where s.user_id=' . $this->short . '.id) as lastlogin', $this->short . '.mobile'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$joins[$this->Rbac_user_role_model->table] = $this->short . '.id=' . $ur . '.user_id';
		$joins[$this->Rbac_role_model->table] = $ur . '.role_id=' . $r . '.id';
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter_student($this->database, $this->table, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		// SELECT main.id,main.username,main.display_name,r.name as role,(select max(s.entered) from session_admin s where s.user_id=main.id) as lastlogin
		$data = [];
		foreach ($result as $row) {
			$data[] = [
				'id' => $row['id'],
				'email' => '<a href="mailto:'. $row['email'].'">'.$row['email'].'</a>',
				'chi_lastname' => $row['chi_lastname'],
				'chi_firstname' => $row['chi_firstname'],
				'mobile' => $row['mobile'],
				'lastlogin' => empty($row['lastlogin']) ? '---' : $row['lastlogin'],
				'details' => '<i id="details-' . $row['id'] . '" class="fa fa-edit"></i>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function filteredCount_student($param)
	{
		$this->load->model('Rbac_user_role_model');
		$this->load->model('Rbac_role_model');
		$ur = $this->Rbac_user_role_model->short;
		$r = $this->Rbac_role_model->short;
		$fields = [$this->short . '.id', $this->short . '.username', $this->short . '.display_name', $r . '.name as role', '(select max(s.entered) from session_admin s where s.user_id=' . $this->short . '.id) as lastlogin'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$joins = [];
		$joins[$this->Rbac_user_role_model->table] = $this->short . '.id=' . $ur . '.user_id';
		$joins[$this->Rbac_role_model->table] = $ur . '.role_id=' . $r . '.id';
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $this->table);
		$db->where([$this->short . '.status' => 1, $ur . '.role_id' => 5]);
		foreach ($joins as $joinTbl => $condition) {
			$db->join($joinTbl, $condition);
		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function totalCount_student()
	{
		$this->load->model('Rbac_user_role_model');
		$this->load->model('Rbac_role_model');
		$ur = $this->Rbac_user_role_model->short;
		$r = $this->Rbac_role_model->short;
		$fields = [$this->short . '.id', $this->short . '.username', $this->short . '.display_name', $r . '.name as role', '(select max(s.entered) from session_admin s where s.user_id=' . $this->short . '.id) as lastlogin'];
		$joins = [];
		$joins[$this->Rbac_user_role_model->table] = $this->short . '.id=' . $ur . '.user_id';
		$joins[$this->Rbac_role_model->table] = $ur . '.role_id=' . $r . '.id';
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $this->table);
		$db->where([$this->short . '.status' => 1, $ur . '.role_id' => 5]);
		foreach ($joins as $joinTbl => $condition) {
			$db->join($joinTbl, $condition);
		}
		return $db->count_all_results();
	}

	public function getFromDBFilter_student($database, $table, $fields, $start, $length, $orders, $search, $joins = [], $keywordfieldname = '')
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		$db->distinct();
		$db->select(implode(', ', $fields));
		$db->where([$this->short . '.status' => 1, 'ur.role_id' => 5]);
		$db->from($this->table_prefix . $table);

		if (count($joins) > 0) {
			foreach ($joins as $joinTbl => $condition) {
				$db->join($joinTbl, $condition);
			}
		}

		if (!empty($search) && !empty($keywordfieldname)) {
			//            log_message('debug','here');
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === $keywordfieldname) {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}

		$db->order_by(implode(', ', $orders));
		if ($start > -1) {
			$db->limit($length, $start);
		}
		return $db->get()->result_array();
	}

	public function insert($param)
	{
		return $this->insertDB($this->database, $this->tbl, $param);
	}

	public function saveuserasrole($id, $role = '5')
	{
		return $this->insertDB($this->database, 'rbac_users_roles', ['user_id' => $id, 'role_id' => $role]);
	}

	public function one($rbac_users_id)
	{
		$this->load->model("Unit_model");
		$fields = [

			$this->short . '.id',
			$this->short . '.name',
			$this->short . '.introduction',
			$this->short . '.description',
			$this->short . '.duration',
			$this->short . '.status',
		];
		return $this->getOne($this->database, $this->table, $fields, $rbac_users_id);
	}

	public function save($param, $id)
	{
		//        log_message('debug','code:'.$param['code'].';id:'.$id);
		$this->saveDB($this->database, $this->tbl, $param, $id);
	}

	public function delete($id)
	{
		$this->saveDB($this->database, $this->tbl, ['status' => 0], $id);
	}


	public function deleteMultiple($ids)
	{
		$this->deleteDB($this->database, $this->tbl, $ids, true);
	}

	public function deleteAll()
	{
		$this->deleteAllDB($this->database, $this->tbl);
	}

	public function getAllIds()
	{
		$ids = [];
		$all = $this->all();
		foreach ($all as $k => $v) {
			$ids[] = $v['id'];
		}
		return $ids;
	}

	private function threeYearsInterval()
	{
		$currentYear = date('Y');
		$_currentYear = (int)$currentYear;
		$previousYear = $_currentYear - 1;
		$nextYear = $_currentYear + 1;

		return compact('currentYear', 'previousYear', 'nextYear');
	}

	public function validation($email, $password)
	{
		$this->db->select('email,password,display_name,id');
		$this->db->from('rbac_users');
		$dbWhere = array('email' => $email, 'password' => md5($password));
		$this->db->where($dbWhere);
		$query = $this->db->get();


		if ($query->num_rows()) {
			$result = $query->row_array();
			$this->load->model('Security', 'security_model');
			$this->security_model->admin_insert([
				'session_id' => $this->security_model->getcode(),
				'user_id' => $result['id'],
				'ipaddress' => $_SERVER['REMOTE_ADDR'],
				'entered' => date("Y-m-d H:i:s"),
			]);
			$this->session->set_userdata('user_info', $result);
			return true;
		} else {
			return false;
		}
	}

	public function getUser()
	{

		$this->db->select('id,chi_firstname,chi_lastname,email,mobile');
		$this->db->from('rbac_users');
		$user_info_ID = $this->session->userdata("user_info");
		$dbWhere = array('id' => $user_info_ID["id"]);
		$this->db->where($dbWhere);


		$getQueryIndex = $this->db->get()->row_array();


		return $getQueryIndex;
	}
	public function editAccountInformation($params)
	{
		$required = ['firstname', 'lastname', 'email', 'phone'];
		foreach ($required as $field) {
			if (array_key_exists($field, $params)) {
				if (trim($params[$field]) === "") {
					return false;
				}
			}
			else {
				// no such field
			}
		}
		if (! array_key_exists('firstname', $params)) {
			$params['firstname'] = '';
		}

		if (! is_numeric($params['phone'])) {
			return false;
		}

		$accountInfo = [
			"chi_firstname" => $params['firstname'],
			"chi_lastname" => $params['lastname'],
			"email" => $params['email'],
			"mobile" => $params['phone'],
			"display_name"=> $params['firstname'] . ' ' . $params['lastname'],
		];

		if (array_key_exists('password', $params)) {
			$accountInfo['password'] = md5($params['password']);
		}

		$this->db->where('id',$this->session->userdata('user_info')['id']);
		
		$this->db->update('rbac_users', $accountInfo);
		return true;
		
	}

	public function getusercountfordashboard(){
		/*
		 * SELECT count(u.id) as usercount
,from_unixtime(min(u.create_time),'%Y-%m-%d') as fromdate
,from_unixtime(max(u.create_time),'%Y-%m-%d') as todate

FROM `rbac_users` u
join rbac_users_roles ur on u.id=ur.user_id
join rbac_roles r on ur.role_id = r.id

WHERE u.status=1 and r.name = 'Student'
		 */
		$fields = ['count(u.id) as usercount','from_unixtime(min(u.create_time),\'%Y-%m-%d\') as fromdate','from_unixtime(max(u.create_time),\'%Y-%m-%d\') as todate'];
		$this->db->join('rbac_users_roles ur','u.id=ur.user_id');
		$this->db->join('rbac_roles r','ur.role_id=r.id');
		$this->db->where(['u.status'=>1,'r.name'=>'Student']);
		$this->db->from('rbac_users u');
		$this->db->select(implode(',',$fields));
		$data = $this->db->get()->row_array();
//		log_message('debug','sql:'.$this->db->last_query());
		return $data;
	}

	public function searchUser ($email)
	{
		return $this->getOneRow($this->database, $this->tbl, [], ['email' => $email]);
	}
}
