<?php

use app\libraries\CommonHelper;
use app\libraries\DateHelper;
use app\libraries\Tenants;

defined('BASEPATH') or exit('No direct script access allowed');

class Unit_model extends MY_Model
{
	public $short = "u";
	public $table;
	public $tbl;
	//    public $database;
	public $filteredcount = 0;

	public function __construct()
	{
		parent::__construct();
		$this->tbl = 'unit';
		$this->table = $this->tbl . ' ' . $this->short;
	}

	public function allforlist()
	{
		$fields = [$this->short . '.id', $this->short . '.title', $this->short . '.update_time'];
		return $this->getAll($this->database, $this->table, $fields, ['status' => 1]);
	}

	public function all($fields = [])
	{
		$_fields = empty($fields) ? [$this->short . '.id', $this->short . '.title'] : $fields;
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function allforfilter()
	{
		$_fields = [$this->short . '.id', $this->short . '.title'];
		$where = [$this->short . '.status' => 1];
		if ($this->database === 'main') {
			return $this->getAll($this->database, $this->table, $_fields, $where);
		} else {
			$data = array_merge($this->getAll($this->database, $this->table, $_fields, $where), $this->getAll('main', $this->table, $_fields, $where));
			return $data;
		}
	}

	public function listing_selection()
	{


		return $this->db->from('mas_unit')->get()->result_array();
	}

	public function detail($id, $fields = [])
	{

		return $this->getOne($this->database, $this->tbl, $fields, $id);
	}

	public function isRegular($mode)
	{
		return in_array($mode, ['month', 'lesson']);
	}

	public function fullTitle($name, $weekdays)
	{
		if (!empty($weekdays)) {
			$tcWeekdays = [];

			$default = DateHelper::getDefaultTcWeekdays();
			if (!empty($weekdays)) {
				foreach (explode('/', $weekdays) as $weekdayIndex) {
					array_push($tcWeekdays, $default[$weekdayIndex]);
				}
				return sprintf('%s (%s)', $name, implode('/', $tcWeekdays));
			} else {
				return sprintf('%s', $name);
			}
		} else {
			return $name;
		}
	}

	public function create($params)
	{
	}

	public function update($params, $id)
	{
	}

	public function totalCount()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from($this->table_prefix . $this->table);
		return $db->count_all_results();
	}

	public function filteredCount($param)
	{
		$fields = [$this->short . '.id', $this->short . '.status', $this->short . '.title', $this->short . '.update_time'];
		$start = $param['start'];
		$length = $param['length'];
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $this->table);
//		foreach ($joins as $joinTbl => $condition) {
//			$db->join($joinTbl, $condition);
//		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing($param)
	{
		$fields = [$this->short . '.id', $this->short . '.status',$this->short . '.unit_num', $this->short . '.title', $this->short . '.update_time'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter($this->database, $this->table, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		//        log_message('debug','count result:'.count($result));
		$data = [];
		foreach ($result as $row) {
			$data[] = [
				'id' => $row['id'],
				'unit_num' => $row['unit_num'],
				'title' => $row['title'],
				'update_time' => formatdatetime($row['update_time']),
				'details'=>'<i id="details-'.$row['id'].'" class="fa fa-edit"></i>',
				'status' => is_null($row['status']) ? '' : $this->status[$row['status']],
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function insert($param)
	{
		$this->insertDB($this->database, $this->tbl, $param);
	}

	public function one($unit_id)
	{
		$this->load->model("Unit_model");
		$fields = [

			$this->short . '.id',
			$this->short . '.title',
			$this->short . '.introduction',
			$this->short . '.description',
			$this->short . '.duration',
			$this->short . '.status',
		];
		return $this->getOne($this->database, $this->table, $fields, $unit_id);
	}

	public function save($param, $id)
	{
		//        log_message('debug','code:'.$param['code'].';id:'.$id);
		$this->saveDB($this->database, $this->tbl, $param, $id);
	}

	public function delete($id)
	{
		$this->saveDB($this->database, $this->tbl, ['status' => 0], $id);
	}

	public function deleteMultiple($ids)
	{
		$this->deleteDB($this->database, $this->tbl, $ids, true);
	}

	public function deleteAll()
	{
		$this->deleteAllDB($this->database, $this->tbl);
	}

	public function getAllIds()
	{
		$ids = [];
		$all = $this->all();
		foreach ($all as $k => $v) {
			$ids[] = $v['id'];
		}
		return $ids;
	}



	private function threeYearsInterval()
	{
		$currentYear = date('Y');
		$_currentYear = (int)$currentYear;
		$previousYear = $_currentYear - 1;
		$nextYear = $_currentYear + 1;

		return compact('currentYear', 'previousYear', 'nextYear');
	}

	public function getbycourse($course_id)
	{
		return $this->getAll($this->database, $this->tbl, [], ['course_id' => $course_id]);
	}

	public function getcourseByUnit($unit_id)
	{
		$unit = $this->detail($unit_id);
		$this->load->model('Course_Model', 'course_model');
		return $this->course_model->detail($unit['course_id']);
	}

	public function listing_unitvideo($param)
	{
		$this->load->model('Video_Model','video_model');
		$vs = $this->video_model->short;
		$vtable = $this->video_model->table;
		$fields = [$this->short.'.title',$this->short.'.unit_num', $this->short.'.id', $vs.'.name', $vs.'.filename', $vs.'.duration', $vs.'.create_time', $vs.'.update_time'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$joins[$vtable]=$this->short.'.id='.$vs.'.unit_id';
//		print_r($joins);
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter($this->database, $this->table, $fields, $start, $length, $orders, $search, $joins,'',$param['course_id']);
		/*
		 * SELECT u.`title`,u.`unit_num`, main.`id`, `name`, `filename`, `duration`, main.`create_time`, main.`update_time`
FROM `video` main
join `unit` u on main.unit_id = u.id
WHERE main.status=1
		 */
		$data = [];
		foreach ($result as $row) {
			$data[] = [
				'id' => $row['id'],
				'unit_num'=>$row['unit_num'],
				'title' => $row['title'],
				'name'=>$row['name'],
				'video'=>empty($row['filename'])?'---':"<a class='vlink' data-video='".$row['filename']."' href='#'>".$row['name']."</a>",
				'duration' =>empty($row['duration'])?'---': $row['duration'],
				'create_time' => formatdatetime($row['create_time']),
				'details' => '<i id="details-' . $row['id'] . '"></i>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}
	public function filteredCount_unitvideo($param)
	{
		$this->load->model('Video_Model','video_model');
		$vs = $this->video_model->short;
		$vtable = $this->video_model->table;
		$fields = [$this->short.'.title',$this->short.'.unit_num', $vs.'.id', $vs.'.name', $vs.'.filename', $vs.'.duration', $vs.'.create_time', $vs.'.update_time'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$joins = [];
		$joins[$vtable]=$this->short.'.id='.$vs.'.unit_id';
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table);
		if (count($joins) > 0) {
			foreach ($joins as $joinTbl => $condition) {
				$db->join($joinTbl, $condition,'left');
			}
		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		$db->where([$this->short.'.status'=>1,$this->short.'.course_id'=>$param['course_id']]);
		return count($db->get()->result_array());
	}
	public function totalCount_unitvideo($param)
	{
		$this->load->model('Video_Model','video_model');
		$vs = $this->video_model->short;
		$vtable = $this->video_model->table;
		$fields = [$this->short.'.title',$this->short.'.unit_num', $vs.'.id', $vs.'.name', $vs.'.filename', $vs.'.duration', $vs.'.create_time', $vs.'.update_time'];
		$joins = [];
		$joins[$vtable]=$this->short.'.id='.$vs.'.unit_id';
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table);
		if (count($joins) > 0) {
			foreach ($joins as $joinTbl => $condition) {
				$db->join($joinTbl, $condition,'left');
			}
		}
		$db->where([$this->short.'.status'=>1,$this->short.'.course_id'=>$param['course_id']]);
		return $db->count_all_results();
	}

	//override
	public function getFromDBFilter($database, $table, $fields, $start, $length, $orders, $search, $joins = [], $keywordfieldname = '',$course_id=0)
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		$db->distinct();
		$db->select(implode(', ', $fields));
		if($course_id>0){
			$db->where([$this->short.'.status'=>1,$this->short.'.course_id'=>$course_id]);
		}else{
			$db->where([$this->short.'.status'=>1]);
		}

		$db->from($this->table_prefix . $table);

		if (count($joins) > 0) {
			foreach ($joins as $joinTbl => $condition) {
				$db->join($joinTbl, $condition,'left');
			}
		}

		if (!empty($search) && !empty($keywordfieldname)) {
			//            log_message('debug','here');
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === $keywordfieldname) {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}

		$db->order_by(implode(', ', $orders));
		if ($start > -1) {
			$db->limit($length, $start);
		}
		return $db->get()->result_array();
	}

	public function getUnitId($course_id, $unit_num)
	{
		return $this->getOneRow($this->database, $this->tbl, [], ['course_id' => $course_id, 'unit_num' => $unit_num]);
	}
}
