<?php

class Settings_Model extends CI_Model
{
	public $columns = array();
	public $_primary_keys = array('key');
	public $_table = "settings";

	function __set($name, $value)
	{
		$this->columns[$name] = $value;
	}

	function insert($arr)
	{
		$this->db->insert('settings', $arr);
		return $this->db->insert_id();
	}

	function update($id, $arr)
	{

		$this->db->where('id', $id);
		$this->db->update('settings', $arr);

	}

	function get()
	{
		$query = $this->db->get('settings');
		return $query->result();
	}

	function get_id($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('settings');
		return $query->result();
	}

	function get_lang($lang)
	{
//                $this->db->where('lang', $lang);
		$query = $lang === 'eng' ? $this->db->get('settings') : $this->db->get('settings_chi');
		return $query->result();
	}

	function delete($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('settings');
	}

	function save($lang)
	{
		$update = FALSE;
		if ($this->columns){
//			foreach($this->_primary_keys as $key){
//				log_message('debug','prikey:'.$key);
//			}
			$tbl = $lang === 'eng' ? $this->_table : 'settings_chi';
//			log_message('debug','tbl:'.$tbl);
			foreach ($this->columns as $key => $value) {
//				log_message('debug','key:'.$key.';value:'.$value);

				if (in_array($key, $this->_primary_keys)) {
					$update = TRUE;
//					$id = $value;
					$this->db->where($key, $value);
//					$this->db->update($tbl);
				} else{
					$this->db->set($key, $value);
//					$this->db->insert($tbl);
				}
			}
		}

//
		if ($update) {
			$this->db->update($tbl);
			return $this->columns[$this->_primary_keys[0]];
		} else {
//			log_message('debug','insert');
			$this->db->insert($tbl);
			return $this->db->insert_id();
		}
	}
}
