<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */

use app\libraries\Tenants;

class Rbac_permission_model extends CI_Model
{
    use Tenants;

    public function __construct()
    {
        parent::__construct();
    }

    public function get_role_permissions($roles)
    {
        $this->tenant();

        $this->db->select('id, name');
        $this->db->from('mas_menu');
        $this->db->where('status', 1);
        $result = $this->db->get()->result_array();
        $menus = [];
        $permission = [];
        foreach ($result as $menu) {
            $menus[$menu['id']] = $menu['name'];
            $permission[$menu['name']] = [];

            $actions = $this->config->item('available_actions');
            if ($actions)
                foreach ($actions as $action) {
                    $permission[$menu['name']][$action] = false;
                }
        }

        $this->db->select('p.menu_id, p.action');
        $this->db->from('rbac_permissions p');
        $this->db->join('rbac_roles_permissions rp', 'rp.permission_id = p.id', 'left');
        $this->db->where_in('rp.role_id', $roles);
        $this->db->where('rp.status', 1);
        $p_result = $this->db->get()->result_array();
        foreach ($p_result as $perm) {
            $controller = $menus[$perm['menu_id']];
            if (!$permission[$controller][$perm['action']]) {
                $permission[$controller][$perm['action']] = true;
            }
        }
        return $permission;
    }

    public function get_all_permissions()
    {
        $this->tenant();

        $this->db->select('p.id, p.menu_id, p.action, m.display_name, m.name');
        $this->db->from('rbac_permissions p');
        $this->db->join('mas_menu m', 'm.id = p.menu_id');
        $this->db->where('m.status', 1);
        if (isset($params) && !empty($params)) {
            $this->db->limit($params['limit'], $params['offset']);
        }
        $result = $this->db->get()->result_array();
        $permission = [];
        foreach ($result as $row) {
            if (!array_key_exists($row['menu_id'], $permission)) {
                $permission[$row['menu_id']] = [];
            }
            $permission[$row['menu_id']][$row['action']] = $row['id'];
        }
        return $permission;
    }

    public function get_all_permission_list($params = null)
    {
        $this->tenant();

        $this->db->select('p.id, p.menu_id, p.action, m.display_name, m.name');
        $this->db->from('rbac_permissions p');
        $this->db->join('mas_menu m', 'm.id = p.menu_id');
        $this->db->where('m.status', 1);
        if (isset($params) && !empty($params)) {
            $this->db->limit($params['limit'], $params['offset']);
        }
        return $this->db->get()->result_array();
    }

    public function check_permission($path, $action)
    {
        $this->tenant();

        if ($this->session->userdata('isAdmin') || $this->session->userdata('isSiteAdmin')) {
            return true;
        }
        if (!in_array($action, $this->config->item('available_actions'))) {
            return false;
        }
        $permissions = $this->session->userdata('rbac_permissions');
        if (!array_key_exists($path, $permissions)) {
            return false;
        }
        if (!$permissions[$path][$action]) {
            return false;
        }
        return true;
    }

    private function _exclude_roles()
    {
        return [];
    }

    public function get_all_permissions_count()
    {
        $this->tenant();

        $this->load->model('Menu_model');
        return $this->Menu_model->get_all_menus_count();
    }

    public function add_permission($param)
    {
        $this->tenant();

        $this->load->model('Menu_model');
        $menu_id = $this->Menu_model->add($param);
        $sql = [];
        foreach ($this->config->item('available_actions') as $action) {
            $sql[] = [
                'menu_id' => $menu_id,
                'action' => $action,
            ];
        }
        $this->db->insert_batch('rbac_permissions', $sql);
    }

    public function get_permission($id)
    {
        $this->tenant();
        $this->load->model('Menu_model');
        return $this->Menu_model->get($id);
    }

    public function update_permission($param, $id)
    {
        $this->tenant();

        $this->load->model('Menu_model');
        $this->Menu_model->update($param, $id);
        $data = [
            'status' => $param['status'],
        ];
        $this->db->set('updatedate', 'NOW()', false);
        $this->db->where('menu_id', $id);
        $this->db->update('rbac_permissions', $data);
    }

    public function build_permission()
    {
        $this->tenant();

        $this->load->model('Menu_model');
        $this->db->truncate('rbac_permissions');
        $menus = $this->Menu_model->get_all_menu_list();
        $sql = [];
        foreach ($menus as $menu) {
            foreach ($this->config->item('available_actions') as $action) {
                $sql[] = [
                    'menu_id' => $menu['id'],
                    'action' => $action
                ];
            }
        }
        //        $this->db->set('createdate', 'NOW()', false);
        $this->db->insert_batch('rbac_permissions', $sql);
    }

    // Check permission alternative methods
    public function readonly($path)
    {
        return !$this->can($path, 'add') && !$this->can($path, 'edit');
    }
    public function can($path, $action)
    {
        return $this->check_permission(strtolower($path), $action);
    }
}
