<?php

use app\libraries\CommonHelper;
use app\libraries\DateHelper;
use app\libraries\Tenants;

defined('BASEPATH') or exit('No direct script access allowed');

class Paymenttype_Model extends MY_Model
{
	public $short = "pt";
	public $table;
	public $tbl;
	//    public $database;
	public $filteredcount = 0;

	public function __construct()
	{
		parent::__construct();
		$this->tbl = 'payment_type';
		$this->table = $this->tbl . ' ' . $this->short;
	}

	public function allforlist()
	{
		$fields = [$this->short . '.id', $this->short . '.name', $this->short . '.introduction', $this->short . '.update_time'];
		return $this->getAll($this->database, $this->table, $fields, ['status' => 1]);
	}

	public function all($fields = [])
	{
		$_fields = empty($fields) ? [$this->short . '.id', $this->short . '.name'] : $fields;
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function allforfilter()
	{
		$_fields = [$this->short . '.id', $this->short . '.name'];
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function listing_selection()
	{


		return $this->db->from('mas_payment_type')->get()->result_array();
	}

	public function detail($id, $fields = [])
	{

		return $this->getOne($this->database, $this->tbl, $fields, $id);
	}

	public function isRegular($mode)
	{
		return in_array($mode, ['month', 'lesson']);
	}

	public function fullTitle($name, $weekdays)
	{
		if (!empty($weekdays)) {
			$tcWeekdays = [];

			$default = DateHelper::getDefaultTcWeekdays();
			if (!empty($weekdays)) {
				foreach (explode('/', $weekdays) as $weekdayIndex) {
					array_push($tcWeekdays, $default[$weekdayIndex]);
				}
				return sprintf('%s (%s)', $name, implode('/', $tcWeekdays));
			} else {
				return sprintf('%s', $name);
			}
		} else {
			return $name;
		}
	}

	public function create($params)
	{
	}

	public function update($params, $id)
	{
	}

	public function totalCount()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from($this->table_prefix . $this->table);
		$db->where(['status'=>1]);
		return $db->count_all_results();
	}

	public function filteredCount($param)
	{
		$fields = [$this->short . '.id', $this->short . '.introduction', $this->short . '.status', $this->short . '.name', $this->short . '.duration', $this->short . '.update_time'];
		$start = $param['start'];
		$length = $param['length'];
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $this->table);
		$db->where(['status'=>1]);
//		foreach ($joins as $joinTbl => $condition) {
//			$db->join($joinTbl, $condition);
//		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing($param)
	{
		$fields = [$this->short . '.id', $this->short . '.introduction', $this->short . '.status', $this->short . '.name', $this->short . '.duration', $this->short . '.update_time'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter($this->database, $this->table, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		//        log_message('debug','count result:'.count($result));
		$data = [];
		foreach ($result as $row) {
			$data[] = [
				'id' => $row['id'],
				'introduction' => $row['introduction'],
				'name' => $row['name'],
				'update_time' => formatdatetime($row['update_time']),
				'duration' => $row['duration'] . '分鐘',
//				'details' => '<button id="details-' . $row['id'] . '">詳情</button>',
				'details'=>'<i id="details-'.$row['id'].'" class="fa fa-edit"></i>',
				'status' => is_null($row['status']) ? '' : $this->status[$row['status']],
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function insert($param)
	{
		$this->insertDB($this->database, $this->tbl, $param);
	}

	public function one($payment_type_id)
	{
		$this->load->model("Unit_model");
		$fields = [

			$this->short . '.id',
			$this->short . '.name',
			$this->short . '.introduction',
			$this->short . '.description',
			$this->short . '.duration',
			$this->short . '.status',
		];
		return $this->getOne($this->database, $this->table, $fields, $payment_type_id);
	}

	public function save($param, $id)
	{
		//        log_message('debug','code:'.$param['code'].';id:'.$id);
		$this->saveDB($this->database, $this->tbl, $param, $id);
	}

	public function delete($id)
	{
		$this->saveDB($this->database, $this->tbl, ['status' => 0], $id);
	}


	public function deleteMultiple($ids)
	{
		$this->deleteDB($this->database, $this->tbl, $ids, true);
	}

	public function deleteAll()
	{
		$this->deleteAllDB($this->database, $this->tbl);
	}

	public function getAllIds()
	{
		$ids = [];
		$all = $this->all();
		foreach ($all as $k => $v) {
			$ids[] = $v['id'];
		}
		return $ids;
	}

	public function teacher_calendar()
	{
		$this->load->model('Tenant_model');
		$this->load->model('Event_enrollment_item_model');

		$tenantNo = $this->getTenantNo();
		$tenantName = $this->Tenant_model->detail_no($tenantNo)['name'];

		$baseQuery = $this->Event_enrollment_item_model->activeQuery($tenantNo);

		if (!$baseQuery['has_record']) {
			return [];
		}

		$this->db = $this->load->database($tenantNo, true);
		$payment_types = $this->db
			->from($this->table_prefix . $this->tbl)
			->where('mas_payment_type.status', 1)
			->join('mas_event_payment_type', 'mas_payment_type.id = mas_event_payment_type.payment_type_id')
			->join('mas_event', 'mas_event_payment_type.event_id = mas_event.id')
			->join('mas_event_timeslot', 'mas_event_payment_type.event_id = mas_event_timeslot.event_id')
			// show all timeslots
			->join('(' . $baseQuery['compiled_select'] . ') item', 'mas_event_timeslot.id = item.event_timeslot_id', 'left')
			->join('mas_room', 'mas_event.room_id = mas_room.id')
			->group_start()
			->group_start()
			->where('mas_event_timeslot.holiday_skip IS NULL', null, false)
			->where('mas_payment_type.mode != "period"', null, false)
			->group_end()
			->or_where('mas_payment_type.mode = "period"', null, false)
			->group_end()
			->where_in('YEAR(FROM_UNIXTIME(mas_event_timeslot.startdate))', $this->threeYearsInterval(), false)
			->select('
                mas_room.name as room_name,
                mas_payment_type.code as payment_type_code, 
                mas_payment_type.name, 
                mas_payment_type.id as payment_type_id, 
                mas_event_timeslot.event_id as event_id,
                mas_event_timeslot.starttime,
                mas_event_timeslot.endtime,
                item.*,
                item.id as item_id,
                mas_event_timeslot.startdate as date,
                mas_event_timeslot.id as event_timeslot_id
            ', false)
			->group_by('mas_event_timeslot.id')
			->order_by('mas_event_timeslot.id', 'asc')
			->get()
			->result_array();

//        log_message('debug', $this->db->last_query());

		$res = [];

		foreach ($payment_types as $item) {
			$timeslotId = $item['event_timeslot_id'];

			// $txnStatus = $item['txn_status'];
			// $date = Carbon::createFromTimestamp($item['date'])->timezone('Asia/Hong_Kong')->add(13, 'hour')->format('Y-m-d H:i:s');
			// 'Y-m-d\TH:i:s\Z'
			$date = date('Y-m-d H:i:s', $item['date']);
			$checkinDatetime = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : '';

			$date = explode(' ', $date)[0];
			// use date to generate app calendar compatible key
			$key = date('Y-m-d H:i:s', (new DateTime($date, new DateTimeZone('Asia/Hong_Kong')))->getTimestamp());
			// ZuluString
			$keys = explode(' ', $key);

			$calendarDatetime = sprintf('%sT%sZ', $keys[0], $keys[1]);
			$key = sprintf('%sT%sZ', $keys[0], '00:00:00');

			// EnrollmentItemId
			$itemId = $item['item_id'];
			$values = [
				'item_id' => $itemId,
				'room_name' => sprintf('%s %s', $tenantName, $item['room_name'] ?? ''),
				'payment_type_id' => $item['payment_type_id'],
				'payment_type_code' => $item['payment_type_code'] ?? '',
				'title' => $item['name'] ?? '',
				'student_id' => $item['student_id'],
				'timeslot_id' => $timeslotId,
				'date' => $date,
				'type' => '上課記錄',
				'time' => sprintf('%s - %s', $item['starttime'], $item['endtime']),
				'checkin' => $checkinDatetime,
				'teacher_comment' => '',
				'taken_leave_datetime' => $item['taken_leave_datetime'] ?? "",
				'absent' => $item['absent'] ? 1 : 0,
				'makeup' => $item['txn_status'] == 'M' ? 1 : 0,
				'calendar_datetime' => $calendarDatetime,
				'enrolled' => $item['txn_status'] != null ? 1 : 0,
				'quota' => 0
			];

			$this->array_put($res, $key, $values);
		}

		return $res;
	}

	public function listing_students($timeslotId)
	{
		$tenantNo = $this->getTenantNo();
		$this->load->model('Event_enrollment_item_model');

		$baseQuery = $this->Event_enrollment_item_model->activeQuery($tenantNo, true);

		if (!$baseQuery['has_record']) {
			return [];
		}

		$this->db = $this->load->database($tenantNo, true);
		$payment_types = $this->db
			->from('mas_payment_type')
			->where('mas_payment_type.status', 1)
			->join('mas_event_payment_type', 'mas_payment_type.id = mas_event_payment_type.payment_type_id')
			->join('mas_event_timeslot', 'mas_event_payment_type.event_id = mas_event_timeslot.event_id')
			// show all timeslots
			->join('(' . $baseQuery['compiled_select'] . ') item', 'mas_event_timeslot.id = item.event_timeslot_id')
			->join('mas_student', 'item.student_id = mas_student.id')
			->group_start()
			->group_start()
			->where('mas_event_timeslot.holiday_skip IS NULL', null, false)
			->where('mas_payment_type.mode != "period"', null, false)
			->group_end()
			->or_where('mas_payment_type.mode = "period"', null, false)
			->group_end()
			->where('item.event_timeslot_id', $timeslotId)
			->where('item.id IN (' . $this->Event_enrollment_item_model->getLatestQueryOnTimeslot($timeslotId) . ')', null, false)
			->where_in('YEAR(FROM_UNIXTIME(mas_event_timeslot.startdate))', $this->threeYearsInterval(), false)
			->select('
                mas_payment_type.name, 
                mas_payment_type.id as payment_type_id, 
                mas_event_timeslot.event_id as event_id,
                mas_event_timeslot.starttime,
                mas_event_timeslot.endtime,
                item.*,
                item.id as item_id,
                mas_student.chi_name as student_name,
                mas_event_timeslot.startdate as date,
                mas_event_timeslot.id as event_timeslot_id
            ', false)
			->order_by('mas_event_timeslot.id', 'asc')
			->get()
			->result_array();

//        log_message('debug', $this->db->last_query());

		$res = [];

		foreach ($payment_types as $item) {
			$timeslotId = $item['event_timeslot_id'];

			// $txnStatus = $item['txn_status'];
			// $date = Carbon::createFromTimestamp($item['date'])->timezone('Asia/Hong_Kong')->add(13, 'hour')->format('Y-m-d H:i:s');
			// 'Y-m-d\TH:i:s\Z'
			$date = date('Y-m-d H:i:s', $item['date']);
			$checkinDatetime = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : '';

			$date = explode(' ', $date)[0];
			// use date to generate app calendar compatible key
			$key = date('Y-m-d H:i:s', (new DateTime($date, new DateTimeZone('Asia/Hong_Kong')))->getTimestamp());
			// ZuluString
			$keys = explode(' ', $key);

			$calendarDatetime = sprintf('%sT%sZ', $keys[0], $keys[1]);
			$key = sprintf('%sT%sZ', $keys[0], '00:00:00');

			// EnrollmentItemId
			$itemId = $item['item_id'];
			$values = [
				'item_id' => $itemId,
				'payment_type_id' => $item['payment_type_id'],
				'student_id' => $item['student_id'],
				'student_name' => $item['student_name'],
				'timeslot_id' => $timeslotId,
				'date' => $date,
				'type' => '上課記錄',
				'time' => sprintf('%s - %s', $item['starttime'], $item['endtime']),
				'title' => $item['name'] ?? '',
				'checkin' => $checkinDatetime,
				'teacher_comment' => '',
				'taken_leave_datetime' => $item['taken_leave_datetime'] ?? "",
				'absent' => $item['absent'] ? 1 : 0,
				'makeup' => $item['txn_status'] == 'M' ? 1 : 0,
				'calendar_datetime' => $calendarDatetime,
				'enrolled' => $item['txn_status'] != null ? 1 : 0,
				'quota' => 0
			];

			if ($values['absent'] == 0 && $values['makeup'] == 0 && $values['taken_leave_datetime'] == '') {
				$values['in_datetime'] = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : "";
				$values['out_datetime'] = !empty($item['out_datetime']) ? date('H:i', $item['out_datetime']) : "";
			} else {
				$values['in_datetime'] = "";
				$values['out_datetime'] = "";
			}
			if ($values['makeup'] == 1) {
				$this->Event_enrollment_item_model->setTenantNo($tenantNo);
				$nextItem = $this->Event_enrollment_item_model->detail_in_nextTimeslot($item['next_txn_id']);
				$values['makeup_date'] = date('Y-m-d', $nextItem['startdate']);
			} else {
				$values['makeup_date'] = "";
			}

			if ($values['absent'] == 0 && $values['makeup'] == 0 && $values['taken_leave_datetime'] == '' && $values['in_datetime'] == '' && $values['out_datetime'] == '') {
				$values['not_processed'] = 1;
			} else {
				$values['not_processed'] = 0;
			}
			$this->array_put($res, $key, $values);
		}

		return $res;
	}

	private function threeYearsInterval()
	{
		$currentYear = date('Y');
		$_currentYear = (int)$currentYear;
		$previousYear = $_currentYear - 1;
		$nextYear = $_currentYear + 1;

		return compact('currentYear', 'previousYear', 'nextYear');
	}

}
