<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Enquiry_items_model extends MY_Model
{

	public $short = "ei";
	public $table;
	public $tbl;

	public function __construct()
	{
		parent::__construct();
		$this->tbl = 'enquiry_items';
		$this->table = $this->tbl . ' ' . $this->short;
	}

	public function all()
	{
		$result = $this->db->from($this->table)
			->select('ei.*, ec.name as category_name')
			->join('enquiry_category ec', 'ec.id = ei.category_id')
			->get()->result_array();
		return $result;
	}

	public function items($category_id)
	{
		$result = $this->db->from($this->table)
			->where('category_id', $category_id)
			->order_by('sequence')
			->get()->result_array();
		return $result;
	}

	public function in($item_ids)
	{
		$result = $this->db->from($this->table)
			->where_in('id', $item_ids)
			->order_by('id')
			->get()->result_array();
		return $result;
	}

	public function one($id)
	{
		$result = $this->db->from($this->table)
			->where(['ec.id' => $id])
			->get()->row_array();
		return $result;
	}

	public function create($params)
	{
		$data = [
			'subject' => $params['subject'],
			'content' => $params['description'],
			'item_id' => 0,
			'sent_date' => 0,
			'status' => 1,
		];
		$this->db->set('created_at', 'UNIX_TIMESTAMP()', false);
		$this->db->set('updated_at', 'UNIX_TIMESTAMP()', false);
		$this->db->insert($this->tbl, $data);
		return 0;
	}

	public function modify($params)
	{
		$email = $this->one($params['id']);
		$data = [
			'subject' => $params['subject'],
			'content' => $params['description'],
		];
		$this->db->set('updated_at', 'UNIX_TIMESTAMP()', false);
		$this->db->where(['id' => $params['id']])->update($this->tbl, $data);
		return 0;
	}

	public function sent($params)
	{
		return 0;
	}

	public function remove($id)
	{
		$this->db->where(['id' => $id])
			->delete($this->tbl);
		return 0;
	}

}
