<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Enquiry_category_model extends MY_Model
{

	public $short = "ec";
	public $table;
	public $tbl;

	public function __construct()
	{
		parent::__construct();
		$this->tbl = 'enquiry_category';
		$this->table = $this->tbl . ' ' . $this->short;
	}

	public function getAllCategories()
	{
		$result = $this->db->from($this->table)
			->get()->result_array();
		return $result;
	}

	public function all()
	{
		$result = $this->db->from($this->table)
			->get()->result_array();
		$this->load->model('Enquiry_items_model', 'enquiry_items');
		foreach ($result as $idx => $res) {
			$result[$idx]['items'] = $this->enquiry_items->items($res['id']);
		}
		return $result;
	}

	public function one($id)
	{
		$result = $this->db->from($this->table)
			->where(['ec.id' => $id])
			->get()->row_array();
		return $result;
	}

	public function create($params)
	{
		$data = [
			'subject' => $params['subject'],
			'content' => $params['description'],
			'item_id' => 0,
			'sent_date' => 0,
			'status' => 1,
		];
		$this->db->set('created_at', 'UNIX_TIMESTAMP()', false);
		$this->db->set('updated_at', 'UNIX_TIMESTAMP()', false);
		$this->db->insert($this->tbl, $data);
		return 0;
	}

	public function modify($params)
	{
		$email = $this->one($params['id']);
		$data = [
			'subject' => $params['subject'],
			'content' => $params['description'],
		];
		$this->db->set('updated_at', 'UNIX_TIMESTAMP()', false);
		$this->db->where(['id' => $params['id']])->update($this->tbl, $data);
		return 0;
	}

	public function sent($params)
	{
		return 0;
	}

	public function remove($id)
	{
		$this->db->where(['id' => $id])
			->delete($this->tbl);
		return 0;
	}

}
