<?php

use app\libraries\CommonHelper;
use app\libraries\DateHelper;
use app\libraries\Tenants;

defined('BASEPATH') or exit('No direct script access allowed');

class Emarketing_Model extends MY_Model
{
	public $short = "c";
	public $table;
	public $tbl;
	//    public $database;
	public $filteredcount = 0;

	public $rulelist = array();
	public $ruletypes = array();
	public $ruledefaultname = '';
	public $ruletriggers = array();

	public function __construct()
	{
		parent::__construct();
		$this->tbl = 'apps';
		$this->table = $this->tbl . ' ' . $this->short;
		$this->rulelist = [
			'sub' => lang('on_subscribe'),
			'unsub' => lang('on_unsubscribe'),
			'send' => lang('when_campaign_starts_sending'),
			'sent' => lang('on_campaign_sent'),
//			'auto'=>lang('on_autoresponder_email_sent')
		];
		$this->ruletypes = ['campaign' => lang('campaign'), 'list' => lang('list')];
		$this->ruledefaultname = lang('anycampaign');
	}

	public function allforlist()
	{
		$fields = [$this->short . '.id', $this->short . '.name', $this->short . '.introduction', $this->short . '.update_time'];
		return $this->getAll($this->database, $this->table, $fields, ['status' => 1]);
	}

	public function alltemplates()
	{
		$_fields = ['id', 'template_name'];
		$where = ['status' => 1];
		return $this->getAll($this->database, 'template', $_fields, $where);
	}

	public function getapps()
	{
		return $this->getOne($this->database, 'apps', [], '1');
	}

	public function allforfilter()
	{
		$_fields = [$this->short . '.id', $this->short . '.name'];
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function listing_selection()
	{


		return $this->db->from('mas_apps')->get()->result_array();
	}

	public function detail($id, $table, $fields = [])
	{
		return $this->getOne($this->database, $table, $fields, $id);
	}

	public function isRegular($mode)
	{
		return in_array($mode, ['month', 'lesson']);
	}

	public function fullTitle($name, $weekdays)
	{
		if (!empty($weekdays)) {
			$tcWeekdays = [];

			$default = DateHelper::getDefaultTcWeekdays();
			if (!empty($weekdays)) {
				foreach (explode('/', $weekdays) as $weekdayIndex) {
					array_push($tcWeekdays, $default[$weekdayIndex]);
				}
				return sprintf('%s (%s)', $name, implode('/', $tcWeekdays));
			} else {
				return sprintf('%s', $name);
			}
		} else {
			return $name;
		}
	}

	public function create($params)
	{
	}

	public function update($params, $id)
	{
	}

	public function totalCount_rules()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from('rules ' . $this->short);
		$db->where([$this->short . '.status' => 1]);
		return $db->count_all_results();
	}

	public function filteredCount_rules($param)
	{
		$fields = [];
		$db = $this->load->database($this->database, TRUE);
//		$db->select(implode(', ', $fields));
		$db->from('rules ' . $this->short);
		$db->where([$this->short . '.status' => 1]);
//		foreach ($joins as $joinTbl => $condition) {
//			$db->join($joinTbl, $condition);
//		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing_rules($param)
	{
		/*(case when r.unsubscribe_list_id is not null then (select distinct l.name from rules r join lists l on r.unsubscribe_list_id=l.id) else 0 end) as unsubscribe_list*/
		$fields = [$this->short . '.id', $this->short . '.trigger', $this->short . '.action', $this->short . '.endpoint', $this->short . '.notification_email', $this->short . '.list', $this->short . '.unsubscribe_list_id'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter_rules($this->database, 'rules ' . $this->short, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		//        log_message('debug','count result:'.count($result));
		$data = [];
		foreach ($result as $row) {
			$id = stripslashes($row['id']);
			$trigger = $row['trigger'];
			$action = $row['action'];
			switch ($trigger) {
				case RuleTrigger::campaign_sending:
					$triggerdisplay = '<span class="label trigger-action"><i class="glyphicon glyphicon-repeat"></i> ' . lang('when_campaign_starts_sending') . '</span>';
					break;
				case RuleTrigger::unsubscribe:
					$triggerdisplay = '<span class="label trigger-action"><i class="glyphicon glyphicon-minus"></i> ' . lang('on_unsubscribe') . '</span>';
					break;
				case RuleTrigger::campaign_sent:
					$triggerdisplay = '<span class="label trigger-action"><i class="glyphicon glyphicon-ok"></i> ' . lang('on_campaign_sent') . '</span>';
					break;
				case RuleTrigger::subscribe:
				default:
					$triggerdisplay = '<span class="label trigger-action"><i class="glyphicon glyphicon-plus"></i> ' . lang('on_subscribe') . '</span>';
					break;
			}
			switch ($action) {
				case RuleAction::notify:
					$actiondisplay = '<span class="label trigger-action"><i class="glyphicon glyphicon-envelope"></i> ' . lang('send') . lang('email') . lang('notification') . '</span>';
					break;
				case RuleAction::webhook:
					$actiondisplay = '<span class="label trigger-action"><i class="glyphicon glyphicon-globe"></i> ' . lang('webhook') . '</span>';
					break;
				case RuleAction::unsub_from_list:
				default:
					$actiondisplay = '<span class="label trigger-action"><i class="glyphicon glyphicon-ban-circle"></i> ' . lang('unsubscribe') . '</span>';
					break;
			}
			$data[] = [
				'id' => $id,
				'type' => empty($row['list']) ? lang('campaign') : lang('list'),
				'name' => empty($row['listname']) ? lang('anycampaign') : $row['listname'],
				'trigger' => $triggerdisplay,
				'action' => $actiondisplay,
				'details' => '<i id="details-' . $row['id'] . '" class="fa fa-edit"></i>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function totalCount_campaigns()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from('campaigns ' . $this->short);
//		$db->where(['status' => 1]);
		return $db->count_all_results();
	}

	public function filteredCount_campaigns($param)
	{
		$fields = [];
		$db = $this->load->database($this->database, TRUE);
//		$db->select(implode(', ', $fields));
		$db->from('campaigns ' . $this->short);
		$db->where([$this->short . '.status' => 1]);
//		foreach ($joins as $joinTbl => $condition) {
//			$db->join($joinTbl, $condition);
//		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing_campaigns($param)
	{
		$fields = [];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter($this->database, 'campaigns ' . $this->short, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		//        log_message('debug','count result:'.count($result));
		$data = [];
		foreach ($result as $row) {
			$id = stripslashes($row['id']);
			$timezone = stripslashes($row['timezone']);
			if ($timezone == '' || $timezone == 0) date_default_timezone_set('Asia/Hong_Kong');
			else date_default_timezone_set($timezone);
			$title = stripslashes(htmlentities($row['title'], ENT_QUOTES, "UTF-8"));
			$campaign_title = $row['label'] == '' ? $title : stripslashes(htmlentities($row['label'], ENT_QUOTES, "UTF-8"));
			$recipients = stripslashes($row['recipients']);
			$sent = stripslashes($row['sent']);
			$opens = stripslashes($row['opens']);
			$send_date = stripslashes($row['send_date']);
			$scheduled_lists = stripslashes($row['lists']);
			$to_send = stripslashes($row['to_send']);
			$to_send_lists = stripslashes($row['to_send_lists']);
			$from_name = stripslashes($row['from_name']);
			$from_email = stripslashes($row['from_email']);
			$error_stack = stripslashes($row['errors']);
			$error_stack_array = explode(',', $error_stack);
			$no_of_errors = count($error_stack_array);
			$opens_tracking = stripslashes($row['opens_tracking']);
			$links_tracking = stripslashes($row['links_tracking']);

			//check if campaign is completely sent
			if ($sent != '') {
				//check if campaign sending is incomplete
				if ($recipients >= $to_send) {
					$sent_to_all = true;
				} else {
					if ($to_send == NULL)
						$sent_to_all = true;
					else
						$sent_to_all = false;
				}
			} else {
				$sent_to_all = false;

				//check if scheduled
				if ($send_date == '') {
					$label = '<span class="label">' . lang('Draft') . '</span>';
					$scheduled_title = lang('Define recipients & send');
				} else {
					date_default_timezone_set($timezone);
					$send_date_totime = strftime("%a, %b %d, %Y %I:%M%p", $send_date);
					$label = '<span class="label label-info">' . lang('Scheduled') . '</span>';
					$scheduled_title = lang('Scheduled on') . ' ' . $send_date_totime . ' (' . $timezone . ')';
				}
			}

			if ($opens == '') {
				$percentage_opened = 0;
				$opens_unique = 0;
			} else {
				$opens_array = explode(',', $opens);
				$opens_array2 = array();
				foreach ($opens_array as $oa) {
					$oa = $oa . ',';
//					$oa = delete_between(':', ',', $oa);
					array_push($opens_array2, $oa);
				}
				$opens_unique = count(array_unique($opens_array2));
				$percentage_opened = round($opens_unique / ($recipients - $this->get_bounced_camp($id)) * 100, 2);
			}
			if ($recipients == 0 || $recipients == '') $percentage_clicked = round($this->get_click_percentage_camp($id) * 100, 2);
			else $percentage_clicked = round($this->get_click_percentage_camp($id) / $recipients * 100, 2);

			//tags for subject
			preg_match_all('/\[([a-zA-Z0-9!#%^&*()+=$@._\-\:|\/?<>~`"\'\s]+),\s*fallback=/i', $title, $matches_var, PREG_PATTERN_ORDER);
			preg_match_all('/,\s*fallback=([a-zA-Z0-9!,#%^&*()+=$@._\-\:|\/?<>~`"\'\s]*)\]/i', $title, $matches_val, PREG_PATTERN_ORDER);
			preg_match_all('/(\[[a-zA-Z0-9!#%^&*()+=$@._\-\:|\/?<>~`"\'\s]+,\s*fallback=[a-zA-Z0-9!,#%^&*()+=$@._\-\:|\/?<>~`"\'\s]*\])/i', $title, $matches_all, PREG_PATTERN_ORDER);
			preg_match_all('/\[([^\]]+),\s*fallback=/i', $title, $matches_var, PREG_PATTERN_ORDER);
			preg_match_all('/,\s*fallback=([^\]]*)\]/i', $title, $matches_val, PREG_PATTERN_ORDER);
			preg_match_all('/(\[[^\]]+,\s*fallback=[^\]]*\])/i', $title, $matches_all, PREG_PATTERN_ORDER);
			$matches_var = $matches_var[1];
			$matches_val = $matches_val[1];
			$matches_all = $matches_all[1];
			for ($i = 0; $i < count($matches_var); $i++) {
				$field = $matches_var[$i];
				$fallback = $matches_val[$i];
				$tag = $matches_all[$i];
				//for each match, replace tag with fallback
				$title = str_replace($tag, $fallback, $title);
			}
			$title = str_replace('[Email]', $from_email, $title);
			$title = str_replace('[Name]', $from_name, $title);

			//convert date
//			if (get_app_info('timezone') != '') date_default_timezone_set(get_app_info('timezone'));
			$today = $sent == '' ? time() : $sent;
			$today = $send_date != '' && $send_date != 0 ? $send_date : $today;
			$currentdaynumber = strftime('%d', $today);
			$currentday = strftime('%A', $today);
			$currentmonthnumber = strftime('%m', $today);
			$currentmonth = strftime('%B', $today);
			$currentyear = strftime('%Y', $today);
			$unconverted_date = array('[currentdaynumber]', '[currentday]', '[currentmonthnumber]', '[currentmonth]', '[currentyear]');
			$converted_date = array($currentdaynumber, $currentday, $currentmonthnumber, $currentmonth, $currentyear);
			$title = str_replace($unconverted_date, $converted_date, $title);

			//Show opens and/or clicks data depending on whether tracking is enabled
			$open_data = $opens_tracking ? $percentage_opened . '%</span> ' . number_format($opens_unique) . ' ' . lang('emark_opened') : lang('Tracking disabled');
			$click_data = $links_tracking ? $percentage_clicked . '%</span> ' . number_format($this->get_click_percentage_camp($id)) . ' ' . lang('emark_clicked') : lang('Tracking disabled');
			$data[] = [
				'id' => $id,
				'sent' => (!empty($sent)) ? formatdatetime($sent) : '---',
				'title' => $title,
				'recipients' => $recipients,
				'percentage_opened' => $percentage_opened,
				'opened_num' => ($percentage_opened > 0) ? ceil(intval($recipients) * ($percentage_opened / 100)) : 0,
				'percentage_clicked' => $percentage_clicked,
				'clicked_num' => ($percentage_clicked > 0) ? ceil(intval($recipients) * ($percentage_clicked / 100)) : 0,
				'details' => '<i id="details-' . $row['id'] . '" class="fa fa-edit"></i>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function totalCount_templates()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from('template ' . $this->short);
//		$db->where(['status' => 1]);
		return $db->count_all_results();
	}

	public function filteredCount_templates($param)
	{
		$fields = [];
		$db = $this->load->database($this->database, TRUE);
//		$db->select(implode(', ', $fields));
		$db->from('template ' . $this->short);
//		$db->where(['status' => 1]);
//		foreach ($joins as $joinTbl => $condition) {
//			$db->join($joinTbl, $condition);
//		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing_templates($param)
	{
		$fields = [];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter($this->database, 'template ' . $this->short, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		//        log_message('debug','count result:'.count($result));
		$data = [];
		foreach ($result as $row) {
			$id = stripslashes($row['id']);
			$data[] = [
				'id' => $id,
				'template_name' => $row['template_name'],
				'preview' => '<i id="preview-' . $row['id'] . '" class="fa fa-eye"></i>',
				'clone' => '<i id="clone-' . $row['id'] . '" class="fa fa-clone"></i>',
				'details' => '<i id="details-' . $row['id'] . '" class="fa fa-edit"></i>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function totalCount_subscriptions()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from('subscribers ' . $this->short);
//		$db->where(['status' => 1]);
		return $db->count_all_results();
	}

	public function filteredCount_subscriptions($param)
	{
		$fields = [];
		$db = $this->load->database($this->database, TRUE);
//		$db->select(implode(', ', $fields));
		$db->from('subscribers ' . $this->short);
//		$db->where(['status' => 1]);
//		foreach ($joins as $joinTbl => $condition) {
//			$db->join($joinTbl, $condition);
//		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing_subscriptions($param)
	{
		$fields = [];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter($this->database, 'subscribers ' . $this->short, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		//        log_message('debug','count result:'.count($result));
		$data = [];
		foreach ($result as $row) {
			$id = stripslashes($row['id']);
			$data[] = [
				'id' => $id,
				'name' => $row['name'],
				'email' => '<a href="mailto:' . $row['email'] . '">' . $row['email'] . '</a>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function totalCount_blacklist()
	{
		$db = $this->load->database($this->database, TRUE);
		$db->from('suppression_list ' . $this->short);
//		$db->where(['status' => 1]);
		return $db->count_all_results();
	}

	public function filteredCount_blacklist($param)
	{
		$fields = [];
		$db = $this->load->database($this->database, TRUE);
//		$db->select(implode(', ', $fields));
		$db->from('suppression_list ' . $this->short);
//		$db->where(['status' => 1]);
//		foreach ($joins as $joinTbl => $condition) {
//			$db->join($joinTbl, $condition);
//		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === 'name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		return count($db->get()->result_array());
	}

	public function listing_blacklist($param)
	{
		$fields = [];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $param['columns'][$colIdx]['data']);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('category', 'subname', 'subcc.name'), array('cc.name', 'ccs.name', 'ccs.name'), $column['data']);
				$searchfield = ($colName === 'cc.name' || $colName === 'ccs.name' || $colName === 'subcc.name') ? $colName : $this->short . "." . $colName;
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter($this->database, 'suppression_list ' . $this->short, $fields, $start, $length, $orders, $search, $joins, 'c.name');
		//        log_message('debug','count result:'.count($result));
		$data = [];
		foreach ($result as $row) {
			$id = stripslashes($row['id']);
			$data[] = [
				'id' => $id,
				'email' => '<a href="mailto:' . $row['email'] . '">' . $row['email'] . '</a>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		return $data;
	}

	public function getFromDBFilter($database, $table, $fields, $start, $length, $orders, $search, $joins = [], $keywordfieldname = '', $checkstatus = true)
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		$db->distinct();
//		log_message('debug','emptyfields?'.empty($fields));
		if (!empty($fields)) {
			$db->select(implode(', ', $fields));
		}
		if ($checkstatus) {
			$db->where([$this->short . '.status' => 1]);
		}

		$db->from($this->table_prefix . $table);

		if (count($joins) > 0) {
			foreach ($joins as $joinTbl => $condition) {
				$db->join($joinTbl, $condition);
			}
		}

		if (!empty($search) && !empty($keywordfieldname)) {
			//            log_message('debug','here');
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === $keywordfieldname) {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
//		order:cu.chi_firstc.name ASC
//		log_message('debug','order:'.implode(', ', $orders));
		$db->order_by(implode(', ', $orders));
		if ($start > -1) {
			$db->limit($length, $start);
		}
		$result = $db->get()->result_array();
//		log_message('debug','sql:'.$db->last_query());
		return $result;
	}

	//override
	public function getFromDBFilter_rules($database, $table, $fields, $start, $length, $orders, $search, $joins = [], $keywordfieldname = '', $checkstatus = true)
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		$db->distinct();
//		log_message('debug','emptyfields?'.empty($fields));
		if (!empty($fields)) {
			$db->select(implode(', ', $fields));
		}
		if ($checkstatus) {
			$db->where([$this->short . '.status' => 1]);
		}

		$db->from($this->table_prefix . $table);

		if (count($joins) > 0) {
			foreach ($joins as $joinTbl => $condition) {
				$db->join($joinTbl, $condition);
			}
		}

		if (!empty($search) && !empty($keywordfieldname)) {
			//            log_message('debug','here');
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === $keywordfieldname) {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
//		order:cu.chi_firstc.name ASC
//		log_message('debug','order:'.implode(', ', $orders));
		$db->order_by(implode(', ', $orders));
		if ($start > -1) {
			$db->limit($length, $start);
		}
		$result = $db->get()->result_array();

		$lists = $db->from('lists')->get()->result_array();
		foreach ($result as $k => $v) {
			$listname = '';
			if (!empty($v['list'])) {
				foreach ($lists as $list) {
					if ($v['list'] == $list['id']) {
						$listname = $list['name'];
						break;
					}
				}
			}
			if (!empty($v['unsubscribe_list_id'])) {
				foreach ($lists as $list) {
					if ($v['unsubscribe_list_id'] == $list['id']) {
						$listname = $list['name'];
						break;
					}
				}
			}
			$result[$k] = array_merge(['listname' => $listname], $result[$k]);

		}

//		log_message('debug','sql:'.$db->last_query());
		return $result;
	}

	private function get_click_percentage_camp($cid)
	{
		$clicks_join = '';
		//public function getOne($database, $table, $fields = [], $id = '', $idxname = 'id', $tableprefix = TRUE)
		$row = $this->getOne($this->database, 'links', [], $cid, 'campaign_id', false);
		if (!empty($row)) {
			$id = stripslashes($row['id']);
			$link = stripslashes($row['link']);
			$clicks = stripslashes($row['clicks']);
			if ($clicks != '') {
				$clicks_join .= $clicks . ',';
			}

		}
//		global $mysqli;
//		$clicks_join = '';
//		$clicks_array = array();
//		$clicks_unique = 0;
//
//		$q = 'SELECT * FROM links WHERE campaign_id = '.$cid;
//		$r = mysqli_query($mysqli, $q);
//		if ($r && mysqli_num_rows($r) > 0)
//		{
//			while($row = mysqli_fetch_array($r))
//			{
//				$id = stripslashes($row['id']);
//				$link = stripslashes($row['link']);
//				$clicks = stripslashes($row['clicks']);
//				if($clicks!='')
//					$clicks_join .= $clicks.',';
//			}
//		}

		$clicks_array = explode(',', $clicks_join);
		$clicks_unique = count(array_unique($clicks_array));

		return $clicks_unique - 1;
	}

	private function get_bounced_camp($c)
	{
		//public function getAll($database, $table, $fields = [], $where = null, $tableprefix = true)
		$result = $this->getAll($this->database, 'subscribers', ['last_campaign'], ['last_campaign' => $c, 'bounded' => 1]);
		if (empty($result)) {
			return 0;
		} else {
			return count($result);
		}
//		$q = 'SELECT last_campaign FROM subscribers WHERE last_campaign = ' . mysqli_real_escape_string($mysqli, $c) . ' AND bounced = 1';
//		$r = mysqli_query($mysqli, $q);
//		if ($r && mysqli_num_rows($r) > 0) {
//			return mysqli_num_rows($r);
//		} else {
//			return 0;
//		}
	}

	public function insert($param, $table)
	{
		$this->insertDB($this->database, $table, $param);
	}

	public function one($apps_id)
	{
		$this->load->model("Unit_model");
		$fields = [

			$this->short . '.id',
			$this->short . '.name',
			$this->short . '.introduction',
			$this->short . '.description',
			$this->short . '.duration',
			$this->short . '.status',
		];
		return $this->getOne($this->database, $this->table, $fields, $apps_id);
	}

	public function save($param, $id, $table)
	{
		//        log_message('debug','code:'.$param['code'].';id:'.$id);
		$this->saveDB($this->database, $table, $param, $id);
	}

	public function delete($id)
	{
		$this->saveDB($this->database, $this->tbl, ['status' => 0], $id);
	}


	public function deleteMultiple($ids)
	{
		$this->deleteDB($this->database, $this->tbl, $ids, true);
	}

	public function deleteAll()
	{
		$this->deleteAllDB($this->database, $this->tbl);
	}

	public function getAllIds()
	{
		$ids = [];
		$all = $this->all();
		foreach ($all as $k => $v) {
			$ids[] = $v['id'];
		}
		return $ids;
	}

	public function teacher_calendar()
	{
		$this->load->model('Tenant_model');
		$this->load->model('Event_enrollment_item_model');

		$tenantNo = $this->getTenantNo();
		$tenantName = $this->Tenant_model->detail_no($tenantNo)['name'];

		$baseQuery = $this->Event_enrollment_item_model->activeQuery($tenantNo);

		if (!$baseQuery['has_record']) {
			return [];
		}

		$this->db = $this->load->database($tenantNo, true);
		$appss = $this->db
			->from($this->table_prefix . $this->tbl)
			->where('mas_apps.status', 1)
			->join('mas_event_apps', 'mas_apps.id = mas_event_apps.apps_id')
			->join('mas_event', 'mas_event_apps.event_id = mas_event.id')
			->join('mas_event_timeslot', 'mas_event_apps.event_id = mas_event_timeslot.event_id')
			// show all timeslots
			->join('(' . $baseQuery['compiled_select'] . ') item', 'mas_event_timeslot.id = item.event_timeslot_id', 'left')
			->join('mas_room', 'mas_event.room_id = mas_room.id')
			->group_start()
			->group_start()
			->where('mas_event_timeslot.holiday_skip IS NULL', null, false)
			->where('mas_apps.mode != "period"', null, false)
			->group_end()
			->or_where('mas_apps.mode = "period"', null, false)
			->group_end()
			->where_in('YEAR(FROM_UNIXTIME(mas_event_timeslot.startdate))', $this->threeYearsInterval(), false)
			->select('
                mas_room.name as room_name,
                mas_apps.code as apps_code, 
                mas_apps.name, 
                mas_apps.id as apps_id, 
                mas_event_timeslot.event_id as event_id,
                mas_event_timeslot.starttime,
                mas_event_timeslot.endtime,
                item.*,
                item.id as item_id,
                mas_event_timeslot.startdate as date,
                mas_event_timeslot.id as event_timeslot_id
            ', false)
			->group_by('mas_event_timeslot.id')
			->order_by('mas_event_timeslot.id', 'asc')
			->get()
			->result_array();

//        log_message('debug', $this->db->last_query());

		$res = [];

		foreach ($appss as $item) {
			$timeslotId = $item['event_timeslot_id'];

			// $txnStatus = $item['txn_status'];
			// $date = Carbon::createFromTimestamp($item['date'])->timezone('Asia/Hong_Kong')->add(13, 'hour')->format('Y-m-d H:i:s');
			// 'Y-m-d\TH:i:s\Z'
			$date = date('Y-m-d H:i:s', $item['date']);
			$checkinDatetime = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : '';

			$date = explode(' ', $date)[0];
			// use date to generate app calendar compatible key
			$key = date('Y-m-d H:i:s', (new DateTime($date, new DateTimeZone('Asia/Hong_Kong')))->getTimestamp());
			// ZuluString
			$keys = explode(' ', $key);

			$calendarDatetime = sprintf('%sT%sZ', $keys[0], $keys[1]);
			$key = sprintf('%sT%sZ', $keys[0], '00:00:00');

			// EnrollmentItemId
			$itemId = $item['item_id'];
			$values = [
				'item_id' => $itemId,
				'room_name' => sprintf('%s %s', $tenantName, $item['room_name'] ?? ''),
				'apps_id' => $item['apps_id'],
				'apps_code' => $item['apps_code'] ?? '',
				'title' => $item['name'] ?? '',
				'student_id' => $item['student_id'],
				'timeslot_id' => $timeslotId,
				'date' => $date,
				'type' => '上課記錄',
				'time' => sprintf('%s - %s', $item['starttime'], $item['endtime']),
				'checkin' => $checkinDatetime,
				'teacher_comment' => '',
				'taken_leave_datetime' => $item['taken_leave_datetime'] ?? "",
				'absent' => $item['absent'] ? 1 : 0,
				'makeup' => $item['txn_status'] == 'M' ? 1 : 0,
				'calendar_datetime' => $calendarDatetime,
				'enrolled' => $item['txn_status'] != null ? 1 : 0,
				'quota' => 0
			];

			$this->array_put($res, $key, $values);
		}

		return $res;
	}

	public function listing_students($timeslotId)
	{
		$tenantNo = $this->getTenantNo();
		$this->load->model('Event_enrollment_item_model');

		$baseQuery = $this->Event_enrollment_item_model->activeQuery($tenantNo, true);

		if (!$baseQuery['has_record']) {
			return [];
		}

		$this->db = $this->load->database($tenantNo, true);
		$appss = $this->db
			->from('mas_apps')
			->where('mas_apps.status', 1)
			->join('mas_event_apps', 'mas_apps.id = mas_event_apps.apps_id')
			->join('mas_event_timeslot', 'mas_event_apps.event_id = mas_event_timeslot.event_id')
			// show all timeslots
			->join('(' . $baseQuery['compiled_select'] . ') item', 'mas_event_timeslot.id = item.event_timeslot_id')
			->join('mas_student', 'item.student_id = mas_student.id')
			->group_start()
			->group_start()
			->where('mas_event_timeslot.holiday_skip IS NULL', null, false)
			->where('mas_apps.mode != "period"', null, false)
			->group_end()
			->or_where('mas_apps.mode = "period"', null, false)
			->group_end()
			->where('item.event_timeslot_id', $timeslotId)
			->where('item.id IN (' . $this->Event_enrollment_item_model->getLatestQueryOnTimeslot($timeslotId) . ')', null, false)
			->where_in('YEAR(FROM_UNIXTIME(mas_event_timeslot.startdate))', $this->threeYearsInterval(), false)
			->select('
                mas_apps.name, 
                mas_apps.id as apps_id, 
                mas_event_timeslot.event_id as event_id,
                mas_event_timeslot.starttime,
                mas_event_timeslot.endtime,
                item.*,
                item.id as item_id,
                mas_student.chi_name as student_name,
                mas_event_timeslot.startdate as date,
                mas_event_timeslot.id as event_timeslot_id
            ', false)
			->order_by('mas_event_timeslot.id', 'asc')
			->get()
			->result_array();

//        log_message('debug', $this->db->last_query());

		$res = [];

		foreach ($appss as $item) {
			$timeslotId = $item['event_timeslot_id'];

			// $txnStatus = $item['txn_status'];
			// $date = Carbon::createFromTimestamp($item['date'])->timezone('Asia/Hong_Kong')->add(13, 'hour')->format('Y-m-d H:i:s');
			// 'Y-m-d\TH:i:s\Z'
			$date = date('Y-m-d H:i:s', $item['date']);
			$checkinDatetime = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : '';

			$date = explode(' ', $date)[0];
			// use date to generate app calendar compatible key
			$key = date('Y-m-d H:i:s', (new DateTime($date, new DateTimeZone('Asia/Hong_Kong')))->getTimestamp());
			// ZuluString
			$keys = explode(' ', $key);

			$calendarDatetime = sprintf('%sT%sZ', $keys[0], $keys[1]);
			$key = sprintf('%sT%sZ', $keys[0], '00:00:00');

			// EnrollmentItemId
			$itemId = $item['item_id'];
			$values = [
				'item_id' => $itemId,
				'apps_id' => $item['apps_id'],
				'student_id' => $item['student_id'],
				'student_name' => $item['student_name'],
				'timeslot_id' => $timeslotId,
				'date' => $date,
				'type' => '上課記錄',
				'time' => sprintf('%s - %s', $item['starttime'], $item['endtime']),
				'title' => $item['name'] ?? '',
				'checkin' => $checkinDatetime,
				'teacher_comment' => '',
				'taken_leave_datetime' => $item['taken_leave_datetime'] ?? "",
				'absent' => $item['absent'] ? 1 : 0,
				'makeup' => $item['txn_status'] == 'M' ? 1 : 0,
				'calendar_datetime' => $calendarDatetime,
				'enrolled' => $item['txn_status'] != null ? 1 : 0,
				'quota' => 0
			];

			if ($values['absent'] == 0 && $values['makeup'] == 0 && $values['taken_leave_datetime'] == '') {
				$values['in_datetime'] = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : "";
				$values['out_datetime'] = !empty($item['out_datetime']) ? date('H:i', $item['out_datetime']) : "";
			} else {
				$values['in_datetime'] = "";
				$values['out_datetime'] = "";
			}
			if ($values['makeup'] == 1) {
				$this->Event_enrollment_item_model->setTenantNo($tenantNo);
				$nextItem = $this->Event_enrollment_item_model->detail_in_nextTimeslot($item['next_txn_id']);
				$values['makeup_date'] = date('Y-m-d', $nextItem['startdate']);
			} else {
				$values['makeup_date'] = "";
			}

			if ($values['absent'] == 0 && $values['makeup'] == 0 && $values['taken_leave_datetime'] == '' && $values['in_datetime'] == '' && $values['out_datetime'] == '') {
				$values['not_processed'] = 1;
			} else {
				$values['not_processed'] = 0;
			}
			$this->array_put($res, $key, $values);
		}

		return $res;
	}

	private function threeYearsInterval()
	{
		$currentYear = date('Y');
		$_currentYear = (int)$currentYear;
		$previousYear = $_currentYear - 1;
		$nextYear = $_currentYear + 1;

		return compact('currentYear', 'previousYear', 'nextYear');
	}

	public function getsubscriptionlists(){
		return $this->getAll($this->database,'lists');
	}
}
