<?php

use app\libraries\CommonHelper;
use app\libraries\DateHelper;
use app\libraries\Tenants;

defined('BASEPATH') or exit('No direct script access allowed');

class Courseuser_model extends MY_Model
{
	public $short = "cu";
	public $tbl;
	//    public $database;
	public $filteredcount = 0;

	public function __construct()
	{
		parent::__construct();
		$this->tbl = 'course_user';
		$this->table = $this->tbl . ' ' . $this->short;
	}

	public function allforlist()
	{
		$fields = [$this->short . '.id', $this->short . '.name', $this->short . '.introduction', $this->short . '.update_time'];
		return $this->getAll($this->database, $this->table, $fields, ['status' => 1]);
	}

	public function all($fields = [])
	{
		$_fields = empty($fields) ? [$this->short . '.id', $this->short . '.name'] : $fields;
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function allforfilter()
	{
		$_fields = [$this->short . '.id', $this->short . '.name'];
		$where = [$this->short . '.status' => 1];
		return $this->getAll($this->database, $this->table, $_fields, $where);
	}

	public function listing_selection()
	{
		return $this->db->from('mas_course_user')->get()->result_array();
	}

	public function detailforpage($order_no)
	{
//		log_message('debug','modeldetailcalled');
		$this->load->model('Course_Model', 'Course_model');
		$this->load->model('User_Model', 'User_model');
		$this->load->model('Paymenttype_Model', 'Paymenttype_model');
		$c = $this->Course_model->short;
		$u = $this->User_model->short;
		$pt = $this->Paymenttype_model->short;
		$fields = [$this->short . '.id', 'FROM_UNIXTIME(' . $this->short . '.create_time' . ',\'%Y-%m-%d %H:%i:%s\') as create_time', $this->short . '.order_no', $c . '.name', $u . '.chi_firstname', $u . '.chi_lastname', $u . '.mobile',$u.'.email', $pt . '.name as paymenttype', $this->short . '.progress',$c.'.price'];

		$joins = [];
		$joins[$this->Course_model->table] = $this->short . '.course_id=' . $c . '.id';
		$joins[$this->User_model->table] = $this->short . '.user_id=' . $u . '.id';
		$joins[$this->Paymenttype_model->table] = $this->short . '.payment_type_id=' . $pt . '.id';
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $this->table);
		$db->where([$this->short . '.status' => 1]);
		foreach ($joins as $joinTbl => $condition) {
			$db->join($joinTbl, $condition);
		}
		$result = $db->get()->result_array();
		foreach($result as $k=>$v){
			if($v['order_no']!=$order_no){
				unset($result[$k]);
			}
		}
//		print_r($result);
//
		$item = new stdClass();
		$ordernolist=[];
		$totalprogress = 0;
//		log_message('debug','resultcount:'.count($result));
		foreach($result as $k=>$v){
			if(!in_array($v['order_no'],$ordernolist)){
				$item->create_time=$v['create_time'];
				$item->paymenttype=$v['paymenttype'];
				$item->order_no =$v['order_no'];
				$item->chi_firstname = $v['chi_firstname'];
				$item->chi_lastname = $v['chi_lastname'];
				$item->mobile =$v['mobile'];
				$item->email =$v['email'];
			}
			$totalprogress+=floatval($v['progress']);
			$ordernolist[]=$v['order_no'];
		}
		$item->progress = number_format((float)($totalprogress*100)/count($result),2,'.','').'%';
		$data = array($item, $result);
		return $data;
	}

	public function isRegular($mode)
	{
		return in_array($mode, ['month', 'lesson']);
	}

	public function fullTitle($name, $weekdays)
	{
		if (!empty($weekdays)) {
			$tcWeekdays = [];

			$default = DateHelper::getDefaultTcWeekdays();
			if (!empty($weekdays)) {
				foreach (explode('/', $weekdays) as $weekdayIndex) {
					array_push($tcWeekdays, $default[$weekdayIndex]);
				}
				return sprintf('%s (%s)', $name, implode('/', $tcWeekdays));
			} else {
				return sprintf('%s', $name);
			}
		} else {
			return $name;
		}
	}

	public function create($params)
	{
	}

	public function update($params, $id)
	{
	}

	public function totalCount()
	{
		$this->load->model('Course_Model', 'Course_model');
		$db = $this->load->database($this->database, TRUE);
		$db->from($this->table_prefix . $this->table);
//		$db->where(['status' => 1]);
		return $db->count_all_results();
	}

	public function filteredCount($param)
	{
		$this->load->model('Course_Model', 'Course_model');
		$this->load->model('User_Model', 'User_model');
		$this->load->model('Paymenttype_Model', 'Paymenttype_model');
		$c = $this->Course_model->short;
		$u = $this->User_model->short;
		$pt = $this->Paymenttype_model->short;

		$fields = [$this->short . '.id', $this->short . '.create_time', $this->short . '.order_no', $c . '.name', $u . '.chi_firstname', $u . '.chi_lastname', $u . '.mobile', $pt . '.name as paymenttype'];
		$joins = [];
		$joins[$this->Course_model->table] = $this->short . '.course_id=' . $c . '.id';
		$joins[$this->User_model->table] = $this->short . '.user_id=' . $u . '.id';
		$joins[$this->Paymenttype_model->table] = $this->short . '.payment_type_id=' . $pt . '.id';
		$db = $this->load->database($this->database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $this->table);
		foreach ($joins as $joinTbl => $condition) {
			$db->join($joinTbl, $condition);
		}
		$search = [];
		foreach ($param['columns'] as $column) {
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('coursename', 'chi_firstname', 'chi_lastname','mobile','paymenttype'), array($c.'.name', $u.'.chi_firstname',$u.'.chi_lastname',$u . '.mobile',$pt.'.name'), $column['data']);
//				log_message('debug','data:'.$param['columns'][$colIdx]['data'].';colname:'.$colName);//data:id;colname:id
				$searchfield = ($colName === $c.'.name' ||$colName === $u.'.chi_firstname' || $colName === $u.'.chi_lastname' || $colName === $u . '.mobile'|| $colName === $pt . '.name') ? $colName : $this->short . "." . $colName;
//				data:coursename;searchfield:c.name
//				log_message('debug','searchfield:'.$searchfield.';searchvalue:'.$column['search']['value']);
				$search[$searchfield] = $column['search']['value'];
			}
		}

		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === $c.'.name') {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
		$data = $db->get()->result_array();
//		log_message('debug','sql:'.$db->last_query());
//		log_message('debug','datacount:'.count($data));
		return count($data);
	}

	public function listing($param)
	{
		$this->load->model('Course_Model', 'Course_model');
		$this->load->model('User_Model', 'User_model');
		$this->load->model('Paymenttype_Model', 'Paymenttype_model');
		$c = $this->Course_model->short;
		$u = $this->User_model->short;
		$pt = $this->Paymenttype_model->short;
		/*
		 * Select cu.id,cu.create_time, cu.order_no, c.name, u.chi_firstname,u.chi_lastname,u.mobile,pt.name
from Course_user cu
join Course c on cu.course_id = c.id
join rbac_users u on cu.user_id=u.id
join payment_type pt on cu.payment_type_id=pt.id
where cu.status=1
		 */
		$fields = [$this->short . '.id', $this->short . '.create_time', $this->short . '.order_no', $c . '.name as coursename', $u . '.chi_firstname', $u . '.chi_lastname', $u . '.mobile', $pt . '.name as paymenttype', $this->short . '.progress'];
		$orders = [];
		foreach ($param['order'] as $order) {
			$colIdx = $order['column'];
			//colidx:4;data:chi_firstname
//			log_message('debug','colidx:'.$order['column'].';data:'.$param['columns'][$colIdx]['data']);
			$colName = str_replace(array('chi_firstname', 'chi_lastname','mobile','paymenttype'), array($u.'.chi_firstname',$u.'.chi_lastname',$u . '.mobile',$pt.'.name'), $param['columns'][$colIdx]['data']);
//			colname:chi_firstc.name
//			log_message('debug','colname:'.$colName);
			$dir = strtoupper($order['dir']);
			$orders[] = ($colName === 'coursename' ||$colName === $u.'.chi_firstname' || $colName === $u.'.chi_lastname' || $colName === $u . '.mobile'|| $colName === $pt . '.name') ? $colName . ' ' . $dir : $this->short . "." . $colName . ' ' . $dir;
			//            log_message('debug','colname:'.$colName.';dir:'.$dir);
		}
		$start = $param['start'];
		$length = $param['length'];
		$joins = [];
		$joins[$this->Course_model->table] = $this->short . '.course_id=' . $c . '.id';
		$joins[$this->User_model->table] = $this->short . '.user_id=' . $u . '.id';
		$joins[$this->Paymenttype_model->table] = $this->short . '.payment_type_id=' . $pt . '.id';
		$search = [];
		//        if (trim($searchVal) !== "") {
		foreach ($param['columns'] as $column) {
//			log_message('debug','idx:'.$idx);
			if ($column['searchable'] === "true" && !empty($column['search']['value'])) {
				$colName = str_replace(array('coursename', 'chi_firstname', 'chi_lastname','mobile','paymenttype'), array($c.'.name', $u.'.chi_firstname',$u.'.chi_lastname',$u . '.mobile',$pt.'.name'), $column['data']);
//				log_message('debug','data:'.$param['columns'][$colIdx]['data'].';colname:'.$colName);//data:id;colname:id
				$searchfield = ($colName === $c.'.name' ||$colName === $u.'.chi_firstname' || $colName === $u.'.chi_lastname' || $colName === $u . '.mobile'|| $colName === $pt . '.name') ? $colName : $this->short . "." . $colName;
//				data:coursename;searchfield:c.name
//				log_message('debug','searchfield:'.$searchfield.';searchvalue:'.$column['search']['value']);
				$search[$searchfield] = $column['search']['value'];
			}
		}
		$result = $this->getFromDBFilter1($this->database, $this->table, $fields, $start, $length, $orders, $search, $joins, $c.'.name');
		/*
		 * Select cu.id,cu.create_time, cu.order_no, c.name, u.chi_firstname,u.chi_lastname,u.mobile,pt.name
from Course_user cu
join Course c on cu.course_id = c.id
join rbac_users u on cu.user_id=u.id
join payment_type pt on cu.payment_type_id=pt.id
where cu.status=1
		 */
		$data = [];
		foreach ($result as $row) {
			$data[] = [
				'id' => $row['id'],
				'create_time' => formatdatetime($row['create_time']),
				'order_no' => $row['order_no'],
				'coursename' => $row['coursename'],
				'chi_firstname' => $row['chi_firstname'],
				'chi_lastname' => $row['chi_lastname'],
				'mobile' => $row['mobile'],
				'paymenttype' => $row['paymenttype'],
				'details' => '<i id="details-' . $row['order_no'] . '" class="glyphicon glyphicon-edit"></i>',
				'delete' => '<input id="' . $row['id'] . '" type="checkbox" class="checkbox-delete" />',
			];
		}
		$ordernolist = [];
		foreach ($data as $k => $v) {
			if (in_array($v['order_no'], $ordernolist)) {
//				if(!array_key_exists('name'))
				foreach ($v as $k1 => $v1) {
//					log_message('debug','name:'.$k1);
					if ($k1 !== 'coursename') {
						$v1 = '';
					}
					$v[$k1] = $v1;
				}
				$data[$k] = $v;
			}
			$ordernolist[] = $v['order_no'];
		}

		return $data;
	}

	public function getFromDBFilter1($database, $table, $fields, $start, $length, $orders, $search, $joins = [], $keywordfieldname = '')
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		$db->distinct();
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $table);

		if (count($joins) > 0) {
			foreach ($joins as $joinTbl => $condition) {
				$db->join($joinTbl, $condition);
			}
		}
		$db->order_by(implode(', ', $orders));
		if ($start > -1) {
			$db->limit($length, $start);
		}

		if (!empty($search)) {
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === $keywordfieldname) {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
//		return $result;
		$data= $db->get()->result_array();
		return $data;
	}

	public function insert($param)
	{
		return $this->insertDB($this->database, $this->tbl, $param);
	}

	public function saveuserasrole($id, $role = '5')
	{
		return $this->insertDB($this->database, 'course_user_roles', ['user_id' => $id, 'role_id' => $role]);
	}

	public function one($course_user_id)
	{
		$this->load->model("Unit_model");
		$fields = [

			$this->short . '.id',
			$this->short . '.name',
			$this->short . '.introduction',
			$this->short . '.description',
			$this->short . '.duration',
			$this->short . '.status',
		];
		return $this->getOne($this->database, $this->table, $fields, $course_user_id);
	}

	public function save($param, $id)
	{
		//        log_message('debug','code:'.$param['code'].';id:'.$id);
		$this->saveDB($this->database, $this->tbl, $param, $id);
	}

	public function delete($id)
	{
		$this->saveDB($this->database, $this->tbl, ['status' => 0], $id);
	}


	public function deleteMultiple($ids)
	{
		$this->deleteDB($this->database, $this->tbl, $ids, true);
	}

	public function deleteAll()
	{
		$this->deleteAllDB($this->database, $this->tbl);
	}

	public function getAllIds()
	{
		$ids = [];
		$all = $this->all();
		foreach ($all as $k => $v) {
			$ids[] = $v['id'];
		}
		return $ids;
	}

	public function teacher_calendar()
	{
		$this->load->model('Tenant_model');
		$this->load->model('Event_enrollment_item_model');

		$tenantNo = $this->getTenantNo();
		$tenantName = $this->Tenant_model->detail_no($tenantNo)['name'];

		$baseQuery = $this->Event_enrollment_item_model->activeQuery($tenantNo);

		if (!$baseQuery['has_record']) {
			return [];
		}

		$this->db = $this->load->database($tenantNo, true);
		$course_users = $this->db
			->from($this->table_prefix . $this->tbl)
			->where('mas_course_user.status', 1)
			->join('mas_event_course_user', 'mas_course_user.id = mas_event_course_user.course_user_id')
			->join('mas_event', 'mas_event_course_user.event_id = mas_event.id')
			->join('mas_event_timeslot', 'mas_event_course_user.event_id = mas_event_timeslot.event_id')
			// show all timeslots
			->join('(' . $baseQuery['compiled_select'] . ') item', 'mas_event_timeslot.id = item.event_timeslot_id', 'left')
			->join('mas_room', 'mas_event.room_id = mas_room.id')
			->group_start()
			->group_start()
			->where('mas_event_timeslot.holiday_skip IS NULL', null, false)
			->where('mas_course_user.mode != "period"', null, false)
			->group_end()
			->or_where('mas_course_user.mode = "period"', null, false)
			->group_end()
			->where_in('YEAR(FROM_UNIXTIME(mas_event_timeslot.startdate))', $this->threeYearsInterval(), false)
			->select('
                mas_room.name as room_name,
                mas_course_user.code as course_user_code, 
                mas_course_user.name, 
                mas_course_user.id as course_user_id, 
                mas_event_timeslot.event_id as event_id,
                mas_event_timeslot.starttime,
                mas_event_timeslot.endtime,
                item.*,
                item.id as item_id,
                mas_event_timeslot.startdate as date,
                mas_event_timeslot.id as event_timeslot_id
            ', false)
			->group_by('mas_event_timeslot.id')
			->order_by('mas_event_timeslot.id', 'asc')
			->get()
			->result_array();

//        log_message('debug', $this->db->last_query());

		$res = [];

		foreach ($course_users as $item) {
			$timeslotId = $item['event_timeslot_id'];

			// $txnStatus = $item['txn_status'];
			// $date = Carbon::createFromTimestamp($item['date'])->timezone('Asia/Hong_Kong')->add(13, 'hour')->format('Y-m-d H:i:s');
			// 'Y-m-d\TH:i:s\Z'
			$date = date('Y-m-d H:i:s', $item['date']);
			$checkinDatetime = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : '';

			$date = explode(' ', $date)[0];
			// use date to generate app calendar compatible key
			$key = date('Y-m-d H:i:s', (new DateTime($date, new DateTimeZone('Asia/Hong_Kong')))->getTimestamp());
			// ZuluString
			$keys = explode(' ', $key);

			$calendarDatetime = sprintf('%sT%sZ', $keys[0], $keys[1]);
			$key = sprintf('%sT%sZ', $keys[0], '00:00:00');

			// EnrollmentItemId
			$itemId = $item['item_id'];
			$values = [
				'item_id' => $itemId,
				'room_name' => sprintf('%s %s', $tenantName, $item['room_name'] ?? ''),
				'course_user_id' => $item['course_user_id'],
				'course_user_code' => $item['course_user_code'] ?? '',
				'title' => $item['name'] ?? '',
				'student_id' => $item['student_id'],
				'timeslot_id' => $timeslotId,
				'date' => $date,
				'type' => '上課記錄',
				'time' => sprintf('%s - %s', $item['starttime'], $item['endtime']),
				'checkin' => $checkinDatetime,
				'teacher_comment' => '',
				'taken_leave_datetime' => $item['taken_leave_datetime'] ?? "",
				'absent' => $item['absent'] ? 1 : 0,
				'makeup' => $item['txn_status'] == 'M' ? 1 : 0,
				'calendar_datetime' => $calendarDatetime,
				'enrolled' => $item['txn_status'] != null ? 1 : 0,
				'quota' => 0
			];

			$this->array_put($res, $key, $values);
		}

		return $res;
	}

	public function listing_students($timeslotId)
	{
		$tenantNo = $this->getTenantNo();
		$this->load->model('Event_enrollment_item_model');

		$baseQuery = $this->Event_enrollment_item_model->activeQuery($tenantNo, true);

		if (!$baseQuery['has_record']) {
			return [];
		}

		$this->db = $this->load->database($tenantNo, true);
		$course_users = $this->db
			->from('mas_course_user')
			->where('mas_course_user.status', 1)
			->join('mas_event_course_user', 'mas_course_user.id = mas_event_course_user.course_user_id')
			->join('mas_event_timeslot', 'mas_event_course_user.event_id = mas_event_timeslot.event_id')
			// show all timeslots
			->join('(' . $baseQuery['compiled_select'] . ') item', 'mas_event_timeslot.id = item.event_timeslot_id')
			->join('mas_student', 'item.student_id = mas_student.id')
			->group_start()
			->group_start()
			->where('mas_event_timeslot.holiday_skip IS NULL', null, false)
			->where('mas_course_user.mode != "period"', null, false)
			->group_end()
			->or_where('mas_course_user.mode = "period"', null, false)
			->group_end()
			->where('item.event_timeslot_id', $timeslotId)
			->where('item.id IN (' . $this->Event_enrollment_item_model->getLatestQueryOnTimeslot($timeslotId) . ')', null, false)
			->where_in('YEAR(FROM_UNIXTIME(mas_event_timeslot.startdate))', $this->threeYearsInterval(), false)
			->select('
                mas_course_user.name, 
                mas_course_user.id as course_user_id, 
                mas_event_timeslot.event_id as event_id,
                mas_event_timeslot.starttime,
                mas_event_timeslot.endtime,
                item.*,
                item.id as item_id,
                mas_student.chi_name as student_name,
                mas_event_timeslot.startdate as date,
                mas_event_timeslot.id as event_timeslot_id
            ', false)
			->order_by('mas_event_timeslot.id', 'asc')
			->get()
			->result_array();

//        log_message('debug', $this->db->last_query());

		$res = [];

		foreach ($course_users as $item) {
			$timeslotId = $item['event_timeslot_id'];

			// $txnStatus = $item['txn_status'];
			// $date = Carbon::createFromTimestamp($item['date'])->timezone('Asia/Hong_Kong')->add(13, 'hour')->format('Y-m-d H:i:s');
			// 'Y-m-d\TH:i:s\Z'
			$date = date('Y-m-d H:i:s', $item['date']);
			$checkinDatetime = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : '';

			$date = explode(' ', $date)[0];
			// use date to generate app calendar compatible key
			$key = date('Y-m-d H:i:s', (new DateTime($date, new DateTimeZone('Asia/Hong_Kong')))->getTimestamp());
			// ZuluString
			$keys = explode(' ', $key);

			$calendarDatetime = sprintf('%sT%sZ', $keys[0], $keys[1]);
			$key = sprintf('%sT%sZ', $keys[0], '00:00:00');

			// EnrollmentItemId
			$itemId = $item['item_id'];
			$values = [
				'item_id' => $itemId,
				'course_user_id' => $item['course_user_id'],
				'student_id' => $item['student_id'],
				'student_name' => $item['student_name'],
				'timeslot_id' => $timeslotId,
				'date' => $date,
				'type' => '上課記錄',
				'time' => sprintf('%s - %s', $item['starttime'], $item['endtime']),
				'title' => $item['name'] ?? '',
				'checkin' => $checkinDatetime,
				'teacher_comment' => '',
				'taken_leave_datetime' => $item['taken_leave_datetime'] ?? "",
				'absent' => $item['absent'] ? 1 : 0,
				'makeup' => $item['txn_status'] == 'M' ? 1 : 0,
				'calendar_datetime' => $calendarDatetime,
				'enrolled' => $item['txn_status'] != null ? 1 : 0,
				'quota' => 0
			];

			if ($values['absent'] == 0 && $values['makeup'] == 0 && $values['taken_leave_datetime'] == '') {
				$values['in_datetime'] = !empty($item['in_datetime']) ? date('H:i', $item['in_datetime']) : "";
				$values['out_datetime'] = !empty($item['out_datetime']) ? date('H:i', $item['out_datetime']) : "";
			} else {
				$values['in_datetime'] = "";
				$values['out_datetime'] = "";
			}
			if ($values['makeup'] == 1) {
				$this->Event_enrollment_item_model->setTenantNo($tenantNo);
				$nextItem = $this->Event_enrollment_item_model->detail_in_nextTimeslot($item['next_txn_id']);
				$values['makeup_date'] = date('Y-m-d', $nextItem['startdate']);
			} else {
				$values['makeup_date'] = "";
			}

			if ($values['absent'] == 0 && $values['makeup'] == 0 && $values['taken_leave_datetime'] == '' && $values['in_datetime'] == '' && $values['out_datetime'] == '') {
				$values['not_processed'] = 1;
			} else {
				$values['not_processed'] = 0;
			}
			$this->array_put($res, $key, $values);
		}

		return $res;
	}

	private function threeYearsInterval()
	{
		$currentYear = date('Y');
		$_currentYear = (int)$currentYear;
		$previousYear = $_currentYear - 1;
		$nextYear = $_currentYear + 1;

		return compact('currentYear', 'previousYear', 'nextYear');
	}

}
