<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Chat_model extends MY_Model
{

	public function create($params)
	{
		$this->load->model('Webinar_model', 'webinar');
		$webinar = $this->webinar->token_search($params['webinar']);
		$data = [
			'webinar_id' => $webinar['id'],
			'applicant_id' => $params['user_id'],
			'post_time' => $params['time'],
			'mode' => $params['mode'],
			'message' => $params['message'],
		];
		$this->db->set('created_at', 'NOW()', false);
		$this->db->set('updated_at', 'NOW()', false);
		$this->db->insert('chat_history', $data);
		return $this->all($webinar['id']);
	}

	public function all($webinar_id)
	{
		return $this->db->select('ch.id, ch.webinar_id, ch.applicant_id, a.full_name, ch.post_time, ch.mode, ch.message, ch.response')
			->from('chat_history ch')
			->join('applicant a', 'ch.applicant_id = a.id')
			->where('ch.webinar_id', $webinar_id)
			->order_by('post_time', 'ASC')
			->get()->result_array();
	}
}
