<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Applicant_model extends MY_Model
{

	public function token_search($access_token)
	{
		return $this->db->from('applicant')
			->where('access_token', $access_token)
			->get()->row_array();
	}

	public function create($params)
	{
		$data = [
			'user_id' => $params['user_id'],
			'application_date' => $params['date'],
			'webinar_id' => $params['webinar_id'],
			'access_token' => $params['access_token'],
			'full_name' => $params['full_name'],
			'email' => $params['email'],
			'location' => $params['location'],
		];
		$this->db->set('created_at', 'NOW()', false);
		$this->db->set('updated_at', 'NOW()', false);
		$this->db->insert('applicant', $data);
		return $this->db->insert_id();
	}

	public function purchased($session_id)
	{
		$this->load->model('Webinar_model', 'webinar');
		$applicant = $this->token_search($_SESSION['access_token']);
		$webinar = $this->webinar->detail($applicant['webinar_id']);
		$data = [
			'made_payment' => 1,
			'session_id' => $session_id,
		];
		$this->db->set('purchased_at', 'NOW()', false);
		$this->db->update('applicant', $data, ['id' => $applicant['id']]);
		$this->load->model('User_Model', 'user');
		$user = $this->user->searchUser($applicant['email']);
		if (! $user) {
			$user_id = $this->user->create([
				'email' => $applicant['email'],
				'full_name' => $applicant['full_name'],
			]);
		}
		else {
			$user_id = $user['id'];
		}
		$result = $this->db->select('MAX(order_no) AS max_order', false)
			->from('course_user')
			->get()
			->row_array();
		$num = explode('-', $result['max_order']);
		$new = $num[0] . '-' . sprintf('%03d', intval($num[1]) + 1);
		$data = [
			'course_id' => $webinar['course_id'],
			'user_id' => $user_id,
			'payment_type_id' => 4,
			'order_no' => $new,
			'progress' => 0,
			'created_by' => 0,
		];
		$this->db->set('create_time', 'UNIX_TIMESTAMP()', false);
		$this->db->insert('course_user', $data);
		$this->session->unset_userdata('access_token');
	}
}
