<?php

class MY_Model extends CI_Model
{
	public $pageisze;
	protected $database;
	protected $tbl;
	public $short;
	public $table;
	public $gender = ['女', '男'];
	public $status = [
		0 => '不啟用',
		1 => '啟用',
	];

	public function __construct()
	{
		parent::__construct();

		$lang = $this->session->userdata('lang');
		$this->lang->load('menu',$lang);
		$this->lang->load('users',$lang);
		$this->load->helper('language');

		$this->database = 'default';
		$this->table_prefix = '';
	}

	public function getnewdisplayorder($lang)
	{
		$this->db->where(['lang' => $lang, 'deleted' => 0]);
		$this->db->select_max('displayorder');
		return $this->db->get($this->tbl)->row()->displayorder + 1;
	}

	function inserts($arr_chi, $arr_eng)
	{
		$this->db->trans_start();
		$id_chi = $this->insert($arr_chi);
		$id_eng = $this->insert($arr_eng);
		$this->db->trans_complete();
		return array($id_chi, $id_eng);
	}

	function updates($id_chi, $arr_chi, $id_eng, $arr_eng)
	{
		$this->db->trans_start();
		$this->update($id_chi, $arr_chi);
		$this->update($id_eng, $arr_eng);
		$this->db->trans_complete();
	}

	public function build_datatables($draw, $total, $filtered, $data)
	{
		return [
			'draw' => $draw,
			'recordsTotal' => $total,
			'recordsFiltered' => $filtered,
			'data' => $data,
		];
	}

	public function getFromDB($database, $table, $fields, $start, $length, $orders, $search, $joins)
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		$db->select(implode(', ', $fields));
		$db->from($this->table_prefix . $table);
		foreach ($joins as $joinTbl => $condition) {
			$db->join($this->table_prefix . $joinTbl, $condition);
		}

		$db->or_like($search);
		$db->limit($length, $start);
		$db->order_by(implode(', ', $orders));
		return $db->get()->result_array();
	}

	public function getFromDBFilter($database, $table, $fields, $start, $length, $orders, $search, $joins = [], $keywordfieldname = '', $checkstatus = true)
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		$db->distinct();
//		log_message('debug','emptyfields?'.empty($fields));
		if (!empty($fields)) {
			$db->select(implode(', ', $fields));
		}
		if ($checkstatus) {
			$db->where([$this->short . '.status' => 1]);
		}

		$db->from($this->table_prefix . $table);

		if (count($joins) > 0) {
			foreach ($joins as $joinTbl => $condition) {
				$db->join($joinTbl, $condition);
			}
		}

		if (!empty($search) && !empty($keywordfieldname)) {
			//            log_message('debug','here');
			foreach ($search as $k => $v) {
				if ($v !== '') {
					if ($k === $keywordfieldname) {
						$db->like($search);
					}
					$db->like($search, 'none');
				}
			}
		}
//		order:cu.chi_firstc.name ASC
//		log_message('debug','order:'.implode(', ', $orders));
		$db->order_by(implode(', ', $orders));
		if ($start > -1) {
			$db->limit($length, $start);
		}
		$result = $db->get()->result_array();
//		log_message('debug','sql:'.$db->last_query());
		return $result;
	}

	public function getAll($database, $table, $fields = [], $where = null, $tableprefix = true)
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		if (!empty($fields)) {
			$db->select(implode(', ', $fields));
		}
		$tbl = $tableprefix ? $this->table_prefix . $table : $table;
		$db->from($tbl);
		$db->order_by('id ASC');
		if (!is_null($where)) {
			$db->where($where);
		}
		return $db->get()->result_array();
	}

	public function getAllIn($database, $table, $fields = [], $whereField = '', $whereValue = [], $tableprefix = true, $where = [])
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);
		if (!empty($fields)) {
			$db->select(implode(', ', $fields));
		}
		$tbl = $tableprefix ? $this->table_prefix . $table : $table;
		$db->from($tbl);
		$db->order_by('id ASC');
		//        log_message('debug','empty where?'.empty($where));
		if (!empty($where)) {
			$db->where($where);
		}
		if (!empty($whereValue)) {
			if (empty($whereField)) {
				$whereField = 'id';
			}
			$db->where_in($whereField, $whereValue);
		}
		$data = $db->get()->result_array();
//                log_message('debug',$db->last_query());
		return $data;
	}

	public function getOne($database, $table, $fields = [], $id = '', $idxname = 'id', $tableprefix = TRUE)
	{
//                log_message('debug','database:'.$database);//default
		return $this->getOneRow($database, $table, $fields, [$idxname => $id], $tableprefix);
	}

	public function getOneRow($database, $table, $fields = [], $where = [], $tableprefix = TRUE)
	{
		if ($database === "") {
			return [];
		}
		$db = $this->load->database($database, TRUE);

		if (!empty($fields)) {
			//            log_message('debug','fields:'.implode(',',$fields));
			$db->select(implode(', ', $fields));
		}
		$tbl = ($tableprefix) ? $this->table_prefix . $table : $table;
		//        log_message('debug','tbl:'.$tbl.';where:'.implode(',',$where));
		$db->from($tbl);
		$db->where($where);
		$row = $db->get()->row_array();
//                log_message('debug','sql:'.$db->last_query());
		return $row;
	}

	public function insertDB($database, $table, $param, $batch = false)
	{
		if ($database === "") {
			$database = $this->database;
		}
		$db = $this->load->database($database, TRUE);
		$db->set('create_time', 'UNIX_TIMESTAMP()', FALSE);
		$db->set('created_by', $this->session->userdata('user_id'));
		$db->set('update_time', 'UNIX_TIMESTAMP()', FALSE);
		$db->set('updated_by', $this->session->userdata('user_id'));
		$batch ? $db->insert_batch($this->table_prefix . $table, $param) : $db->insert($this->table_prefix . $table, $param);
		return $batch ? [] : $db->insert_id();
	}

	public function saveWhereDB($database, $table, $param, $where)
	{
		if ($database === "") {
			return 0;
		}
		$db = $this->load->database($database, TRUE);
		$db->set('update_time', 'UNIX_TIMESTAMP()', FALSE);
		$db->set('updated_by', $this->session->userdata('user_id'));
		$db->where($where);
		$db->update($this->table_prefix . $table, $param);
		return $db->affected_rows();
	}

	public function deletebulk($ids, $id = 'id', $table = '')
	{
		if (empty($table)) {
			$this->saveWhereInDB($this->database, $this->tbl, ['status' => 0], $id, $ids);
		} else {
			$this->saveWhereInDB($this->database, $table, ['status' => 0], $id, $ids);
		}
	}

	public function saveWhereInDB($database, $table, $param, $where_in_field, $where_in_values)
	{
		if ($database === "") {
			return 0;
		}
		$db = $this->load->database($database, TRUE);
		$db->set('update_time', 'UNIX_TIMESTAMP()', FALSE);
		$db->set('updated_by', $this->session->userdata('user_id'));
		$db->where_in($where_in_field, $where_in_values);
		$db->update($this->table_prefix . $table, $param);
		return $db->affected_rows();
	}

	public function saveDB($database, $table, $param, $id, $idxname = 'id')
	{
		if ($database === "") {
			return 0;
		}
		$db = $this->load->database($database, TRUE);
		$db->set('update_time', 'UNIX_TIMESTAMP()', FALSE);
		$db->set('updated_by', $this->session->userdata('user_id'));
		$db->where($idxname, $id);
		$db->update($this->table_prefix . $table, $param);
		return $db->affected_rows();
	}

	public function deleteDB($database, $table, $id, $multi = false, $idfieldname = 'id')
	{
		if ($database === "") {
			return 0;
		}
		$db = $this->load->database($database, TRUE);
		$multi ? $db->where_in($idfieldname, $id) : $db->where($idfieldname, $id);
		$db->delete($this->table_prefix . $table);
		return $db->affected_rows();
	}

	public function deleteRelatedDB($database, $tables, $idfieldnames, $ids)
	{
		if ($database === "") {
			return false;
		}
		$db = $this->load->database($database, TRUE);
		$db->trans_start();
		$db->trans_strict('TRUE');
		foreach ($idfieldnames as $k => $idfieldname) {
			$db->where_in($idfieldname, $ids);
			$db->delete($this->table_prefix . $tables[$k]);
		}
		$db->trans_complete();

		if ($db->trans_status() === FALSE) {
			$db->trans_rollback();
			return false;
		} else {
			$db->trans_commit();
			return true;
		}
	}

	public function deleteAllDB($database, $table)
	{
		if ($database === "") {
			return false;
		}
		$db = $this->load->database($database, TRUE);
		$db->delete($this->table_prefix . $table);
	}

	public function queryExecute($database, $sql, $return = false)
	{
		if ($database === "") {
			return false;
		}
		$db = $this->load->database($database, TRUE);
		$db->query($sql);
		if ($return) {
			return $db->query($sql);
		}
		return null;
	}

	protected function throw_exception($msg, $db = null)
	{
		if ($db) $this->db = $db;

		$this->db->trans_rollback();
		throw new Exception($msg);
	}

}

abstract class RuleTrigger
{
	const subscribe = 'subscribe';
	const unsubscribe = 'unsubscribe';
	const campaign_sent = 'campaign_sent';
	const campaign_sending = 'campaign_sending';
}

abstract class RuleAction
{
	const notify = 'notify';
	const webhook = 'webhook';
	const unsub_from_list = 'unsub_from_list';
}
