<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller
{
	public $data;
	function __construct()
	{
		parent::__construct();
		if(!$this->session->has_userdata('lang')){
			$this->session->set_userdata(array('lang'=>'chi','langcolor'=>'#80a6d1'));
		}
		$lang = $this->session->userdata('lang');
		$this->lang->load('menu',$lang);
		$this->lang->load('users',$lang);
		$this->lang->load('landing',$lang);
		$this->load->model('Settings_Model', 'settings_model');

		$this->data=array();
		//load setting value
		$this->data['lang']=$lang;
		$this->data['settings'] = new stdClass;
		foreach ($this->settings_model->get_lang($lang) as $setting) {
			// echo "get setting";
			$this->data['settings']->{$setting->key} = $setting->value;
		}
		//end load setting value
		//load main menu
		$this->load->model('Landingmain_Model', 'landingmain_model');
		$this->data['landingmain'] = $this->landingmain_model->get(0);
//		log_message('debug','empty landingmain?'.empty($this->data['landingmain']));
		//end load main menu
		//load sub menu
		$this->load->model('Landingsubmenu_Model', 'landingsubmenu_model');
		$this->data['landingsubmenu'] = $this->landingsubmenu_model->get(0);
		//end load submenu
		//load content menu
		$this->load->model('Landingcontentmultistyle_Model', 'landingcontentmultistyle_model');
		$this->data['landingcontentmultistylemenu'] = $this->landingcontentmultistyle_model->get();
		//end　load content menu


		$this->load->model('Purpose_Model');
		$this->load->model('Members_Model');
		$this->load->model('works_Model');
		$this->load->model('Contactus_Model');
		$this->data['purpose']=$this->Purpose_Model->get();
		$this->data['members']=$this->Members_Model->get();
		$this->data['works']=$this->works_Model->get();
		$this->data['contactus']=$this->Contactus_Model->get();
		$this->load->model('Learningdifficulties_Model');
		$this->data['learningdifficulties']=$this->Learningdifficulties_Model->get();

		$this->load->model('Identifysld_Model');
		$this->data['identifysld']=$this->Identifysld_Model->get();
		$this->load->model('Advicesld_Model');
		$this->data['advicesld']=$this->Advicesld_Model->get();
		
		$this->load->model('Supports_Model');
		$this->data['supports']=$this->Supports_Model->get();
		$this->load->model('Lessontier_Model');
		$this->data['lessontier']=$this->Lessontier_Model->get();
		$this->load->model('Lessonoverview_Model');
		$this->data['lessonoverview']=$this->Lessonoverview_Model->get();
		$this->load->model('Lessoneffect_Model');
		$this->data['lessoneffect']=$this->Lessoneffect_Model->get();
		$this->load->model('Lessonpub_Model');
		$this->data['lessonpub']=$this->Lessonpub_Model->get();


		$this->load->model('Screening_Model');
		$this->data['screening']=$this->Screening_Model->get();
		$this->load->model('Assessment_Model');
		$this->data['assessment']=$this->Assessment_Model->get();
		$this->load->model('Intervention_Model');
		$this->data['intervention']=$this->Intervention_Model->get();
		$this->load->model('Onlineassessment_Model');
		$this->data['onlineassessment']=$this->Onlineassessment_Model->get();
		$this->load->model('Registeredusers_Model');
		$this->data['registeredusers']=$this->Registeredusers_Model->get();
		$this->load->model('Downloadarea_Model');
		$this->data['downloadarea']=$this->Downloadarea_Model->get();
		
		$this->load->model('Downloadcategories_Model');
		$this->data['downloadcategories'] = $this->Downloadcategories_Model->get_lang($lang);

		$this->load->model('Downloaditems_Model');
		$this->data['downloaditems'] = $this->Downloaditems_Model->get_lang($lang,true);

		$this->load->model('Usefulsites_Model');
		$this->data['usefulsites']=$this->Usefulsites_Model->get();
		
	}
}
