<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MY_BackendController extends CI_Controller
{
	protected $viewParams = [
		'breadcrumb' => [],
		'csses' => [],
		'jses' => [],
		'scripts' => [],
	];

	public function __construct()
	{
		parent::__construct();

		if(!$this->session->has_userdata('lang')){
			$this->session->set_userdata(array('lang'=>'chi','langcolor'=>'#80a6d1'));
		}
		$lang = $this->session->userdata('lang');
		$this->lang->load('menu',$lang);
		$this->lang->load('users',$lang);

		$this->load->database();
		$this->load->helper('language');
		$this->load->helper('common_helper');
		$this->load->library('session');
		$this->load->model('Security','security_model');
		$this->load->model('Settings_Model','settings_model');
//		$this->data=array();

		$this->viewParams['lang']=$lang;
		$this->viewParams['settings']=$this->settings_model->get();
		$this->viewParams['hash'] = hash('md5', uniqid('', true));
		$this->viewParams['breadcrumb'][] = [
			'name' => '主頁',
			'url' => base_url('at-admin/dashboard'),
		];

		//check user have login or not
		$this->security_model->admin($this->session->userdata('session_id'),$this->session->userdata('user_id'),$this->session->userdata('username'));
		//end check user have login or not
	}
}
