<?php

class MY_ApiController extends CI_Controller
{
    protected $json;

    public function __construct()
    {
        parent::__construct();
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        //        $this->load->database();
		$this->load->helper('common_helper');
        $this->json = json_decode($this->security->xss_clean($this->input->raw_input_stream), true);
    }

    protected function startsWith($haystack, $needle)
    {
        $length = strlen($needle);
        return substr($haystack, 0, $length) === $needle;
    }

    protected function endsWith($haystack, $needle)
    {
        $length = strlen($needle);
        if (!$length) {
            return true;
        }
        return substr($haystack, -$length) === $needle;
    }

    protected function respond($data = [], $statusCode = 200)
    {
        $this->output->set_status_header($statusCode);
        return json_encode($statusCode == 200 ? ['error' => 0, 'success' => true, 'data' => $data] : ['error' => 1, 'success' => false, 'data' => $data]);
    }

    protected function is_get()
    {
        $this->input->method(false) == 'get' or exit(json_encode([]));
    }

    protected function is_post()
    {
        $this->input->method(false) == 'post' or exit(json_encode([]));
    }

    protected function is_json()
    {
        count($this->json) > 0 or exit(json_encode([]));
    }

    protected function correctImageOrientation($filename)
    {
        $f = new SplFileObject($filename);
        $ext = $f->getExtension();

        if (function_exists('exif_read_data')) {
            $exif = exif_read_data($filename);
            if ($exif && isset($exif['Orientation'])) {
                $orientation = $exif['Orientation'];
                if ($orientation != 1) {

                    $img = imagecreatefromjpeg($filename);
                    $deg = 0;
                    switch ($orientation) {
                        case 3:
                            $deg = 180;
                            break;
                        case 6:
                            $deg = 270;
                            break;
                        case 8:
                            $deg = 90;
                            break;
                    }
                    if ($deg) {
                        $img = imagerotate($img, $deg, 0);
                    }
                    // then rewrite the rotated image back to the disk as $filename 
                    imagejpeg($img, $filename, 95);
                } // if there is some rotation necessary
            } // if have the exif orientation info
        } // if function exists      
    }
}
