<?php

class Webinar extends MY_BackendController
{

//	public $layout = 'full';
//	public $module = 'webinar/index';
//	public $model = 'users';

	public function __construct()
	{
		parent::__construct();
//		$this->data['page'] = 'webinarmanagement';
		$this->load->model('Webinar_model', 'webinar');
	}

	public function index()
	{
//    	print_r($this->data['settings'])
		$this->viewParams['breadcrumb'][] = [
			'name' => '網上講座管理',
			'url' => '#',
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
		]));
	}

	public function add()
	{
		$this->viewParams['breadcrumb'][] = [
			'name' => '網上講座管理',
			'url' => base_url('at-admin/webinar'),
		];
		$this->viewParams['breadcrumb'][] = [
			'name' => '新增網上講座',
			'url' => '#',
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
		]));
	}

	public function insert()
	{
		$request = $this->input->post();
		$this->webinar->insert($request);
		header('location: ' . base_url('at-admin/webinar'));
	}

	public function edit()
	{
		$webinar = $this->webinar->detail($this->input->post('id'));
		if (("" . $webinar['vimeo_id']) === "")
		{
			$webinar['vimeo_id'] = '617580436';
		}
		$this->load->model('Video_Model', 'video');
		$videos = $this->video->all(['id', 'name', 'out_link']);
		foreach ($videos as $idx => $video) {
			$videos[$idx]['vimeo_id'] = str_replace('https://vimeo.com/', '', $video['out_link']);
		}
		$this->load->model('Course_Model', 'course');
		$courses = $this->course->all();
		$this->viewParams['breadcrumb'][] = [
			'name' => '網上講座管理',
			'url' => base_url('at-admin/webinar'),
		];
		$this->viewParams['breadcrumb'][] = [
			'name' => '修改網上講座',
			'url' => '#',
		];
		$this->viewParams['scripts'][] = "let vimeo_id = '" . $webinar['vimeo_id'] . "';";
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => 'https://player.vimeo.com/api/player.js'
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
			'webinar' => $webinar,
			'videos' => $videos,
			'courses' => $courses,
		]));
	}

	public function update_webinar()
	{
		$request = $this->input->post();
		$this->Webinar_model->update_webinar($request);
		$this->load->view('at-admin/webinar/dummy', [
			'id' => $request['id'],
		]);
	}

	public function update_course()
	{
		$request = $this->input->post();
		if (count($_FILES) > 0) {
			$request['upload'] = $_FILES['featured_photo'];
		}
		else {
			$request['upload'] = [];
		}
		$this->Webinar_model->update_course($request);
		$this->load->view('at-admin/webinar/dummy', [
			'id' => $request['id'],
		]);
	}

	public function delete()
	{

	}
}
