<?php

use Vimeo\Vimeo;

class Video extends MY_BackendController
{

//	public $layout = 'full';
//	public $module = 'video/index';
//	public $model = 'users';

	public function __construct()
	{
		parent::__construct();
//		$this->data['page'] = 'videomanagement';
		$this->load->model('Video_Model', 'video');
	}

	public function index()
	{
//    	print_r($this->data['settings'])
		$this->viewParams['breadcrumb'][] = [
			'name' => '影片管理',
			'url' => '#',
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
		]));
	}

	public function add()
	{

		$this->load->view('at-admin/video/add', $this->data);
	}

	public function chunktest()
	{
		$source = FCPATH . "assets/uploads/video/25D42E7B-A733-42F1-AD65-EBCB56088ACC.mp4";
		$orig_file_size = filesize($source);
		$destination = FCPATH . "assets/uploads/chunks/test.mp4";

		$chunk_size = 256; // chunk in bytes
		$upload_start = 0;

		$handle = fopen($source, "rb");

		$fp = fopen($destination, 'w');

		while ($upload_start < $orig_file_size) {

			$contents = fread($handle, $chunk_size);
			fwrite($fp, $contents);

			$upload_start += strlen($contents);
			fseek($handle, $upload_start);
		}

		fclose($handle);
		fclose($fp);

		echo "File uploaded successfully.";
	}


	public function insert()
	{
		$request = $this->input->post();
		$ret = $this->uploadhandler();
		if (!empty($ret)) {
			$filename = explode('_', $ret)[0];
			$uri = explode('_', $ret)[1];
			$data = [
				'name' => $request['name'],
				'duration' => $request['duration'],
				'unit_id' => $request['unit_id'],
				'filename' => $filename,
				'in_link' => $uri
			];
			$this->video->insert($data);
//			$this->session->set_flashdata('msg','video added');
			redirect('at-admin/video');
//			header('location: /admin/videomanagement');
		}
	}

	private function uploadhandler()
	{
		if (empty($_FILES["file"])) {
			return '';
		}
		$allowedExts = array("jpg", "jpeg", "gif", "png", "mp3", "mp4", "wma");
		$extension = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);

		if ((($_FILES["file"]["type"] == "video/mp4")
				|| ($_FILES["file"]["type"] == "audio/mp3")
				|| ($_FILES["file"]["type"] == "audio/wma")
				|| ($_FILES["file"]["type"] == "image/pjpeg")
				|| ($_FILES["file"]["type"] == "image/gif")
				|| ($_FILES["file"]["type"] == "image/jpeg"))
			&& in_array($extension, $allowedExts)) {
			if ($_FILES["file"]["error"] > 0) {
				$msg = "Return Code: " . $_FILES["file"]["error"] . "<br />";
			} else {
				$filename = GUID() . '.' . $extension;
				$filepath = FCPATH . "assets/uploads/video/$filename";
//				log_message('debug','filepath:'.$filepath);
				move_uploaded_file($_FILES["file"]["tmp_name"], $filepath);

				$videofile = $filepath;

				$client = new Vimeo($this->config->item('client_id'), $this->config->item('client_secret'), $this->config->item('access_token'));
//            Log::channel('debug')->debug('filename:'.$file_name);

				$uri = $client->upload($videofile, array(
					"name" => $this->session->userdata('user_id') . '_' . $filename . '_' . $_FILES['file']['name'],
					"description" => ''
				));


				return $filename . '_' . $uri;
			}
		} else {
			$msg = "Invalid file";
		}
		return $msg;
	}

	public function edit()
	{
		$video = $this->video->detail($this->input->post('id'));
		$this->load->model('Unit_Model', 'unit');
		$course_id = $this->unit->getcourseByUnit($video['unit_id'])['id'];
		$this->viewParams['breadcrumb'][] = [
			'name' => '影片管理',
			'url' => base_url('at-admin/video'),
		];
		$this->viewParams['breadcrumb'][] = [
			'name' => '修改影片',
			'url' => '#',
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
			'video' => $video,
			'course_id' => $course_id,
		]));
	}

	public function save()
	{
		$request = $this->input->post();
		$ret = $this->uploadhandler();
		$data = [
			'name' => $request['name'],
			'duration' => $request['duration'],
			'unit_id' => $request['unit_id'],
		];
		if (!empty($ret)) {
			$filename = explode('_', $ret)[0];
			$uri = explode('_', $ret)[1];
			$data = array_merge(['filename' => $filename, 'in_link' => $uri], $data);
		}
		$this->Video_model->save($data, $request['id']);
		header('location: /admin/videomanagement');
	}

	public function delete()
	{

	}
}
