<?php

class Notemanagement extends MY_BackendController
{

	public $layout = 'full';
	public $module = 'note/index';
	public $model = 'users';

	public function __construct()
	{
		parent::__construct();
		$this->data['page'] = 'notemanagement';
		$this->load->model('Note_Model','Note_model');
	}

	public function index()
	{
//    	print_r($this->data['settings'])
		$this->load->view('at-admin/' . $this->module, $this->data);
	}

	public function add()
	{

		$this->load->view('at-admin/note/add', $this->data);
	}

	public function insert()
	{
		$request = $this->input->post();
		$filename = $this->uploadhandler();
		$data = [
			'title'=>$request['title'],
			'unit_id' => $request['unit_id'],
			'filename' => $filename
		];
		$this->Note_model->insert($data);
		header('location: /admin/notemanagement');
	}

	private function uploadhandler()
	{
		if (empty($_FILES["file"])) {
			return '';
		}
		$allowedExts = array("jpg", "jpeg", "gif", "png", "mp3", "mp4", "wma","pdf");
		$extension = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);

		if ((($_FILES["file"]["type"] == "video/mp4")
				|| ($_FILES["file"]["type"] == "audio/mp3")
				|| ($_FILES["file"]["type"] == "audio/wma")
				|| ($_FILES["file"]["type"] == "image/pjpeg")
				|| ($_FILES["file"]["type"] == "image/gif")
				|| ($_FILES["file"]["type"] == "image/jpeg") || ($_FILES["file"]["type"] == "application/pdf"))
			&& in_array($extension, $allowedExts)) {
			if ($_FILES["file"]["error"] > 0) {
				$msg = "Return Code: " . $_FILES["file"]["error"] . "<br />";
			} else {
//				$msg = "Upload: " . $_FILES["file"]["name"] . "<br />";
//				$msg .= "Type: " . $_FILES["file"]["type"] . "<br />";
//				$msg .= "Size: " . ($_FILES["file"]["size"] / 1024) . " Kb<br />";
//				$msg .= "Temp file: " . $_FILES["file"]["tmp_name"] . "<br />";
				$filename = GUID() . '.' . $extension;
				$filepath = FCPATH . "assets/uploads/note/$filename";
//				log_message('debug','filepath:'.$filepath);
				move_uploaded_file($_FILES["file"]["tmp_name"], $filepath);
				return $filename;
			}
		} else {
			$msg = "Invalid file";
		}
		return $msg;
	}

	public function edit()
	{
		$this->data['item'] = $this->Note_model->detail($this->input->post('id'));
		$this->load->model('Unit_Model','unit_model');
		$this->data['course_id'] = $this->unit_model->getcourseByUnit($this->data['item']['unit_id'])['id'];
		$this->load->view('at-admin/note/edit', $this->data);
	}

	public function save()
	{
		$request = $this->input->post();
		$filename = $this->uploadhandler();
		$data = [
			'title'=>$request['title'],
			'unit_id' => $request['unit_id'],
		];
		if (!empty($filename)) {
			$data = array_merge(['filename' => $filename], $data);
		}
		$this->Note_model->save($data, $request['id']);
		header('location: /admin/notemanagement');
	}

	public function delete()
	{

	}
}
