<?php

class Media extends MY_BackendController {

//    public $layout = 'full';
//    public $module = 'course/index';
//    public $model = 'users';

    public function __construct()
    {
        parent::__construct();
//        $this->data['page']='coursemanagement';
        $this->load->model('Media_model','media');
		$this->load->model('Security');
    }

    public function index() {
//    	print_r($this->data['settings'])
//        $this->load->view('at-admin/'.$this->module, $this->data);
		$this->viewParams['breadcrumb'][] = [
			'name' => '媒體管理',
			'url' => '#',
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
		]));
    }

    public function add()
	{
		$this->viewParams['breadcrumb'][] = [
			'name' => '媒體管理',
			'url' => base_url('at-admin/media'),
		];
		$this->viewParams['breadcrumb'][] = [
			'name' => '加入媒體',
			'url' => '#',
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
		]));
	}

	public function insert()
	{
		$request = $this->input->post();
		list($uuid, $ext) = explode(".", $request['media_file']);
		$data = [
			'title' => $request['title'],
			'uuid' => $uuid,
			'media_type' => $request['media_type'],
			'filename' => $request['media_file'],
			'status' => 1,
		];
		$this->media->insert($data);
		header('location: ' . base_url('at-admin/media'));
	}

	public function edit($id = 0){
		$this->viewParams['breadcrumb'][] = [
			'name' => '媒體管理',
			'url' => base_url('at-admin/media'),
		];
		$this->viewParams['breadcrumb'][] = [
			'name' => '修改媒體',
			'url' => '#',
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
			'media' => $this->media->detail($id),
		]));
	}

	public function save()
	{
		$request = $this->input->post();
		$data = [
			'title' => $request['title'],
		];
		if ($request['media_file'] != '') {
			list($uuid, $ext) = explode(".", $request['media_file']);
			$data = [
				'uuid' => $uuid,
				'media_type' => $request['media_type'],
				'filename' => $request['media_file'],
			];
		}
		$this->media->save($data, $request['id']);
		header('location: ' . base_url('at-admin/media'));
	}

	public function delete(){
		$this->Course_model->delete($this->input->post('id'));
		header('location: /admin/coursemanagement');
	}
}
