<?php

class Emarketingmanagement extends MY_BackendController {

    public $layout = 'full';
    public $module = 'emarketing/index';
    public $model = 'users';

    public function __construct()
    {
        parent::__construct();
        $this->data['page']='emarketingmanagement';
        $this->load->model('Emarketing_Model','Emarketing_model');
    }

    public function campaigns() {
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='campaigns';
        $this->load->view('at-admin/emarketing/campaigns/index', $this->data);
    }

    public function addcampaign(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='campaigns';
		$this->data['templates'] = $this->Emarketing_model->alltemplates();
		$this->data['apps']=$this->Emarketing_model->getapps();
		$this->data['templateId'] = $this->input->get('templateId');
		$this->load->view('at-admin/emarketing/campaigns/add', $this->data);
	}

	public function insertcampaign()
	{
		$request = $this->input->post();
		$data = [
			'from_name' => $request['from_name'],
			'from_email' => $request['from_email'],
			'reply_to' => $request['reply_to'],
			'title' => $request['title'],
			'plain_text' => $request['plain_text'],
			'html_text' => $request['html_text'],
		];
		$this->Emarketing_model->insert($data,'campaigns');
		redirect('/admin/emarketingmanagement/campaigns');
	}

	public function editcampaign(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='campaigns';
		$this->data['templates'] = $this->Emarketing_model->alltemplates();
		$this->data['apps']=$this->Emarketing_model->getapps();
		$this->data['item'] = $this->Emarketing_model->detail($this->input->post('id'),'campaigns');
		$this->load->view('at-admin/emarketing/campaigns/edit', $this->data);
	}

	public function savecampaign()
	{
		$request = $this->input->post();
		$data = [
			'from_name' => $request['from_name'],
			'from_email' => $request['from_email'],
			'reply_to' => $request['reply_to'],
			'title' => $request['title'],
			'plain_text' => $request['plain_text'],
			'html_text' => $request['html_text'],
		];
		$this->Emarketing_model->save($data,$request['id'],'campaigns');
		redirect('/admin/emarketingmanagement/campaigns');
	}

	public function templates() {
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='templates';
		$this->load->view('at-admin/emarketing/templates/index', $this->data);
	}

	public function addtemplate(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='templates';
		$this->load->view('at-admin/emarketing/templates/add', $this->data);
	}

	public function inserttemplate()
	{
		$request = $this->input->post();
		$data = [
			'template_name' => $request['template_name'],
			'plain_text' => $request['plain_text'],
			'html_text' => $request['html_text'],
		];
		$this->Emarketing_model->insert($data,'template');
		redirect('/admin/emarketingmanagement/templates');
	}

	public function edittemplate(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='templates';
		$this->data['item'] = $this->Emarketing_model->detail($this->input->post('id'),'template');
		$this->load->view('at-admin/emarketing/templates/edit', $this->data);
	}

	public function savetemplate()
	{
		$request = $this->input->post();
		$data = [
			'template_name' => $request['template_name'],
			'plain_text' => $request['plain_text'],
			'html_text' => $request['html_text'],
		];
		$this->Emarketing_model->save($data,$request['id'],'template');
		redirect('/admin/emarketingmanagement/templates');
	}

	public function subscriptions() {
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='subscriptions';
		$this->load->view('at-admin/emarketing/subscriptions/index', $this->data);
	}

	public function addsubscription(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='subscriptions';
		$this->load->view('at-admin/emarketing/subscriptions/add', $this->data);
	}

	public function insertsubscription()
	{
		$request = $this->input->post();
		$data = [
			'name' => $request['name'],
			'email' => $request['email']
		];
		$this->Emarketing_model->insert($data,'subscribers');
		redirect('/admin/emarketingmanagement/subscriptions');
	}

	public function editsubscription(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='subscriptions';
		$this->data['item'] = $this->Emarketing_model->detail($this->input->post('id'),'subscribers');
		$this->load->view('at-admin/emarketing/subscriptions/edit', $this->data);
	}

	public function savesubscription()
	{
		$request = $this->input->post();
		$data = [
			'name' => $request['name'],
			'email' => $request['email']
		];
		$this->Emarketing_model->save($data,$request['id'],'subscribers');
		redirect('/admin/emarketingmanagement/subscriptions');
	}

	public function blacklist() {
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='blacklist';
		$this->load->view('at-admin/emarketing/blacklist/index', $this->data);
	}

	public function addblacklist(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='blacklist';
		$this->load->view('at-admin/emarketing/blacklist/add', $this->data);
	}

	public function insertblacklist()
	{
		$request = $this->input->post();
		$data = [
			'email' => $request['email']
		];
		$this->Emarketing_model->insert($data,'suppression_list');
		redirect('/admin/emarketingmanagement/blacklist');
	}

	public function rules() {
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='rules';
		$this->load->view('at-admin/emarketing/rules/index', $this->data);
	}

	public function addrule(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='rules';
		$this->data['triggers'] = array(lang('on_subscribe')=>RuleTrigger::subscribe,lang('on_unsubscribe')=>RuleTrigger::unsubscribe,lang('on_campaign_sent')=>RuleTrigger::campaign_sent,lang('when_campaign_starts_sending')=>RuleTrigger::campaign_sending);
		$this->data['actions'] = array(lang('trigger').lang('webhook')=>RuleAction::webhook,lang('send').lang('email').lang('notification')=>RuleAction::notify,lang('unsubscribe')=>RuleAction::unsub_from_list);
		$this->data['subscriptionlists'] = $this->Emarketing_model->getsubscriptionlists();
		$this->load->view('at-admin/emarketing/rules/add', $this->data);
	}

	public function insertrule()
	{
		$request = $this->input->post();
		$data = [
			'trigger' => $request['trigger'],
			'action' => $request['action'],
			'endpoint' => $request['endpoint'],
			'notification_email' => $request['notification_email'],
			'unsubscribe_list_id' => $request['unsubscribe_list_id'],
			'list' => $request['list'],
		];
		$this->Emarketing_model->insert($data,'rules');
		redirect('/admin/emarketingmanagement/rules');
	}

	public function editrule(){
		$this->data['mainpage']='emarketingmanagement';
		$this->data['subpage']='rules';
		$this->data['triggers'] = array(lang('on_subscribe')=>RuleTrigger::subscribe,lang('on_unsubscribe')=>RuleTrigger::unsubscribe,lang('on_campaign_sent')=>RuleTrigger::campaign_sent,lang('when_campaign_starts_sending')=>RuleTrigger::campaign_sending);
		$this->data['actions'] = array(lang('trigger').lang('webhook')=>RuleAction::webhook,lang('send').lang('email').lang('notification')=>RuleAction::notify,lang('unsubscribe')=>RuleAction::unsub_from_list);
		$this->data['subscriptionlists'] = $this->Emarketing_model->getsubscriptionlists();
		$this->data['item'] = $this->Emarketing_model->detail($this->input->post('id'),'rules');
		$this->load->view('at-admin/emarketing/rules/edit', $this->data);
	}

	public function saverule()
	{
		$request = $this->input->post();
		$data = [
			'trigger' => $request['trigger'],
			'action' => $request['action'],
			'endpoint' => $request['endpoint'],
			'notification_email' => $request['notification_email'],
			'unsubscribe_list_id' => $request['unsubscribe_list_id'],
			'list' => $request['list'],
		];
		$this->Emarketing_model->save($data,$request['id'],'rules');
		redirect('/admin/emarketingmanagement/rules');
	}

}
