<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Email extends MY_AdminController
{

	public function __construct()
	{
		parent::__construct();
		if (! $this->session->has_userdata('username')) {
			redirect ('at-admin/login');
		}
		$this->load->model('Email_model', 'email');
	}

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		$this->viewParams['breadcrumb'][] = [
			'name' => '推廣電郵管理',
			'url' => '#',
		];
		$this->viewParams['csses'][] = base_url('assets/css/dataTables.bootstrap.css');
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/datatable/jquery.dataTables.min.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/datatable/ZeroClipboard.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/datatable/dataTables.tableTools.min.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/datatable/dataTables.bootstrap.min.js'),
		];
		$this->viewParams['scripts'][] = 'var new_email_url = \'' . base_url('at-admin/email/add') . '\';';
		$this->viewParams['scripts'][] = 'var delete_email_url = \'' . base_url('at-admin/email/delete') . '\';';
		$data = [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
			'data' => $this->email->getAllEmails(),
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, $data));
	}

	public function add()
	{
		if ($this->input->post()) {
			$request = $this->input->post();
			$errno = $this->email->create($request);
			$this->viewParams['errno'] = $errno;
			if ($errno == 0) {
				$this->viewParams['alert_message'] = "已成功加入推廣電郵";
			}
			else {
				$this->load->helper('constant');
				$errMsg = getAllErrorCode();
				$this->viewParams['alert_message'] = $errMsg[$errno];
			}
		}
		$this->viewParams['breadcrumb'][] = [
			'name' => '推廣電郵管理',
			'url' => base_url('at-admin/email'),
		];
		$this->viewParams['breadcrumb'][] = [
			'name' => '新增推廣電郵',
			'url' => '#',
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/jquery.hotkeys.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/prettify.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/bootstrap-wysiwyg.js'),
		];
//		$this->load->model('Landing_model', 'landing');
		$data = [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
//			'landings' => $this->landing->all(),
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, $data));
	}

	public function edit()
	{
		if ($this->input->post()) {
			$request = $this->input->post();
			$errno = $this->email->modify($request);
			$this->viewParams['errno'] = $errno;
			if ($errno == 0) {
				$this->viewParams['alert_message'] = "已成功更新推廣電郵";
			}
			else {
				$this->load->helper('constant');
				$errMsg = getAllErrorCode();
				$this->viewParams['alert_message'] = $errMsg[$errno];
			}
		}
		$id = $this->uri->segment(4);
		$this->viewParams['breadcrumb'][] = [
			'name' => '推廣電郵管理',
			'url' => base_url('at-admin/email'),
		];
		$this->viewParams['breadcrumb'][] = [
			'name' => '修改推廣電郵',
			'url' => '#',
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/jquery.hotkeys.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/prettify.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/bootstrap-wysiwyg.js'),
		];
//		$this->load->model('Landing_model', 'landing');
		$data = [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
			'email' => $this->email->one($id),
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, $data));
	}

	public function sent()
	{
		if ($this->input->post()) {
			$request = $this->input->post();
			$m = $this->email->one($request['id']);
			require_once APPPATH . "libraries/sendgrid/sendgrid-php.php";
			$email = new \SendGrid\Mail\Mail();
			$subj = $m['subject'];
			$html = file_get_contents(APPPATH . "libraries/advisement.html");
			$html = str_replace('{{base_url}}', base_url(), $html);
			$html = str_replace('{{app_name}}', $this->config->item('site_settings')['default_app'], $html);
			$html = str_replace('{{company_name}}', $this->config->item('site_settings')['company_name'], $html);
			$html = str_replace('{{content}}', $m['content'], $html);

			$email->setFrom("developer@at-appmaker.com", $this->config->item('site_settings')['company_name']);
			$email->setSubject($subj);
//			$email->addBccs($this->viewParams['bcc_emails']);
//			$email->addBccs(['arvid@at-creative.com']);
			$email->addTo('arvid@at-creative.com');

			$email->addContent(
				"text/html", $html
			);
			$sendgrid = new \SendGrid('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');
			try {
				$response = $sendgrid->send($email);
				$errno = 0;
			} catch (Exception $e) {
				$errno = 1;
			}
			$this->viewParams['errno'] = $errno;
			if ($errno == 0) {
				$this->viewParams['alert_message'] = "推廣電郵已成功發送";
			}
			else {
				$this->viewParams['alert_message'] = "推廣電郵發送不成功";
			}
		}
		$id = $this->uri->segment(4);
		$this->viewParams['breadcrumb'][] = [
			'name' => '推廣電郵管理',
			'url' => base_url('at-admin/email'),
		];
		$this->viewParams['breadcrumb'][] = [
			'name' => '發送推廣電郵',
			'url' => '#',
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/jquery.hotkeys.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/prettify.js'),
		];
		$this->viewParams['jses'][] = [
			'type' => '',
			'url' => base_url('assets/js/editors/wysiwyg/bootstrap-wysiwyg.js'),
		];
//		$this->load->model('Landing_model', 'landing');
		$data = [
			'controller' => $this->router->fetch_class(),
			'action' => $this->router->fetch_method(),
//			'landings' => $this->landing->all(),
			'email' => $this->email->one($id),
		];
		$this->load->view('at-admin/index', array_merge($this->viewParams, $data));
	}

	public function delete($id = 0)
	{
		if ($id != 0) {
			$errno = $this->email->remove($id);
		}
		redirect('at-admin/email');
	}

}
