<?php

use app\libraries\Json;

defined('BASEPATH') or exit('No direct script access allowed');

class Student extends MY_ApiController
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('User_Model','User_model');
	}

	public function getfilteringdata()
	{
		$data = $this->User_model->allforlist();
		echo json_encode(['success' => true, 'data' => $data, JSON_UNESCAPED_UNICODE]);
	}

	public function deletebulk(){
		$ids = $this->input->post('ids');
		if(!empty($ids)){
			$this->User_model->deletebulk($ids);
			echo json_encode(['success' => true, JSON_UNESCAPED_UNICODE]);
		}
	}


	public function listing()
	{
		$request = $this->input->get();
		$data = $this->User_model->listing_student($request);
		echo json_encode($this->User_model->build_datatables($request['draw'], $this->User_model->totalCount_student(), $this->User_model->filteredCount_student($request), $data), JSON_UNESCAPED_UNICODE);
	}

	public function detail()
	{
		$request = $this->input->get();
		$data = $this->User_model->detail($request['id']);
	}

	private function download_send_headers($filename) {
		// disable caching
		$now = gmdate("D, d M Y H:i:s");
		header("Expires: Tue, 03 Jul 2001 06:00:00 GMT");
		header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
		header("Last-Modified: {$now} GMT");

		// force download
		header("Content-Type: application/force-download");
		header("Content-Type: application/octet-stream");
		header("Content-Type: application/download");

		// disposition / encoding on response body
		header("Content-Disposition: attachment;filename={$filename}");
		header("Content-Transfer-Encoding: binary");
	}

	private function array2csv(array &$array)
	{
		if (count($array) == 0) {
			return null;
		}
		ob_start();
		$df = fopen("php://output", 'w');
		fputcsv($df, array_keys(reset($array)));
		foreach ($array as $row) {
			fputcsv($df, $row);
		}
		fclose($df);
		return ob_get_clean();
	}

	public function export()
	{
		$student = $this->User_model->all(['display_name as fullname', 'chi_lastname as lastname', 'chi_firstname as firstname', 'mobile', 'email']);
		$this->download_send_headers("data_export_" . date("Y-m-d") . ".csv");
		echo $this->array2csv($student);
		die();
	}

	public function getformdata()
	{
		$id = $this->input->get('id');
		$data = $this->Student_Model->getformdata($id);
		$data->formdate = date('Y-m-d', strtotime($data->formdate));
		$data->studentdob = date('Y-m-d', strtotime($data->studentdob));
		echo json_encode(['success' => true, 'data' => ['data' => $data]], JSON_UNESCAPED_UNICODE);
	}
	public function getformdataresult_pri(){
		$id = $this->input->get('id');
		$data = $this->Student_Model->getformdata($id);
		$data->formdate = date('Y-m-d', strtotime($data->formdate));
		$data->studentdob = date('Y-m-d', strtotime($data->studentdob));
		$testresult=$this->Student_Model->gettestresult_primary($id);
		$result=array();
		foreach($testresult as $item){
			$result[]=$item;
		}
		echo json_encode(['success' => true,'data'=>$data,'result'=>$result], JSON_UNESCAPED_UNICODE);
	}

	public function getformdata_sec()
	{
		$id = $this->input->get('id');
		$data = $this->Student_Model->getformdata($id);
		$data->formdate = date('Y-m-d', strtotime($data->formdate));
		$data->studentdob = date('Y-m-d', strtotime($data->studentdob));

//		log_message('debug','id:'.$id);
		$result = $this->Student_Model->gettestresult($id,true);
//		print_r($result);
//		log_message('debug','empty result?'.empty($result));
		$result_read_ar = array();
		$result_write_ar = array();
		$result_comp_ar = array();
		foreach($result as $k=>$item){
			if(substr($k,0,4)==='read'){
//				log_message('debug','read:'.$item);
				$result_read_ar[]=$item;
			}
			if(substr($k,0,5)==='write'){
//				log_message('debug','write:'.$item);
				$result_write_ar[]=$item;
			}if(substr($k,0,4)==='comp'){
//				log_message('debug','comp:'.$item);
				$result_comp_ar[]=$item;
			}
		}
		$result=array_merge(array('average'=>0),$result);
		$result=array_merge(array('difficulty'=>false),$result);
//		print_r($result['average']);
		$count_for_6=0;
		$count_for_6_ar = array("read" => 0, "write" => 0, "comp" => 0);

		foreach ($result_read_ar as $item) {
			if ($item == 6) {
				$count_for_6++;
				$count_for_6_ar["read"]++;
			}
		}
		foreach ($result_write_ar as $item) {
			if ($item == 6) {
				$count_for_6++;
				$count_for_6_ar["write"]++;
			}
		}
		foreach ($result_comp_ar as $item) {
			if ($item == 6) {
				$count_for_6++;
				$count_for_6_ar["comp"]++;
			}
		}

		$total_q_num = 25;
		$average_line = 2.6;

		$total_6 = 0;//don't know or not applicable
		$total = 0;

		foreach ($result_read_ar as $item) {
			if ($item == 6) {
				$total_6++;
			} else {
				$total += $item;
			}
		}
		foreach ($result_write_ar as $item) {
			if ($item == 6) {
				$total_6++;
			} else {
				$total += $item;
			}
		}
		foreach ($result_comp_ar as $item) {
			if ($item == 6) {
				$total_6++;
			} else {
				$total += $item;
			}
		}
		$average = round($total / ($total_q_num - $total_6), 2);

		$difficulty = $average >= $average_line;

		$result['average']=$average;
		$result['difficulty']=$difficulty;
		echo json_encode(['success' => true, 'data' => ['data' => $data, 'result' => $result]], JSON_UNESCAPED_UNICODE);
	}

	public function formsubmit_primary()
	{
		$arr = array();
		$arr['school'] = $this->input->post('school');
		$arr['testername'] = $this->input->post('testername');
		$arr['studentname'] = $this->input->post('studentname');
		$arr['formdate'] = $this->input->post('formdate');
		$arr['gender'] = $this->input->post('gender');
		log_message('debug','gender#pri:'.$arr['gender']);
		$arr['studentdob'] = $this->input->post('studentdob');
		$arr['studentclass'] = $this->input->post('studentclass');
		$arr['studentid'] = $this->input->post('studentid');
		$arr['s_age'] = $this->input->post('s_age');
		$arr['s_age_m'] = $this->input->post('s_age_m');
		$arr['email'] = $this->input->post('email');
		$arr['phone'] = $this->input->post('phone');
		$arr['remark'] = $this->input->post('remark');
		$this->load->model('Student_Model');
		$id = $this->Student_Model->formsubmit($arr);
		echo json_encode(['success' => true, 'data' => ['id' => $id]], JSON_UNESCAPED_UNICODE);
	}

	public function testsubmit_primary()
	{
		$id = $this->input->post('id');
		$arr['score'] = $this->input->post('score');
		$arr['comments'] = $this->input->post('comments');
		$answers = $this->input->post('answers');
//		print_r($answers);
		$arr_test=array();
		if(isset($answers[0])){
			for($i=0;$i<count($answers);$i++){
				$arr_test['answer_'.($i+1)]=$answers[$i];
			}
			$this->load->model('Student_Model');
			$this->Student_Model->testsubmit($id, $arr,$arr_test);

		}

		echo json_encode(['success' => true], JSON_UNESCAPED_UNICODE);
	}

	public function formsubmit_secondary()
	{
		$arr = array();
		$arr['school'] = $this->input->post('school');
		$arr['testername'] = $this->input->post('testername');
		$arr['studentname'] = $this->input->post('studentname');
		$arr['formdate'] = $this->input->post('formdate');
		$arr['gender'] = $this->input->post('gender');
		log_message('debug','gender#sec:'.$arr['gender']);
		$arr['studentdob'] = $this->input->post('studentdob');
		$arr['studentclass'] = $this->input->post('studentclass');
		$arr['studentid'] = $this->input->post('studentid');
		$arr['s_age'] = $this->input->post('s_age');
		$arr['s_age_m'] = $this->input->post('s_age_m');
		$arr['email'] = $this->input->post('email');
		$arr['phone'] = $this->input->post('phone');
		$arr['remark'] = $this->input->post('remark');
		$this->load->model('Student_Model');
		$id = $this->Student_Model->formsubmit_sec($arr);
		echo json_encode(['success' => true, 'data' => ['id' => $id]], JSON_UNESCAPED_UNICODE);
	}

	public function testsubmit_read()
	{
		$read = $this->input->post('read');
		$id = $this->input->post('id');
		for ($i = 1; $i <= 9; $i++) {
//			log_message('debug','read:'.$read[$i]);
			$arr['read_' . $i] = $read[$i];
		}
		$this->Student_Model->testsubmit_sec($id, $arr);
		echo json_encode(['success' => true], JSON_UNESCAPED_UNICODE);
	}

	public function testsubmit_write()
	{
		$write = $this->input->post('write');
		$id = $this->input->post('id');
		for ($i = 1; $i <= 12; $i++) {
			$arr['write_' . $i] = $write[$i];
		}
		$this->Student_Model->testsubmit_sec($id, $arr);
		echo json_encode(['success' => true], JSON_UNESCAPED_UNICODE);
	}

	public function testsubmit_comp()
	{
		$comp = $this->input->post('comp');
		$id = $this->input->post('id');
		for ($i = 1; $i <= 4; $i++) {
			$arr['comp_' . $i] = $comp[$i];
		}
		$this->Student_Model->testsubmit_sec($id, $arr);
		echo json_encode(['success' => true], JSON_UNESCAPED_UNICODE);
	}

	public function gettestresult_primary(){
		$id=$this->input->get('id');
		$testresult=$this->Student_Model->gettestresult_primary($id);
//		print_r($testresult);
		echo json_encode(['success' => true,'data'=>$testresult], JSON_UNESCAPED_UNICODE);
	}

}
//echo json_encode(['success' => true, 'data' => []], JSON_UNESCAPED_UNICODE);
