<?php

use app\libraries\Json;

defined('BASEPATH') or exit('No direct script access allowed');

class Media extends MY_ApiController
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Media_model', 'media');
	}

	public function getfilteringdata()
	{
		$data = $this->media->allforlist();
		echo json_encode(['success' => true, 'data' => $data, JSON_UNESCAPED_UNICODE]);
	}

	public function listing()
	{
		$request = $this->input->get();
		$data = $this->media->listing($request);
		echo json_encode($this->media->build_datatables($request['draw'], $this->media->totalCount(), $this->media->filteredCount($request), $data), JSON_UNESCAPED_UNICODE);
	}

	public function detail()
	{
		$request = $this->input->get();
		$data = $this->media->detail($request['id']);
	}

	public function submit()
	{
		$request = $this->input->get();
		$this->media->create($request);
		echo json_encode(['success' => true, 'data' => [], JSON_UNESCAPED_UNICODE]);
	}
}
