<?php

use app\libraries\Json;

defined('BASEPATH') or exit('No direct script access allowed');

class Landing extends MY_ApiController
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Landing_model', 'Landing_model');
	}

	public function getfilteringdata()
	{
		$data = $this->Landing_model->allforlist();
		echo json_encode(['success' => true, 'data' => $data, JSON_UNESCAPED_UNICODE]);
	}

	public function listing()
	{
		$request = $this->input->get();
		$data = $this->Landing_model->listing($request);
		echo json_encode($this->Landing_model->build_datatables($request['draw'], $this->Landing_model->totalCount(), $this->Landing_model->filteredCount($request), $data), JSON_UNESCAPED_UNICODE);
	}

	public function detail()
	{
		$request = $this->input->get();
		$data = $this->Landing_model->detail($request['id']);
	}

	public function get_html()
	{
		$request = $this->input->get();
		if (! $request) {
			echo '';
			exit;
		}
		if (! array_key_exists('token', $request)) {
			echo '';
			exit;
		}
//		$html = $this->Landing_model->get_html_by_token($request['token']);
//		$html = str_replace('{hostname}', base_url(), $html);
//		echo $html;
		echo $this->load->view('front/landing/pages/' . $request['token'], [], true);
	}

	private function replace_php_code($html)
	{
		/* find the hash */
		$hash = '';
		$count = preg_match_all('#<script (?:.+)?src="([^"]+)">#', $html, $match);
		if ($count !== FALSE) {
			foreach ($match[1] as $url) {
				if (substr(str_replace(base_url('assets/templates/landing/assets/js/'), '', $url), 0, 9) == 'common.js') {
					list ($url, $hash) = explode('?', $url);
					break;
				}
			}
		}
//		preg_match_all('#<script(.*?)</script>#is', $html, $matches);
//		foreach ($matches as $match) {
//			print_r ($match);
//			$tmp = trim($match);
//			if (substr($tmp, 0, 3) == 'src') {
//				list($url, $token) = explode('?', preg_replace('/src="(.*)">/', '$1', $tmp));
//				break;
//			}
//		}
		$patterns = [
			'/let base_url = "(.*)";/',
			'/let seminar_title = "(.*)";/',
			'/let times = (.*);/',
		];
		$replacements = [
			'let base_url = "<?=base_url();?>";',
			'let seminar_title = "<?=$landing[\'title\'];?>";',
			'let times = <?=$times;?>;',
		];
		$html = preg_replace($patterns, $replacements, $html);
		$html = str_replace(base_url(), '<?=base_url();?>', $html);
		return str_replace($hash, '<?=$hash;?>', $html);
	}

	public function save_html($token)
	{
		$request = $this->input->post();
		$html = $request['html'];

//		$this->replace_php_code($html);
		$fp = fopen(VIEWPATH . 'front/landing/pages/' . $token . '.php', 'w');
		fwrite($fp, $this->replace_php_code($html));
		fclose($fp);
		echo "File saved successful.";
	}

	public function toggle_status()
	{
		$request = $this->input->get();
		if (! $request) {
			echo json_encode(['success' => false, JSON_UNESCAPED_UNICODE]);
			exit;
		}
		if (! array_key_exists('id', $request)) {
			echo json_encode(['success' => false, JSON_UNESCAPED_UNICODE]);
			exit;
		}
		$data = ['id' => $request['id'], 'available' => $this->Landing_model->toggle_status($request['id'])];
		echo json_encode(['success' => true, 'data' => $data], JSON_UNESCAPED_UNICODE);
	}

	public function deletebulk(){
		$ids = $this->input->post('ids');
		if(!empty($ids)){
			$this->Landing_model->deletebulk($ids);
			echo json_encode(['success' => true, JSON_UNESCAPED_UNICODE]);
		}
	}

	public function getformdata()
	{
		$id = $this->input->get('id');
		$data = $this->Landing_model->getformdata($id);
		$data->formdate = date('Y-m-d', strtotime($data->formdate));
		$data->studentdob = date('Y-m-d', strtotime($data->studentdob));
		echo json_encode(['success' => true, 'data' => ['data' => $data]], JSON_UNESCAPED_UNICODE);
	}
	public function getformdataresult_pri(){
		$id = $this->input->get('id');
		$data = $this->Landing_model->getformdata($id);
		$data->formdate = date('Y-m-d', strtotime($data->formdate));
		$data->studentdob = date('Y-m-d', strtotime($data->studentdob));
		$testresult=$this->Landing_model->gettestresult_primary($id);
		$result=array();
		foreach($testresult as $item){
			$result[]=$item;
		}
		echo json_encode(['success' => true,'data'=>$data,'result'=>$result], JSON_UNESCAPED_UNICODE);
	}

	public function getformdata_sec()
	{
		$id = $this->input->get('id');
		$data = $this->Landing_model->getformdata($id);
		$data->formdate = date('Y-m-d', strtotime($data->formdate));
		$data->studentdob = date('Y-m-d', strtotime($data->studentdob));

//		log_message('debug','id:'.$id);
		$result = $this->Landing_model->gettestresult($id,true);
//		print_r($result);
//		log_message('debug','empty result?'.empty($result));
		$result_read_ar = array();
		$result_write_ar = array();
		$result_comp_ar = array();
		foreach($result as $k=>$item){
			if(substr($k,0,4)==='read'){
//				log_message('debug','read:'.$item);
				$result_read_ar[]=$item;
			}
			if(substr($k,0,5)==='write'){
//				log_message('debug','write:'.$item);
				$result_write_ar[]=$item;
			}if(substr($k,0,4)==='comp'){
//				log_message('debug','comp:'.$item);
				$result_comp_ar[]=$item;
			}
		}
		$result=array_merge(array('average'=>0),$result);
		$result=array_merge(array('difficulty'=>false),$result);
//		print_r($result['average']);
		$count_for_6=0;
		$count_for_6_ar = array("read" => 0, "write" => 0, "comp" => 0);

		foreach ($result_read_ar as $item) {
			if ($item == 6) {
				$count_for_6++;
				$count_for_6_ar["read"]++;
			}
		}
		foreach ($result_write_ar as $item) {
			if ($item == 6) {
				$count_for_6++;
				$count_for_6_ar["write"]++;
			}
		}
		foreach ($result_comp_ar as $item) {
			if ($item == 6) {
				$count_for_6++;
				$count_for_6_ar["comp"]++;
			}
		}

		$total_q_num = 25;
		$average_line = 2.6;

		$total_6 = 0;//don't know or not applicable
		$total = 0;

		foreach ($result_read_ar as $item) {
			if ($item == 6) {
				$total_6++;
			} else {
				$total += $item;
			}
		}
		foreach ($result_write_ar as $item) {
			if ($item == 6) {
				$total_6++;
			} else {
				$total += $item;
			}
		}
		foreach ($result_comp_ar as $item) {
			if ($item == 6) {
				$total_6++;
			} else {
				$total += $item;
			}
		}
		$average = round($total / ($total_q_num - $total_6), 2);

		$difficulty = $average >= $average_line;

		$result['average']=$average;
		$result['difficulty']=$difficulty;
		echo json_encode(['success' => true, 'data' => ['data' => $data, 'result' => $result]], JSON_UNESCAPED_UNICODE);
	}

	public function formsubmit_primary()
	{
		$arr = array();
		$arr['school'] = $this->input->post('school');
		$arr['testername'] = $this->input->post('testername');
		$arr['studentname'] = $this->input->post('studentname');
		$arr['formdate'] = $this->input->post('formdate');
		$arr['gender'] = $this->input->post('gender');
		log_message('debug','gender#pri:'.$arr['gender']);
		$arr['studentdob'] = $this->input->post('studentdob');
		$arr['studentclass'] = $this->input->post('studentclass');
		$arr['studentid'] = $this->input->post('studentid');
		$arr['s_age'] = $this->input->post('s_age');
		$arr['s_age_m'] = $this->input->post('s_age_m');
		$arr['email'] = $this->input->post('email');
		$arr['phone'] = $this->input->post('phone');
		$arr['remark'] = $this->input->post('remark');
		$this->load->model('Landing_model');
		$id = $this->Landing_model->formsubmit($arr);
		echo json_encode(['success' => true, 'data' => ['id' => $id]], JSON_UNESCAPED_UNICODE);
	}

	public function testsubmit_primary()
	{
		$id = $this->input->post('id');
		$arr['score'] = $this->input->post('score');
		$arr['comments'] = $this->input->post('comments');
		$answers = $this->input->post('answers');
//		print_r($answers);
		$arr_test=array();
		if(isset($answers[0])){
			for($i=0;$i<count($answers);$i++){
				$arr_test['answer_'.($i+1)]=$answers[$i];
			}
			$this->load->model('Landing_model');
			$this->Landing_model->testsubmit($id, $arr,$arr_test);

		}

		echo json_encode(['success' => true], JSON_UNESCAPED_UNICODE);
	}

	public function formsubmit_secondary()
	{
		$arr = array();
		$arr['school'] = $this->input->post('school');
		$arr['testername'] = $this->input->post('testername');
		$arr['studentname'] = $this->input->post('studentname');
		$arr['formdate'] = $this->input->post('formdate');
		$arr['gender'] = $this->input->post('gender');
		log_message('debug','gender#sec:'.$arr['gender']);
		$arr['studentdob'] = $this->input->post('studentdob');
		$arr['studentclass'] = $this->input->post('studentclass');
		$arr['studentid'] = $this->input->post('studentid');
		$arr['s_age'] = $this->input->post('s_age');
		$arr['s_age_m'] = $this->input->post('s_age_m');
		$arr['email'] = $this->input->post('email');
		$arr['phone'] = $this->input->post('phone');
		$arr['remark'] = $this->input->post('remark');
		$this->load->model('Landing_model');
		$id = $this->Landing_model->formsubmit_sec($arr);
		echo json_encode(['success' => true, 'data' => ['id' => $id]], JSON_UNESCAPED_UNICODE);
	}

	public function testsubmit_read()
	{
		$read = $this->input->post('read');
		$id = $this->input->post('id');
		for ($i = 1; $i <= 9; $i++) {
//			log_message('debug','read:'.$read[$i]);
			$arr['read_' . $i] = $read[$i];
		}
		$this->Landing_model->testsubmit_sec($id, $arr);
		echo json_encode(['success' => true], JSON_UNESCAPED_UNICODE);
	}

	public function testsubmit_write()
	{
		$write = $this->input->post('write');
		$id = $this->input->post('id');
		for ($i = 1; $i <= 12; $i++) {
			$arr['write_' . $i] = $write[$i];
		}
		$this->Landing_model->testsubmit_sec($id, $arr);
		echo json_encode(['success' => true], JSON_UNESCAPED_UNICODE);
	}

	public function testsubmit_comp()
	{
		$comp = $this->input->post('comp');
		$id = $this->input->post('id');
		for ($i = 1; $i <= 4; $i++) {
			$arr['comp_' . $i] = $comp[$i];
		}
		$this->Landing_model->testsubmit_sec($id, $arr);
		echo json_encode(['success' => true], JSON_UNESCAPED_UNICODE);
	}

	public function gettestresult_primary(){
		$id=$this->input->get('id');
		$testresult=$this->Landing_model->gettestresult_primary($id);
//		print_r($testresult);
		echo json_encode(['success' => true,'data'=>$testresult], JSON_UNESCAPED_UNICODE);
	}

}
//echo json_encode(['success' => true, 'data' => []], JSON_UNESCAPED_UNICODE);
