<?php

use app\libraries\Json;

defined('BASEPATH') or exit('No direct script access allowed');

class Booking extends MY_ApiController
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Booking_model', 'booking');
	}

	public function getfilteringdata()
	{
		$data = $this->booking->allforlist();
		echo json_encode(['success' => true, 'data' => $data, JSON_UNESCAPED_UNICODE]);
	}

	public function listing()
	{
		$request = $this->input->get();
		$data = $this->booking->listing($request);
		echo json_encode($this->booking->build_datatables($request['draw'], $this->booking->totalCount(), $this->booking->filteredCount($request), $data), JSON_UNESCAPED_UNICODE);
	}

	public function detail()
	{
		$request = $this->input->get();
		$data = $this->booking->detail($request['id']);
	}

	public function submit()
	{
		$request = $this->input->get();
		$this->booking->create($request);
		echo json_encode(['success' => true, 'data' => [], JSON_UNESCAPED_UNICODE]);
	}
}
