<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Webinar extends MY_Controller1 {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index($access_token)
	{
		if (! $access_token) {
			echo "<h1>Access Denied</h1>";
			exit;
		}
		$this->load->model('Applicant_model', 'applicant');
		$applicant = $this->applicant->token_search($access_token);
		if (! $applicant) {
			echo "<h1>Invalid access token</h1>";
			exit;
		}
		if ($applicant['webinar_id'] == 0) {
			echo "<h1>Invalid Webinar</h1>";
			exit;
		}
		$this->session->set_userdata('applicant', $applicant);
		$this->load->model('User_Model', 'user');
//		$user = $this->user->one($applicant['user_id']);
		$this->load->model('Webinar_model', 'webinar');
		$webinar = $this->webinar->webinar_detail($applicant['webinar_id']);
		$speaker = $this->user->detail($webinar['speaker_id']);
		$this->load->model('Chat_model', 'chat');
		$chat = $this->chat->all($webinar['id']);
		$this->load->view('front/webinar/index', array_merge($this->viewParams, [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Webinar page - ' . $webinar['title'],
			'vendors' => [
				'css' => [
				],
				'js' => [
					'https://player.vimeo.com/api/player.js',
				],
			],
			'class' => $this->router->class,
			'module' => '',
			'token' => random_string(10),
			'webinar' => [
				'webinar_token' => $webinar['webinar_token'],
				'access_token' => $access_token,
				'title' => $webinar['title'],
				'date' => $applicant['application_date'],
				'vimeo_id' => $webinar['vimeo_id'],
				'applicant' => $applicant,
				'speaker' => $speaker,
				'num_of_applicants' => $webinar['num_of_applicants'],
				'chat_history' => $chat,
			],
		]));
	}
}
