<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Selling extends MY_Controller1 {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		if (! $this->uri->segment(3)) {
			echo "<h1>Access Denied</h1>";
			exit;
		}
	}

	public function promote()
	{
		if (! $this->uri->segment(3)) {
			echo "<h1>Access Denied</h1>";
			exit;
		}
		$token = $this->uri->segment(3);
		$this->load->model('Applicant_model', 'applicant');
		$applicant = $this->applicant->token_search($token);
		if (! $applicant) {
			echo "<h1>Invalid token</h1>";
			exit;
		}
		$this->load->model('Webinar_model', 'webinar');
		$webinar = $this->webinar->detail($applicant['webinar_id']);
		if (! $webinar) {
			echo "<h1>Invalid token</h1>";
			exit;
		}
		if ($webinar['course_id'] == 0) {
			echo "<h1>Invalid course</h1>";
			exit;
		}
		$this->load->model('Course_Model', 'course');
		$course = $this->course->detail($webinar['course_id']);
		$this->load->view('front/selling/index', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Webinar page - ',
			'vendors' => [
				'css' => [
				],
				'js' => [
				],
			],
			'class' => $this->router->class,
			'module' => '',
			'token' => $this->webinar->random_string(10),
			'stripe' => $this->config->item('stripe')['publishable_key'],
			'webinar' => $webinar,
			'course' => $course,
			'access_token' => $token,
			'promotion' => [
			],
		]);
	}

	public function confirm_payment()
	{
		if (! $this->uri->segment(3)) {
			echo "<h1>Access Denied</h1>";
			exit;
		}
		$token = $this->uri->segment(3);
		$this->load->model('Applicant_model', 'applicant');
		$applicant = $this->applicant->token_search($token);
		if (! $applicant) {
			echo "<h1>Invalid token</h1>";
			exit;
		}
		$this->load->model('Webinar_model', 'webinar');
		$webinar = $this->webinar->detail($applicant['webinar_id']);
		if (! $webinar) {
			echo "<h1>Invalid token</h1>";
			exit;
		}
		if ($webinar['course_id'] == 0) {
			echo "<h1>Invalid course</h1>";
			exit;
		}
		$this->load->model('Course_Model', 'course');
		$course = $this->course->detail($webinar['course_id']);
		$this->load->view('front/selling/confirm_payment', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Webinar page - ',
			'vendors' => [
				'css' => [
				],
				'js' => [
				],
			],
			'class' => $this->router->class,
			'module' => '',
			'token' => $this->webinar->random_string(10),
			'webinar' => $webinar,
			'course' => $course,
			'stripe' => $this->config->item('stripe')['publishable_key'],
			'access_token' => $token,
			'promotion' => [
			],
		]);
	}

	public function success()
	{
		$this->load->model('Applicant_model', 'applicant');
		$user_id = $this->applicant->purchased($this->input->get('session_id'));
		$this->load->model('Webinar_model', 'webinar');
		$this->load->view('front/selling/success', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Webinar page - ',
			'vendors' => [
				'css' => [
				],
				'js' => [
				],
			],
			'class' => $this->router->class,
			'token' => $this->webinar->random_string(10),
			'module' => '',
		]);
	}

	public function fail()
	{
		$this->load->model('Webinar_model', 'webinar');
		$this->load->view('front/selling/fail', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Webinar page - ',
			'vendors' => [
				'css' => [
				],
				'js' => [
				],
			],
			'class' => $this->router->class,
			'token' => $this->webinar->random_string(10),
			'module' => '',
		]);
	}

}
