<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Register extends MY_Controller1 {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		if (! $this->uri->segment(3)) {
			echo "<h1>Access Denied</h1>";
			exit;
		}
	}

	public function apply()
	{
		if (! $this->uri->segment(3)) {
			echo "<h1>Access Denied</h1>";
			exit;
		}
		$this->load->model('Landing_model', 'landing');
		$title = urldecode($this->uri->segment(3));
		$landing = $this->landing->getLandingPage($title);
		if (! $landing) {
			echo "<h1>Invalid access token</h1>";
			exit;
		}
		$webinar = [];
		if ($landing['webinar_id'] != 0) {
			$this->load->model('Webinar_model', 'webinar');
			$webinar = $this->webinar->detail($landing['webinar_id']);
		}
//		$cache_path = 'front/landing/cache';
//		$view_path = VIEWPATH . $cache_path;
//		if (! file_exists($view_path)) {
//			mkdir($view_path);
//		}
//		$script = 'let seminar_token = "' . $token . '";' . PHP_EOL;
//		if (count($webinar) != 0) {
//			$times = '["' . date('H:i', strtotime($webinar['time1'])) . '", "' . date('H:i', strtotime($webinar['time2'])) . '", "' . date('H:i', strtotime($webinar['time3'])) . '"]';
//		}
//		else {
//			$times = '["11:00", "15:00", "20:00"]';
//		}
//		$landing_page = str_replace('{hostname}', base_url(), $landing['landing_page']);
//		$landing_page = str_replace('{token}', $this->Landing_model->random_string(10), $landing_page);
//		$landing_page = str_replace('{extra_script}', $script, $landing_page);
//		if (file_exists($view_path . '/' . $token . '.php')) {
//			unlink($view_path . '/' . $token . '.php');
//		}
//		file_put_contents($view_path . '/' . $token . '.php', $landing_page);
		$times = [];
		if (count($webinar) != 0) {
			$times[] = date('H:i', strtotime($webinar['time1']));
			$times[] = date('H:i', strtotime($webinar['time2']));
			$times[] = date('H:i', strtotime($webinar['time3']));
		}
		else {
			$times[] = "11:00";
			$times[] = "15:00";
			$times[] = "20:00";
		}
		$this->load->view('front/register/index', array_merge($this->viewParams, [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Register page',
			'vendors' => [
				'css' => [
				],
				'js' => [
				],
			],
			'class' => $this->router->class,
			'module' => '',
//			'token' => random_string(10),
			'seminar_title' => $title,
			'times' => json_encode($times),
		]));
	}
}
