<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Member extends CI_Controller
{

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		$this->load->view('member/login', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [],
				'js' => [],
			],
			'class' => $this->router->method,
		]);
	}

	public function checkuser()
	{
		$email = $this->input->post("email");
		$password = $this->input->post("password");

		// for debug use
		/* echo "<pre>";
		var_dump($this->input->post());
		echo "</pre>"; */



		$this->load->model('User_Model', 'User_model');


		if ($this->User_model->validation($email, $password)) {
			header('location: ' . base_url() . 'member/dashboard');
		} else
			$this->index();
	}


	public function dashboard()
	{
		$this->checkUserSession();
		$this->load->view('member/includes/main', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [],
				'js' => [],
			],
			'class' => $this->router->method,
			'breadcrumb' => [
				[
					'link' => base_url() . 'member/dashboard',
					'name' => '會員區',
				],
			],
		]);
	}

	public function course()
	{

		$this->checkUserSession();
		$this->load->model('Course_Model', 'Course_model');
		$courses = $this->Course_model->getAllCourses($_SESSION['user_info']['id']);
		$this->load->view('member/includes/main', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [],
				'js' => [],
			],
			'class' => $this->router->method,
			'breadcrumb' => [
				[
					'link' => base_url() . 'member/dashboard',
					'name' => '會員區',
				],
				[
					'link' => '',
					'name' => '課程記錄',
				],
			],
			'courses' => $courses,
		]);
	}

	public function start_course()
	{
		$this->checkUserSession();
		$this->load->model('Course_Model', 'Course_model');
		$request = $this->input->get();
		$courses = $this->Course_model->startCourse($request['id']);
		if (array_key_exists('chapter', $request)) {
			$chapter = $request['chapter'];
		}
		else {
			$chapter = 0;
		}
		$this->Course_model->updateViewRecord([
			'course_id' => $request['id'],
			'unit_num' => $chapter,
		]);
		$this->load->view('member/includes/main', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [],
				'js' => [],
			],
			'class' => $this->router->method,
			'breadcrumb' => [
				[
					'link' => base_url() . 'member/dashboard',
					'name' => '會員區',
				],
				[
					'link' => base_url() . 'member/course',
					'name' => '課程記錄',
				],
				[
					'link' => '',
					'name' => '課程',
				],
			],
			'course' => $courses,
			'chapter' => $chapter,
		]);
	}

	public function note()
	{
		$this->checkUserSession();
		$this->load->model('Note_Model', 'Note_model');
		$notes = $this->Note_model->getAllNotes($_SESSION['user_info']['id']);
		$this->load->view('member/includes/main', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [],
				'js' => [],
			],
			'class' => $this->router->method,
			'breadcrumb' => [
				[
					'link' => base_url() . 'member/dashboard',
					'name' => '會員區',
				],
				[
					'link' => '',
					'name' => '筆記記錄',
				],
			],
			'notes' => $notes,
		]);
	}

	public function account()
	{
		$this->checkUserSession();
		$this->load->model('User_Model', 'User_model');

		$userInfo = $this->User_model->getUser();



		$this->load->view('member/includes/main', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [],
				'js' => [],
			],
			'class' => $this->router->method,
			'breadcrumb' => [
				[
					'link' => base_url() . 'member/dashboard',
					'name' => '會員區',
				],
				[
					'link' => '',
					'name' => '帳戶資料',
				],
			],
			'userInfoObject' => $userInfo
		]);
	}
	public function checkUserSession()
	{

		if (!$this->session->has_userdata('user_info')) {
			header('location: ' . base_url());
		}
	}

	public function changeAccountInformation()
	{
		# code...
		$this->checkUserSession();

		// $firstname = $this->input->post("firstname");
		// $lastname = $this->input->post("lastname");
		// $email = $this->input->post("email");
		// $phone = $this->input->post("phone");

		// $password = $this->input->post("password");
		// $rpassword = $this->input->post("rpassword");



		$this->load->model('User_Model', 'User_model');
		$this->User_model->editAccountInformation($this->input->post());
		$this->load->view('member/account/updated');

		// if (isset($firstname) || isset($lastname) || isset($email) || isset($password)) {
		// 	$this->User_model->editAccountInformation($firstname, $lastname, $email, $phone);
		// }

		// if (!empty($password) && !empty($rpassword) && ($password == $rpassword)) {

		// 	$this->User_model->checkConfirmPassword($rpassword);
		// 	var_dump($password, $rpassword);
		// 	var_dump(isset($password, $rpassword));
		// 	echo "changed";
		// } else {
		// 	// echo "false";
		// }

		
		// redirect('member/account');
	}

	public function forget_password() {
		$this->load->view('member/forget_password', [
			'base_url' => base_url(),
				'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
				'vendors' => [
				'css' => [],
				'js' => [],
			],
			'class' => $this->router->method,
		]);
	}

	public function send_password() {
		$request = $this->input->post();
		if (! array_key_exists('email', $request)) {
			header('location: ' . base_url() . 'member');
		}
		else {
			$this->load->model('User_Model', 'user');
			if ($this->user->forget_password($request['email'])) {
				$this->load->view('member/forget_password_success', [
					'base_url' => base_url(),
					'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
					'vendors' => [
						'css' => [],
						'js' => [],
					],
					'class' => $this->router->method,
				]);
			}
			else {
				$this->load->view('member/forget_password_fail', [
					'base_url' => base_url(),
					'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
					'vendors' => [
						'css' => [],
						'js' => [],
					],
					'class' => $this->router->method,
				]);
			}
		}
	}

	public function logout(){
	
		
		$this->session->sess_destroy();
		redirect(base_url());
	}
}
