<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Landing extends MY_Controller1 {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		$this->load->model('Landing_model', 'landing');
		$this->load->model('Enquiry_category_model', 'enquiry_category');
		$this->load->model('Booking_model', 'booking');
		$this->load->helper('common');
		if (! $this->uri->segment(3)) {
			$landing = $this->landing->getDefaultLandingPage();
		} else {
			$title = urldecode($this->uri->segment(3));
			$landing = $this->landing->getLandingPage($title);
			if (! $landing) {
				$landing = $this->landing->getDefaultLandingPage();
			}
		}
		$view_path = 'front/landing/pages';
		$this->load->view('front/landing/index', array_merge($this->viewParams, [
			'company_name' => $this->config->item('site_settings')['company_name'],
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [
				],
				'js' => [
				],
			],
			'class' => $this->router->class,
			'module' => '',
			'landing' => $landing,
			'enquiry_items' => $this->enquiry_category->all(),
			'age_range' => $this->booking->age_range,
		]));
	}

	public function template2()
	{
		$this->load->view('front/landing/index2', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [
				],
				'js' => [
				],
			],
			'class' => $this->router->class,
			'module' => '',
		]);
	}

	public function template3()
	{
		$this->load->view('front/landing/index3', [
			'base_url' => base_url(),
			'page_title' => $this->config->item('site_settings')['company_name'] . ' - Landing page',
			'vendors' => [
				'css' => [
				],
				'js' => [
				],
			],
			'class' => $this->router->class,
			'module' => '',
		]);
	}
}
